/*
 * Decompiled with CFR 0.152.
 */
package com.hypertrack.hyperlog.utils;

import android.text.TextUtils;
import com.hypertrack.hyperlog.HyperLog;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeUtility {
    private static final String TAG = DateTimeUtility.class.getSimpleName();
    public static final String HT_DATETIME_FORMAT_1 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String HT_DATETIME_FORMAT_2 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String HT_DATETIME_FORMAT_3 = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSZZZ";
    public static final String HT_DATETIME_FORMAT_4 = "yyyy-MM-dd'T'HH:mm:ssZZZ";
    public static final String HT_TIMEZONE_UTC = "UTC";

    public static String getCurrentTime() {
        String currentTime;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(HT_DATETIME_FORMAT_1, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone(HT_TIMEZONE_UTC));
            currentTime = dateFormat.format(new Date());
        }
        catch (Exception e) {
            HyperLog.e(TAG, "Exception while getCurrentTime: " + e);
            currentTime = "";
        }
        return currentTime != null ? currentTime : "";
    }

    public static String getFormattedTime(Date date) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(HT_DATETIME_FORMAT_1, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone(HT_TIMEZONE_UTC));
            return dateFormat.format(date);
        }
        catch (Exception e) {
            HyperLog.e(TAG, "Exception while getFormattedTime: " + e);
            return DateTimeUtility.getCurrentTime();
        }
    }

    public static Date getFormattedDate(String time) {
        if (TextUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(HT_DATETIME_FORMAT_1, Locale.US);
            format.setTimeZone(TimeZone.getTimeZone(HT_TIMEZONE_UTC));
            return format.parse(time);
        }
        catch (Exception e) {
            HyperLog.e(TAG, "Exception while getFormattedDate: " + e);
            return new Date();
        }
    }
}

