/*
 * Decompiled with CFR 0.152.
 */
package com.dhtmlx.xml2pdf;

import com.dhtmlx.xml2pdf.PDFColumn;
import com.dhtmlx.xml2pdf.PDFRow;
import com.pdfjet.A4;
import com.pdfjet.Letter;
import java.io.IOException;
import java.io.StringReader;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PDFXMLParser {
    Element root;
    PDFColumn[][] columns;
    PDFRow[] rows;
    double[] widths;
    private Boolean header = false;
    private Boolean footer = false;
    private Boolean without_header = false;
    private String profile = "gray";
    private float[] orientation = null;

    public void setXML(String xml, HttpServletResponse resp) throws IOException, DOMException, ParserConfigurationException, SAXException {
        String profile_string;
        String footer_string;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = null;
        try {
            dom = db.parse(new InputSource(new StringReader(xml)));
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.root = dom.getDocumentElement();
        String header_string = this.root.getAttribute("header");
        if (header_string != null && header_string.equalsIgnoreCase("true")) {
            this.header = true;
        }
        if ((footer_string = this.root.getAttribute("footer")) != null && footer_string.equalsIgnoreCase("true")) {
            this.footer = true;
        }
        if ((profile_string = this.root.getAttribute("profile")) != null) {
            this.profile = profile_string;
        }
        String orientation_string = this.root.getAttribute("orientation");
        this.getHeaderInfo();
        if (orientation_string != "") {
            this.orientation = orientation_string.equalsIgnoreCase("landscape") ? A4.LANDSCAPE : A4.PORTRAIT;
        } else {
            double sum_width = 0.0;
            for (int i = 0; i < this.widths.length; ++i) {
                sum_width += this.widths[i];
            }
            this.orientation = sum_width / (double)this.widths.length < 80.0 ? Letter.LANDSCAPE : Letter.PORTRAIT;
        }
        String w_header = this.root.getAttribute("without_header");
        if (w_header != null && w_header.equalsIgnoreCase("true")) {
            this.without_header = true;
        }
    }

    public PDFColumn[][] getHeaderInfo() {
        PDFColumn[] colLine = null;
        NodeList n1 = this.root.getElementsByTagName("columns");
        if (n1 != null && n1.getLength() > 0) {
            this.columns = new PDFColumn[n1.getLength()][];
            for (int i = 0; i < n1.getLength(); ++i) {
                Element cols = (Element)n1.item(i);
                NodeList n2 = cols.getElementsByTagName("column");
                if (n2 != null && n2.getLength() > 0) {
                    colLine = new PDFColumn[n2.getLength()];
                    for (int j = 0; j < n2.getLength(); ++j) {
                        Element col_xml = (Element)n2.item(j);
                        PDFColumn col = new PDFColumn();
                        col.parse(col_xml);
                        colLine[j] = col;
                    }
                }
                this.columns[i] = colLine;
            }
        }
        this.createWidthsArray();
        this.optimizeColumns();
        return this.columns;
    }

    private void createWidthsArray() {
        this.widths = new double[this.columns[0].length];
        for (int i = 0; i < this.columns[0].length; ++i) {
            this.widths[i] = this.columns[0][i].getWidth();
        }
    }

    private void optimizeColumns() {
        int j;
        int i;
        for (i = 1; i < this.columns.length; ++i) {
            for (j = 0; j < this.columns[i].length; ++j) {
                this.columns[i][j].setWidth(this.columns[0][j].getWidth());
            }
        }
        for (i = 0; i < this.columns.length; ++i) {
            for (j = 0; j < this.columns[i].length; ++j) {
                int k;
                if (this.columns[i][j].getColspan() > 0) {
                    for (k = j + 1; k < j + this.columns[i][j].getColspan(); ++k) {
                        this.columns[i][j].setWidth(this.columns[i][j].getWidth() + this.columns[i][k].getWidth());
                        this.columns[i][k].setWidth(0.0);
                    }
                }
                if (this.columns[i][j].getRowspan() <= 0) continue;
                for (k = i + 1; k < i + this.columns[i][j].getRowspan(); ++k) {
                    this.columns[i][j].setHeight(this.columns[i][j].getHeight() + 1);
                    this.columns[k][j].setHeight(0);
                }
            }
        }
    }

    public PDFRow[] getGridContent(HttpServletResponse resp) throws IOException {
        NodeList nodes = this.root.getElementsByTagName("row");
        if (nodes != null && nodes.getLength() > 0) {
            this.rows = new PDFRow[nodes.getLength()];
            for (int i = 0; i < nodes.getLength(); ++i) {
                this.rows[i] = new PDFRow();
                this.rows[i].parse(nodes.item(i), resp);
            }
        }
        return this.rows;
    }

    public double[] getWidths() {
        return this.widths;
    }

    public boolean getHeader() {
        return this.header;
    }

    public Boolean getFooter() {
        return this.footer;
    }

    public float[] getOrientation() {
        return this.orientation;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean getWithoutHeader() {
        return this.without_header;
    }
}

