/*
 * Decompiled with CFR 0.152.
 */
package com.dhtmlx.xml2pdf;

import com.dhtmlx.xml2pdf.PDFWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFGenerator
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(PDFGenerator.class);
    private String m_embedFontUri;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String xml = req.getParameter("grid_xml");
        xml = URLDecoder.decode(xml, "UTF-8");
        new PDFWriter(this.m_embedFontUri).generate(xml, resp);
    }

    public void init(ServletConfig config) throws ServletException {
        block13: {
            super.init(config);
            this.m_embedFontUri = config.getInitParameter("font");
            if (this.m_embedFontUri == null || (this.m_embedFontUri = this.m_embedFontUri.trim()).length() == 0) {
                String uri = "/com/hynnet/fonts/simfang.ttf";
                try {
                    InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(uri);
                    if (in == null) {
                        this.m_embedFontUri = "STHeitiSC-Light";
                        break block13;
                    }
                    this.m_embedFontUri = uri;
                    in.close();
                }
                catch (Exception e) {
                    this.m_embedFontUri = "STHeitiSC-Light";
                }
            } else if ("no".equalsIgnoreCase(this.m_embedFontUri) || "none".equalsIgnoreCase(this.m_embedFontUri)) {
                this.m_embedFontUri = "STHeitiSC-Light";
            } else if (this.m_embedFontUri.charAt(0) == '/') {
                try {
                    InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.m_embedFontUri);
                    if (in == null) {
                        this.m_embedFontUri = null;
                    } else {
                        in.close();
                    }
                }
                catch (Exception e) {
                    logger.error("\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53\u8d44\u6e90\uff1a{} {}", (Object)this.m_embedFontUri, (Object)e.getMessage());
                    this.m_embedFontUri = null;
                }
            }
        }
        if (this.m_embedFontUri != null && logger.isInfoEnabled()) {
            logger.info("pdf\u5b57\u4f53\uff1a{}", (Object)(this.m_embedFontUri.charAt(0) == '/' ? "\u5185\u5d4c" : ""), (Object)this.m_embedFontUri);
        }
    }
}

