/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mobilesdk.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleKt;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import com.hubspot.mobilesdk.HubspotManager;
import com.hubspot.mobilesdk.config.HubspotConfigError;
import com.hubspot.mobilesdk.errorhandling.NetworkError;
import com.hubspot.mobilesdk.firebase.PushNotificationChatData;
import com.hubspot.mobilesdk.usecases.CompileAndUploadMetaDataUseCase;
import com.hubspot.mobilesdk.widget.HubspotWebViewClient;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u001e\u0010\u0016\u001a\u00020\u00102\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0014\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/hubspot/mobilesdk/widget/HubspotWebView;", "Landroid/webkit/WebView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "manager", "Lcom/hubspot/mobilesdk/HubspotManager;", "hsThreadId", "", "chatScreenCloseListener", "Lkotlin/Function0;", "", "onThreadIdFetched", "Lkotlin/Function1;", "Lcom/hubspot/mobilesdk/widget/HubspotWebViewClient$JsEvents;", "handleChatScreenCloseEvent", "handleConversationIdEvent", "show", "chatFlow", "pushData", "Lcom/hubspot/mobilesdk/firebase/PushNotificationChatData;", "addChatScreenCloseListener", "listener", "Companion", "hubspot_release"})
public final class HubspotWebView
extends WebView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HubspotManager manager;
    @Nullable
    private String hsThreadId;
    @Nullable
    private Function0<Unit> chatScreenCloseListener;
    @NotNull
    private final Function1<HubspotWebViewClient.JsEvents, Unit> onThreadIdFetched;
    @NotNull
    public static final String HUBSPOT_MOBILE_CONFIG = " HubspotMobileSDK";
    @NotNull
    public static final String JAVASCRIPT_INTERFACE_NAME = "nativeApp";

    @JvmOverloads
    public HubspotWebView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.manager = HubspotManager.Companion.getInstance(context);
        this.onThreadIdFetched = arg_0 -> HubspotWebView.onThreadIdFetched$lambda$0(this, arg_0);
    }

    public /* synthetic */ HubspotWebView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void handleChatScreenCloseEvent() {
        Function0<Unit> function0 = this.chatScreenCloseListener;
        if (function0 != null) {
            function0.invoke();
        } else {
            Timber.Forest.e("HubspotWebView:Close chat screen listener undefined", new Object[0]);
        }
    }

    private final void handleConversationIdEvent() {
        block0: {
            LifecycleOwner lifecycleOwner = ViewTreeLifecycleOwner.get((View)((View)this));
            if (lifecycleOwner == null || (lifecycleOwner = lifecycleOwner.getLifecycle()) == null || (lifecycleOwner = LifecycleKt.getCoroutineScope((Lifecycle)lifecycleOwner)) == null) break block0;
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)lifecycleOwner), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ HubspotWebView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var2_3 = HubspotWebView.access$getHsThreadId$p(this.this$0);
                            if (var2_3 == null || StringsKt.isBlank((CharSequence)var2_3) != false) break;
                            v0 = HubspotWebView.access$getManager$p(this.this$0);
                            v1 = this.this$0.getContext();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getContext(...)");
                            this.label = 1;
                            v2 = new CompileAndUploadMetaDataUseCase(v0, v1).setParameters(String.valueOf(HubspotWebView.access$getHsThreadId$p(this.this$0))).execute((Continuation)this);
                            ** if (v2 != var4_2) goto lbl17
lbl16:
                            // 1 sources

                            return var4_2;
lbl17:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl23:
                                // 2 sources

                                var2_3 = v2;
                            }
                            catch (NetworkError error) {
                                v3 = error.getErrorMessage();
                                if (v3 == null) {
                                    v3 = HubspotConfigError.MetaDataAPIFailure.INSTANCE.getMessage();
                                }
                                Timber.Forest.e(v3, new Object[0]);
                                var2_3 = Unit.INSTANCE;
                            }
                            ** GOTO lbl54
                        }
                    }
                    if (!HubspotWebViewClient.JSBridge.INSTANCE.isConversationIdAvailable$hubspot_release()) ** GOTO lbl54
                    v4 = HubspotWebView.access$getManager$p(this.this$0);
                    v5 = this.this$0.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getContext(...)");
                    this.label = 2;
                    v6 = new CompileAndUploadMetaDataUseCase(v4, v5).setParameters(HubspotWebViewClient.JSBridge.INSTANCE.retrieveConversationId$hubspot_release()).execute((Continuation)this);
                    ** if (v6 != var4_2) goto lbl42
lbl41:
                    // 1 sources

                    return var4_2;
lbl42:
                    // 1 sources

                    ** GOTO lbl54
                    {
                        case 2: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v6 = $result;
                            }
                            catch (NetworkError error) {
                                v7 = error.getErrorMessage();
                                if (v7 == null) {
                                    v7 = HubspotConfigError.MetaDataAPIFailure.INSTANCE.getMessage();
                                }
                                Timber.Forest.e(v7, new Object[0]);
                            }
lbl54:
                            // 6 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public final void show(@Nullable String chatFlow, @Nullable PushNotificationChatData pushData) {
        PushNotificationChatData pushNotificationChatData = pushData;
        this.hsThreadId = pushNotificationChatData != null ? pushNotificationChatData.getThreadId() : null;
        this.manager.configure();
        String chatURL = this.manager.chatURL(chatFlow, pushData);
        this.setFocusableInTouchMode(true);
        String userAgent = this.getSettings().getUserAgentString() + " HubspotMobileSDK/1.0.8";
        this.getSettings().setUserAgentString(userAgent);
        this.getSettings().setJavaScriptEnabled(true);
        this.setWebViewClient(new HubspotWebViewClient());
        WebViewClient webViewClient = this.getWebViewClient();
        Intrinsics.checkNotNull((Object)webViewClient, (String)"null cannot be cast to non-null type com.hubspot.mobilesdk.widget.HubspotWebViewClient");
        ((HubspotWebViewClient)webViewClient).setActionAfterJsEvaluation$hubspot_release(this.onThreadIdFetched);
        this.addJavascriptInterface(HubspotWebViewClient.JSBridge.INSTANCE, JAVASCRIPT_INTERFACE_NAME);
        HashMap headers = new HashMap();
        ((Map)headers).put("Accept-Language", Locale.getDefault().toString());
        this.loadUrl(chatURL, headers);
    }

    public static /* synthetic */ void show$default(HubspotWebView hubspotWebView, String string2, PushNotificationChatData pushNotificationChatData, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 2) != 0) {
            pushNotificationChatData = null;
        }
        hubspotWebView.show(string2, pushNotificationChatData);
    }

    public final void addChatScreenCloseListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.chatScreenCloseListener = listener;
    }

    @JvmOverloads
    public HubspotWebView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public HubspotWebView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final Unit onThreadIdFetched$lambda$0(HubspotWebView this$0, HubspotWebViewClient.JsEvents event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        HubspotWebViewClient.JsEvents jsEvents = event;
        if (jsEvents instanceof HubspotWebViewClient.JsEvents.WebViewHostCloseEvent) {
            this$0.handleChatScreenCloseEvent();
        } else if (jsEvents instanceof HubspotWebViewClient.JsEvents.PostConversationIdEvent) {
            this$0.handleConversationIdEvent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getHsThreadId$p(HubspotWebView $this) {
        return $this.hsThreadId;
    }

    public static final /* synthetic */ HubspotManager access$getManager$p(HubspotWebView $this) {
        return $this.manager;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/hubspot/mobilesdk/widget/HubspotWebView$Companion;", "", "<init>", "()V", "HUBSPOT_MOBILE_CONFIG", "", "JAVASCRIPT_INTERFACE_NAME", "hubspot_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

