/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mobilesdk.util;

import android.content.Context;
import android.content.SharedPreferences;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR(\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR(\u0010\u0012\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/hubspot/mobilesdk/util/PreferenceHelper;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "value", "", "email", "getEmail", "()Ljava/lang/String;", "setEmail", "(Ljava/lang/String;)V", "token", "getToken", "setToken", "fcmToken", "getFcmToken", "setFcmToken", "removePreferences", "", "removeFcmToken", "Companion", "hubspot_release"})
public final class PreferenceHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences preferences;
    @NotNull
    private static final String prefEmail = "EMAIL";
    @NotNull
    private static final String prefToken = "TOKEN";
    @NotNull
    private static final String prefFCMToken = "FCM_TOKEN";
    @NotNull
    private static final String hubspotPreferences = "hubspot_user_data";

    public PreferenceHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences(hubspotPreferences, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.preferences = sharedPreferences;
    }

    @Nullable
    public final String getEmail() {
        return this.preferences.getString(prefEmail, "");
    }

    public final void setEmail(@Nullable String value) {
        this.preferences.edit().putString(prefEmail, value).apply();
    }

    @Nullable
    public final String getToken() {
        return this.preferences.getString(prefToken, "");
    }

    public final void setToken(@Nullable String value) {
        this.preferences.edit().putString(prefToken, value).apply();
    }

    @Nullable
    public final String getFcmToken() {
        return this.preferences.getString(prefFCMToken, "");
    }

    public final void setFcmToken(@Nullable String value) {
        this.preferences.edit().putString(prefFCMToken, value).apply();
    }

    public final void removePreferences() {
        this.preferences.edit().remove(prefEmail).apply();
        this.preferences.edit().remove(prefToken).apply();
        this.preferences.edit().remove(prefFCMToken).apply();
    }

    public final void removeFcmToken() {
        this.preferences.edit().remove(prefFCMToken).apply();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/hubspot/mobilesdk/util/PreferenceHelper$Companion;", "", "<init>", "()V", "prefEmail", "", "prefToken", "prefFCMToken", "hubspotPreferences", "hubspot_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

