/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mobilesdk.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.BatteryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/hubspot/mobilesdk/util/DeviceInformation;", "", "<init>", "()V", "Companion", "hubspot_release"})
public final class DeviceInformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ORIENTATION_LANDSCAPE = "landscape";
    @NotNull
    private static final String ORIENTATION_PORTRAIT = "portrait";

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hubspot/mobilesdk/util/DeviceInformation$Companion;", "", "<init>", "()V", "ORIENTATION_LANDSCAPE", "", "ORIENTATION_PORTRAIT", "getBatteryLevel", "context", "Landroid/content/Context;", "getScreenResolution", "getScreenSize", "getAppVersion", "getScreenOrientation", "hubspot_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getBatteryLevel(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSystemService("batterymanager");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.BatteryManager");
            BatteryManager batteryManager = (BatteryManager)object;
            return String.valueOf(batteryManager.getIntProperty(4));
        }

        @NotNull
        public final String getScreenResolution() {
            int width = Resources.getSystem().getDisplayMetrics().widthPixels;
            int height = Resources.getSystem().getDisplayMetrics().heightPixels;
            return width + " x " + height;
        }

        @NotNull
        public final String getScreenSize(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Configuration configuration = context.getResources().getConfiguration();
            double baselineDensity = 160.0;
            double heightInInch = (double)configuration.screenHeightDp / baselineDensity;
            double widthInInch = (double)configuration.screenWidthDp / baselineDensity;
            double diagonalSize = Math.ceil(Math.sqrt(Math.pow(heightInInch, 2) + Math.pow(widthInInch, 2)));
            return String.valueOf(diagonalSize);
        }

        @NotNull
        public final String getAppVersion(@NotNull Context context) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                String string3 = pInfo.versionName;
                if (string3 == null) {
                    string3 = "N/A";
                }
                string2 = string3;
            }
            catch (PackageManager.NameNotFoundException e) {
                Timber.Forest.e((Throwable)e);
                string2 = "N/A";
            }
            return string2;
        }

        @NotNull
        public final String getScreenOrientation(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            int orientation = context.getResources().getConfiguration().orientation;
            return orientation == 2 ? DeviceInformation.ORIENTATION_LANDSCAPE : DeviceInformation.ORIENTATION_PORTRAIT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

