/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mobilesdk.network;

import com.hubspot.mobilesdk.BuildConfig;
import com.hubspot.mobilesdk.config.Environment;
import com.hubspot.mobilesdk.config.Hublet;
import com.hubspot.mobilesdk.config.HubspotConfig;
import com.hubspot.mobilesdk.metadata.HubspotApi;
import com.squareup.moshi.Moshi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/hubspot/mobilesdk/network/NetworkDependencies;", "", "<init>", "()V", "baseUrl", "", "hubspotApi", "Lcom/hubspot/mobilesdk/metadata/HubspotApi;", "getHubspotApi", "configure", "", "config", "Lcom/hubspot/mobilesdk/config/HubspotConfig;", "createMoshiConverterFactory", "Lretrofit2/converter/moshi/MoshiConverterFactory;", "moshi", "Lcom/squareup/moshi/Moshi;", "createMoshi", "createOkHttpClient", "Lokhttp3/OkHttpClient;", "hubspot_release"})
public final class NetworkDependencies {
    @NotNull
    public static final NetworkDependencies INSTANCE = new NetworkDependencies();
    @NotNull
    private static String baseUrl = "https://api.hubapi.com/livechat-public/v1/mobile-sdk/";
    @Nullable
    private static HubspotApi hubspotApi;

    private NetworkDependencies() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HubspotApi getHubspotApi() {
        if (hubspotApi == null) {
            NetworkDependencies networkDependencies = this;
            synchronized (networkDependencies) {
                boolean bl = false;
                hubspotApi = (HubspotApi)new Retrofit.Builder().baseUrl(baseUrl).client(INSTANCE.createOkHttpClient()).addConverterFactory((Converter.Factory)INSTANCE.createMoshiConverterFactory(INSTANCE.createMoshi())).build().create(HubspotApi.class);
                Unit unit = Unit.INSTANCE;
            }
        }
        HubspotApi hubspotApi = NetworkDependencies.hubspotApi;
        Intrinsics.checkNotNull((Object)hubspotApi);
        return hubspotApi;
    }

    public final void configure(@NotNull HubspotConfig config) {
        String configuredUrl;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Hublet hublet = new Hublet(config.getHublet());
        Environment environment = new Environment(config.getEnvironment());
        baseUrl = configuredUrl = "https://" + hublet.getApiSubDomain() + ".hubapi" + environment.getChatURLSuffix() + ".com/livechat-public/v1/mobile-sdk/";
    }

    private final MoshiConverterFactory createMoshiConverterFactory(Moshi moshi) {
        MoshiConverterFactory moshiConverterFactory = MoshiConverterFactory.create((Moshi)moshi);
        Intrinsics.checkNotNullExpressionValue((Object)moshiConverterFactory, (String)"create(...)");
        return moshiConverterFactory;
    }

    private final Moshi createMoshi() {
        Moshi moshi = new Moshi.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"build(...)");
        return moshi;
    }

    /*
     * WARNING - void declaration
     */
    private final OkHttpClient createOkHttpClient() {
        void $this$createOkHttpClient_u24lambda_u240;
        HttpLoggingInterceptor httpLoggingInterceptor;
        HttpLoggingInterceptor httpLoggingInterceptor2 = httpLoggingInterceptor = new HttpLoggingInterceptor(null, 1, null);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        boolean bl = false;
        $this$createOkHttpClient_u24lambda_u240.level(BuildConfig.DEBUG != false ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
        return builder.addInterceptor((Interceptor)httpLoggingInterceptor).build();
    }
}

