/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mobilesdk.errorhandling;

import com.hubspot.mobilesdk.config.HubspotConfigError;
import com.hubspot.mobilesdk.errorhandling.ErrorTransformer;
import com.hubspot.mobilesdk.errorhandling.NetworkError;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/hubspot/mobilesdk/errorhandling/HubspotErrorTransformer;", "Lcom/hubspot/mobilesdk/errorhandling/ErrorTransformer;", "<init>", "()V", "transform", "", "error", "hubspot_release"})
public final class HubspotErrorTransformer
implements ErrorTransformer {
    @NotNull
    public static final HubspotErrorTransformer INSTANCE = new HubspotErrorTransformer();

    private HubspotErrorTransformer() {
    }

    @Override
    @NotNull
    public Throwable transform(@NotNull Throwable error) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof RuntimeException) {
            NetworkError.Data data;
            RuntimeException runtimeException = (RuntimeException)error;
            if (runtimeException instanceof HubspotConfigError.MissingHubletID || runtimeException instanceof HubspotConfigError.MissingPortalID || runtimeException instanceof HubspotConfigError.MissingEnvironment || runtimeException instanceof HubspotConfigError.AddNewDeviceTokenAPIFailure) {
                String string2 = error.getMessage();
                if (string2 == null) {
                    string2 = "Couldn't find parameter";
                }
                data = new NetworkError.Data.MissingParams(string2);
            } else {
                data = NetworkError.Data.Generic.INSTANCE;
            }
            throwable = data;
        } else {
            throwable = error;
        }
        return throwable;
    }
}

