/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.assertj.algebra.api;

import com.hubspot.algebra.Result;
import com.hubspot.assertj.algebra.error.ResultShouldBeErr;
import com.hubspot.assertj.algebra.error.ResultShouldBeErrWithValue;
import com.hubspot.assertj.algebra.error.ResultShouldBeOk;
import com.hubspot.assertj.algebra.error.ResultShouldBeOkWithValue;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public class ResultAssert<T, E>
extends AbstractAssert<ResultAssert<T, E>, Result<T, E>> {
    private Failures failures = Failures.instance();

    ResultAssert(Result<T, E> actual) {
        super(actual, ResultAssert.class);
    }

    public ResultAssert<T, E> isOk() {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Result)this.actual).isOk()) {
            throw this.failures.failure((AssertionInfo)this.info, ResultShouldBeOk.shouldBeOk((Result)this.actual));
        }
        return this;
    }

    public ResultAssert<T, E> isErr() {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Result)this.actual).isErr()) {
            throw this.failures.failure((AssertionInfo)this.info, ResultShouldBeErr.shouldBeErr((Result)this.actual));
        }
        return this;
    }

    public ResultAssert<T, E> containsOk(Object value) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Result)this.actual).isOk() || !((Result)this.actual).unwrapOrElseThrow().equals(value)) {
            throw this.failures.failure((AssertionInfo)this.info, ResultShouldBeOkWithValue.shouldBeOkWithValue((Result)this.actual, value));
        }
        return this;
    }

    public ResultAssert<T, E> containsErr(Object value) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Result)this.actual).isErr() || !((Result)this.actual).unwrapErrOrElseThrow().equals(value)) {
            throw this.failures.failure((AssertionInfo)this.info, ResultShouldBeErrWithValue.shouldBeErrWithValue((Result)this.actual, value));
        }
        return this;
    }

    public AbstractObjectAssert<?, T> extractingOk() {
        this.isOk();
        return Assertions.assertThat((Object)((Result)this.actual).unwrapOrElseThrow());
    }

    public AbstractObjectAssert<?, E> extractingErr() {
        this.isErr();
        return Assertions.assertThat((Object)((Result)this.actual).unwrapErrOrElseThrow());
    }
}

