/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.services.internal.ServiceException;
import com.obs.services.internal.service.ObsFileService;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ReadAheadQueryResult;
import com.obs.services.model.ReadAheadRequest;
import com.obs.services.model.ReadAheadResult;
import com.oef.services.model.CreateAsynchFetchJobsResult;
import com.oef.services.model.QueryAsynchFetchJobsResult;
import com.oef.services.model.QueryExtensionPolicyResult;
import com.oef.services.model.RequestParamEnum;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import shade.okhttp3.Response;

public abstract class ObsExtensionService
extends ObsFileService {
    protected HeaderResponse setExtensionPolicyImpl(String bucketName, String policyDocument) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put((this.getProviderCredentials().getLocalAuthType(bucketName) != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        NewTransResult result = new NewTransResult();
        result.setParams(requestParams);
        result.setHttpMethod(HttpMethodEnum.PUT);
        result.setBucketName(bucketName);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/json", policyDocument));
        return this.build(this.performRequest(result, true, false, true));
    }

    protected QueryExtensionPolicyResult queryExtensionPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        Response response = this.performRestGet(bucketName, requestParams, metadata);
        String body = this.readBodyFromResponse(response);
        QueryExtensionPolicyResult ret = (QueryExtensionPolicyResult)JSONChange.jsonToObj(new QueryExtensionPolicyResult(), body);
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    private String readBodyFromResponse(Response response) {
        String body;
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return body;
    }

    private Response performRestGet(String bucketName, Map<String, String> requestParams, Map<String, String> metadata) {
        metadata.put((this.getProviderCredentials().getLocalAuthType(bucketName) != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestGet(bucketName, null, requestParams, metadata, null, true);
        this.verifyResponseContentTypeForJson(response);
        return response;
    }

    protected HeaderResponse deleteExtensionPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put((this.getProviderCredentials().getLocalAuthType(bucketName) != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestDelete(bucketName, null, requestParams, metadata, null, true, true);
        return this.build(response);
    }

    protected CreateAsynchFetchJobsResult createFetchJobImpl(String bucketName, String policyDocument) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.ASYNC_FETCH_JOBS.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put((this.getProviderCredentials().getLocalAuthType(bucketName) != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        NewTransResult result = new NewTransResult();
        result.setBucketName(bucketName);
        result.setHttpMethod(HttpMethodEnum.POST);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/json", policyDocument));
        Response response = this.performRequest(result, true, false, true);
        this.verifyResponseContentTypeForJson(response);
        String body = this.readBodyFromResponse(response);
        CreateAsynchFetchJobsResult ret = (CreateAsynchFetchJobsResult)JSONChange.jsonToObj(new CreateAsynchFetchJobsResult(), body);
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected QueryAsynchFetchJobsResult queryFetchJobImpl(String bucketName, String jobId) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.ASYNC_FETCH_JOBS.getOriginalStringCode() + "/" + jobId, "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/json");
        Response response = this.performRestGet(bucketName, requestParams, metadata);
        String body = this.readBodyFromResponse(response);
        QueryAsynchFetchJobsResult ret = (QueryAsynchFetchJobsResult)JSONChange.jsonToObj(new QueryAsynchFetchJobsResult(), body);
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected ReadAheadResult readAheadObjectsImpl(ReadAheadRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("readAhead", "");
        requestParams.put("prefix", request.getPrefix());
        HashMap<String, String> headers = new HashMap<String, String>();
        String cacheControl = request.getCacheOption().getCode() + ", ttl=" + request.getTtl();
        headers.put("x-cache-control", cacheControl);
        NewTransResult transResult = this.transRequest(request);
        transResult.setHeaders(headers);
        transResult.setParams(requestParams);
        Response response = this.performRequest(transResult);
        this.verifyResponseContentTypeForJson(response);
        String body = this.readBodyFromResponse(response);
        ReadAheadResult result = (ReadAheadResult)JSONChange.jsonToObj(new ReadAheadResult(), body);
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected ReadAheadResult deleteReadAheadObjectsImpl(String bucketName, String prefix) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("readAhead", "");
        requestParameters.put("prefix", prefix);
        Response response = this.performRestDelete(bucketName, null, requestParameters, null, false);
        this.verifyResponseContentTypeForJson(response);
        String body = this.readBodyFromResponse(response);
        ReadAheadResult result = (ReadAheadResult)JSONChange.jsonToObj(new ReadAheadResult(), body);
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected ReadAheadQueryResult queryReadAheadObjectsTaskImpl(String bucketName, String taskId) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("readAhead", "");
        requestParameters.put("taskID", taskId);
        Response response = this.performRestGet(bucketName, null, requestParameters, null, null);
        this.verifyResponseContentTypeForJson(response);
        String body = this.readBodyFromResponse(response);
        ReadAheadQueryResult result = (ReadAheadQueryResult)JSONChange.jsonToObj(new ReadAheadQueryResult(), body);
        this.setHeadersAndStatus(result, response);
        return result;
    }
}

