/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Executors;

public abstract class PushReceiver
extends BroadcastReceiver {
    public void onEvent(Context context, Event event, Bundle bundle) {
    }

    public void onToken(Context context, String string, Bundle bundle) {
        this.onToken(context, string);
    }

    public boolean onPushMsg(Context context, byte[] byArray, Bundle bundle) {
        String string = "";
        if (null != bundle) {
            string = bundle.getString("deviceToken");
        }
        this.onPushMsg(context, byArray, string);
        return true;
    }

    public void onPushMsg(Context context, byte[] byArray, String string) {
    }

    public void onPushState(Context context, boolean bl) {
    }

    public void onToken(Context context, String string) {
    }

    public final void onReceive(Context context, Intent intent) {
        block14: {
            try {
                String string;
                if (com.huawei.hms.support.log.a.a()) {
                    com.huawei.hms.support.log.a.a("PushReceiver", "enter PushMsgReceiver:onReceive(Intent:" + intent.getAction() + " pkgName:" + context.getPackageName() + ")");
                }
                if ("com.huawei.android.push.intent.REGISTRATION".equals(string = intent.getAction()) && intent.hasExtra("device_token")) {
                    this.a(context, intent);
                } else if ("com.huawei.android.push.intent.RECEIVE".equals(string) && intent.hasExtra("msg_data")) {
                    this.b(context, intent);
                } else if ("com.huawei.android.push.intent.CLICK".equals(string) && intent.hasExtra("click")) {
                    this.c(context, intent);
                } else if ("com.huawei.android.push.intent.CLICK".equals(string) && intent.hasExtra("clickBtn")) {
                    this.d(context, intent);
                } else if ("com.huawei.intent.action.PUSH_STATE".equals(string)) {
                    this.e(context, intent);
                } else if (com.huawei.hms.support.log.a.a()) {
                    com.huawei.hms.support.log.a.b("PushReceiver", "message can't be recognised:" + intent.toUri(0));
                }
            }
            catch (Exception exception) {
                if (!com.huawei.hms.support.log.a.d()) break block14;
                com.huawei.hms.support.log.a.d("PushReceiver", "call onReceive(intent:" + intent + ") cause:" + exception.getMessage());
            }
        }
    }

    private void a(Context context, Intent intent) throws UnsupportedEncodingException {
        byte[] byArray = intent.getByteArrayExtra("device_token");
        if (null == byArray) {
            if (com.huawei.hms.support.log.a.a()) {
                com.huawei.hms.support.log.a.a("PushReceiver", "get a deviceToken, but it is null");
            }
            return;
        }
        String string = new String(byArray, "UTF-8");
        if (com.huawei.hms.support.log.a.a()) {
            com.huawei.hms.support.log.a.a("PushReceiver", "get a deviceToken:" + com.huawei.hms.support.api.push.a.a.b.c.a(string));
        }
        com.huawei.hms.support.api.push.a.a.a.c c2 = new com.huawei.hms.support.api.push.a.a.a.c(context, "push_client_self_info");
        boolean bl = c2.a("hasRequestToken");
        String string2 = com.huawei.hms.support.api.push.a.a.a.a(context, "push_client_self_info", "token_info");
        if (com.huawei.hms.support.log.a.a()) {
            com.huawei.hms.support.log.a.a("PushReceiver", "my oldtoken is :" + com.huawei.hms.support.api.push.a.a.b.c.a(string2));
        }
        if (bl || !string.equals(string2)) {
            if (com.huawei.hms.support.log.a.a()) {
                com.huawei.hms.support.log.a.a("PushReceiver", "push client begin to receive the token");
            }
            Executors.newSingleThreadExecutor().execute(new b(context, string));
            Bundle bundle = new Bundle();
            bundle.putString("deviceToken", string);
            bundle.putByteArray("pushMsg", null);
            bundle.putInt("receiveType", c.b.ordinal());
            if (null != intent.getExtras()) {
                bundle.putAll(intent.getExtras());
            }
            Executors.newSingleThreadExecutor().execute(new a(context, bundle));
        } else if (com.huawei.hms.support.log.a.a()) {
            com.huawei.hms.support.log.a.a("PushReceiver", "get a deviceToken, but do not requested token, and new token is equals old token");
        }
        if (bl && !string.equals(string2) && com.huawei.hms.support.log.a.a()) {
            com.huawei.hms.support.log.a.a("PushReceiver", "begin to report active state tag");
        }
    }

    private void b(Context context, Intent intent) throws UnsupportedEncodingException {
        this.f(context, intent);
        com.huawei.hms.support.api.push.a.a.a.c c2 = new com.huawei.hms.support.api.push.a.a.a.c(context, "push_switch");
        boolean bl = c2.a("normal_msg_enable");
        if (com.huawei.hms.support.log.a.a()) {
            com.huawei.hms.support.log.a.a("PushReceiver", "closePush_Normal:" + bl);
        }
        if (bl) {
            if (com.huawei.hms.support.log.a.a()) {
                com.huawei.hms.support.log.a.a("PushReceiver", "close switch is true, message not dispatch");
            }
            return;
        }
        byte[] byArray = intent.getByteArrayExtra("msg_data");
        byte[] byArray2 = intent.getByteArrayExtra("device_token");
        if (null == byArray || null == byArray2) {
            if (com.huawei.hms.support.log.a.a()) {
                com.huawei.hms.support.log.a.a("PushReceiver", "PushReceiver receive a message, but message is empty.");
            }
            return;
        }
        if (com.huawei.hms.support.log.a.a()) {
            com.huawei.hms.support.log.a.a("PushReceiver", "PushReceiver receive a message success");
        }
        String string = new String(byArray2, "UTF-8");
        Bundle bundle = new Bundle();
        bundle.putString("deviceToken", string);
        bundle.putByteArray("pushMsg", byArray);
        bundle.putInt("receiveType", c.c.ordinal());
        Executors.newSingleThreadExecutor().execute(new a(context, bundle));
    }

    private void c(Context context, Intent intent) {
        String string = intent.getStringExtra("click");
        Bundle bundle = new Bundle();
        bundle.putString("pushMsg", string);
        bundle.putInt("receiveType", c.e.ordinal());
        Executors.newSingleThreadExecutor().execute(new a(context, bundle));
    }

    private void d(Context context, Intent intent) {
        String string = intent.getStringExtra("clickBtn");
        int n2 = intent.getIntExtra("notifyId", 0);
        Bundle bundle = new Bundle();
        bundle.putString("pushMsg", string);
        bundle.putInt("pushNotifyId", n2);
        bundle.putInt("receiveType", c.f.ordinal());
        Executors.newSingleThreadExecutor().execute(new a(context, bundle));
    }

    private void e(Context context, Intent intent) {
        boolean bl = intent.getBooleanExtra("push_state", false);
        Bundle bundle = new Bundle();
        bundle.putBoolean("pushState", bl);
        bundle.putInt("receiveType", c.d.ordinal());
        Executors.newSingleThreadExecutor().execute(new a(context, bundle));
    }

    private void f(Context context, Intent intent) {
        if (null == context || null == intent) {
            return;
        }
        String string = intent.getStringExtra("msgIdStr");
        if (!TextUtils.isEmpty((CharSequence)string) && com.huawei.hms.support.api.push.a.a.a(context)) {
            Intent intent2 = new Intent("com.huawei.android.push.intent.MSG_RESPONSE");
            intent2.putExtra("msgIdStr", string);
            intent2.setPackage("android");
            intent2.setFlags(32);
            if (com.huawei.hms.support.log.a.a()) {
                com.huawei.hms.support.log.a.a("PushReceiver", "send msg response broadcast to frameworkPush");
            }
            context.sendBroadcast(intent2);
        }
    }

    private static class b
    implements Runnable {
        Context a;
        String b;

        public b(Context context, String string) {
            this.a = context;
            this.b = string;
        }

        @Override
        public void run() {
            com.huawei.hms.support.api.push.a.a.a.c c2 = new com.huawei.hms.support.api.push.a.a.a.c(this.a, "push_client_self_info");
            c2.a("hasRequestToken", false);
            c2.d("token_info");
            com.huawei.hms.support.api.push.a.a.a.a(this.a, "push_client_self_info", "token_info", this.b);
        }
    }

    private class a
    implements Runnable {
        private Context b;
        private Bundle c;

        public a(Context context, Bundle bundle) {
            this.b = context;
            this.c = bundle;
        }

        @Override
        public void run() {
            block12: {
                try {
                    if (null == this.c) {
                        return;
                    }
                    int n2 = this.c.getInt("receiveType");
                    if (n2 < 0 || n2 >= com.huawei.hms.support.api.push.PushReceiver$c.values().length) {
                        if (com.huawei.hms.support.log.a.a()) {
                            com.huawei.hms.support.log.a.a("PushReceiver", "invalid receiverType:" + n2);
                        }
                        return;
                    }
                    c c2 = com.huawei.hms.support.api.push.PushReceiver$c.values()[n2];
                    switch (c2) {
                        case b: {
                            PushReceiver.this.onToken(this.b, this.c.getString("deviceToken"), this.c);
                            break;
                        }
                        case c: {
                            byte[] byArray = this.c.getByteArray("pushMsg");
                            if (byArray == null) break;
                            PushReceiver.this.onPushMsg(this.b, byArray, this.c);
                            break;
                        }
                        case d: {
                            PushReceiver.this.onPushState(this.b, this.c.getBoolean("pushState"));
                            break;
                        }
                        case e: {
                            PushReceiver.this.onEvent(this.b, Event.NOTIFICATION_OPENED, this.c);
                            break;
                        }
                        case f: {
                            PushReceiver.this.onEvent(this.b, Event.NOTIFICATION_CLICK_BTN, this.c);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    if (!com.huawei.hms.support.log.a.a()) break block12;
                    com.huawei.hms.support.log.a.a("PushReceiver", "call EventThread(ReceiveType cause:" + exception.getMessage());
                }
            }
        }
    }

    public static enum Event {
        NOTIFICATION_OPENED,
        NOTIFICATION_CLICK_BTN;

    }

    static enum c {
        a,
        b,
        c,
        d,
        e,
        f;

    }

    public static interface BOUND_KEY {
        public static final String deviceTokenKey = "deviceToken";
        public static final String pushMsgKey = "pushMsg";
        public static final String receiveTypeKey = "receiveType";
        public static final String pushStateKey = "pushState";
        public static final String pushNotifyId = "pushNotifyId";
    }
}

