/*
 * Decompiled with CFR 0.152.
 */
package com.hdl.myhttputils;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.google.gson.Gson;
import com.hdl.myhttputils.CommCallback;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class MyHttpUtils {
    private List<File> files;
    private String urlPath;
    private Class clazz;
    private File filePath;
    private String fileSavePath;
    private CommCallback callback;
    private HashMap<String, String> map;
    private static final int WHAT_URLFAILED = 1001;
    private static final int WHAT_IOFAILED = 1002;
    private static final int WHAT_REQFAILED = 1003;
    private static final int WHAT_REQSUCCESS = 1004;
    private static final int WHAT_PROGRESS = 1005;
    private static final int WHAT_DOWNLOAD_FINISHED = 1006;
    private static final String TAG = "MyHttpUtils";
    private int readTimeout = 30000;
    private int connectTimeout = 5000;
    private Handler mHanler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1001: {
                    MyHttpUtils.this.callback.onFailed("URLException");
                    break;
                }
                case 1002: {
                    MyHttpUtils.this.callback.onFailed("IOException");
                    break;
                }
                case 1003: {
                    MyHttpUtils.this.callback.onFailed("CODEException");
                    break;
                }
                case 1004: {
                    String json = (String)msg.obj;
                    Log.i((String)MyHttpUtils.TAG, (String)json);
                    MyHttpUtils.this.callback.onSucess(new Gson().fromJson(json, MyHttpUtils.this.clazz));
                    break;
                }
                case 1005: {
                    Bundle bundle = (Bundle)msg.obj;
                    long total = bundle.getLong("contentLength");
                    long cur = bundle.getLong("curProgress");
                    MyHttpUtils.this.callback.onDownloading(total, cur);
                    break;
                }
                case 1006: {
                    MyHttpUtils.this.callback.onSucess("OK");
                }
            }
        }
    };

    public MyHttpUtils url(String urlPath) {
        this.urlPath = urlPath;
        return this;
    }

    public MyHttpUtils setJavaBean(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public MyHttpUtils addParam(HashMap<String, String> map) {
        this.map = map;
        return this;
    }

    public MyHttpUtils setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public MyHttpUtils setConnTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public MyHttpUtils addUploadFile(File filePath) {
        this.filePath = filePath;
        return this;
    }

    public MyHttpUtils addUploadFile(String filePath) {
        this.filePath = new File(filePath);
        return this;
    }

    public MyHttpUtils addUploadFiles(List<File> files) {
        this.files = files;
        return this;
    }

    public MyHttpUtils setFileSavePath(String fileSavePath) {
        this.fileSavePath = fileSavePath;
        return this;
    }

    public void onExecuteByPost(CommCallback callback) {
        this.callback = callback;
        new Thread(){

            @Override
            public void run() {
                try {
                    URL url = new URL(MyHttpUtils.this.urlPath);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(MyHttpUtils.this.readTimeout);
                    conn.setConnectTimeout(MyHttpUtils.this.connectTimeout);
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setRequestMethod("POST");
                    conn.setUseCaches(false);
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.connect();
                    DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                    String content = "";
                    if (MyHttpUtils.this.map.size() > 0) {
                        Set set = MyHttpUtils.this.map.entrySet();
                        for (Map.Entry me : set) {
                            content = content + (String)me.getKey() + "=" + (String)me.getValue() + "&";
                        }
                        content = content.substring(0, content.length() - 1);
                        Log.i((String)MyHttpUtils.TAG, (String)content);
                    }
                    out.writeBytes(content);
                    out.flush();
                    out.close();
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        int len = 0;
                        byte[] buf = new byte[0x100000];
                        StringBuilder json = new StringBuilder();
                        while ((len = is.read(buf)) != -1) {
                            json.append(new String(buf, 0, len));
                        }
                        is.close();
                        Message msg = MyHttpUtils.this.mHanler.obtainMessage();
                        msg.what = 1004;
                        msg.obj = json.toString();
                        MyHttpUtils.this.mHanler.sendMessage(msg);
                    } else {
                        MyHttpUtils.this.mHanler.sendEmptyMessage(1003);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1001);
                }
                catch (IOException e) {
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1002);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void onExecute(CommCallback callback) {
        this.callback = callback;
        new Thread(){

            @Override
            public void run() {
                try {
                    URL url = new URL(MyHttpUtils.this.urlPath);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(MyHttpUtils.this.readTimeout);
                    conn.setConnectTimeout(MyHttpUtils.this.connectTimeout);
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        int len = 0;
                        byte[] buf = new byte[0x100000];
                        StringBuilder json = new StringBuilder();
                        while ((len = is.read(buf)) != -1) {
                            json.append(new String(buf, 0, len));
                        }
                        is.close();
                        Message msg = MyHttpUtils.this.mHanler.obtainMessage();
                        msg.what = 1004;
                        msg.obj = json.toString();
                        MyHttpUtils.this.mHanler.sendMessage(msg);
                    } else {
                        MyHttpUtils.this.mHanler.sendEmptyMessage(1003);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1001);
                }
                catch (IOException e) {
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1002);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private String getFileName() {
        return this.urlPath.substring(this.urlPath.lastIndexOf("/") + 1);
    }

    public void downloadFile(CommCallback callback) {
        this.callback = callback;
        new Thread(){

            @Override
            public void run() {
                try {
                    URL url = new URL(MyHttpUtils.this.urlPath);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(MyHttpUtils.this.readTimeout);
                    conn.setConnectTimeout(MyHttpUtils.this.connectTimeout);
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        int len = 0;
                        byte[] buf = new byte[0x100000];
                        File dir = new File(MyHttpUtils.this.fileSavePath);
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        long contentLength = conn.getContentLength();
                        FileOutputStream fos = new FileOutputStream(new File(dir, MyHttpUtils.this.getFileName()));
                        long curProgress = 0L;
                        while ((len = is.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                            Message msg = MyHttpUtils.this.mHanler.obtainMessage();
                            msg.what = 1005;
                            Bundle bundle = new Bundle();
                            bundle.putLong("contentLength", contentLength);
                            bundle.putLong("curProgress", curProgress += (long)len);
                            msg.obj = bundle;
                            MyHttpUtils.this.mHanler.sendMessage(msg);
                        }
                        is.close();
                        fos.close();
                        MyHttpUtils.this.mHanler.sendEmptyMessage(1006);
                    } else {
                        MyHttpUtils.this.mHanler.sendEmptyMessage(1003);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1001);
                }
                catch (IOException e) {
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1002);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void uploadFile(CommCallback callback) {
        this.callback = callback;
        new Thread(){

            @Override
            @RequiresApi(api=19)
            public void run() {
                String BOUNDARY = UUID.randomUUID().toString();
                String PREFIX = "--";
                String LINE_END = "\r\n";
                String CONTENT_TYPE = "multipart/form-data";
                try {
                    URL url = new URL(MyHttpUtils.this.urlPath);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(MyHttpUtils.this.readTimeout);
                    conn.setConnectTimeout(MyHttpUtils.this.connectTimeout);
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Charset", "chset");
                    conn.setRequestProperty("connection", "keep-alive");
                    conn.setRequestProperty("Content-Type", CONTENT_TYPE + ";boundary=" + BOUNDARY);
                    if (MyHttpUtils.this.filePath != null) {
                        OutputStream outputSteam = conn.getOutputStream();
                        DataOutputStream dos = new DataOutputStream(outputSteam);
                        StringBuffer sb = new StringBuffer();
                        sb.append(PREFIX);
                        sb.append(BOUNDARY);
                        sb.append(LINE_END);
                        sb.append("Content-Disposition: form-data; name=\"img\"; filename=\"" + MyHttpUtils.this.filePath.getName() + "\"" + LINE_END);
                        sb.append("Content-Type: application/octet-stream; charset=chset" + LINE_END);
                        sb.append(LINE_END);
                        dos.write(sb.toString().getBytes());
                        FileInputStream is = new FileInputStream(MyHttpUtils.this.filePath);
                        byte[] bytes = new byte[0x100000];
                        int len = 0;
                        while ((len = ((InputStream)is).read(bytes)) != -1) {
                            dos.write(bytes, 0, len);
                        }
                        ((InputStream)is).close();
                        dos.write(LINE_END.getBytes());
                        byte[] end_data = (PREFIX + BOUNDARY + PREFIX + LINE_END).getBytes();
                        dos.write(end_data);
                        dos.flush();
                        dos.close();
                        StringBuilder json = new StringBuilder();
                        if (conn.getResponseCode() == 200) {
                            int length = 0;
                            byte[] buf = new byte[0x100000];
                            InputStream cis = conn.getInputStream();
                            while ((length = cis.read(buf)) != -1) {
                                json.append(new String(buf, 0, length));
                            }
                            cis.close();
                            Message msg = MyHttpUtils.this.mHanler.obtainMessage();
                            msg.what = 1004;
                            msg.obj = json.toString();
                            MyHttpUtils.this.mHanler.sendMessage(msg);
                        } else {
                            MyHttpUtils.this.mHanler.sendEmptyMessage(1003);
                        }
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1001);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1002);
                }
            }
        }.start();
    }

    public void uploadFileMult(CommCallback callback) {
        this.callback = callback;
        new Thread(){

            @Override
            @RequiresApi(api=19)
            public void run() {
                String BOUNDARY = UUID.randomUUID().toString();
                String PREFIX = "--";
                String LINE_END = "\r\n";
                String CONTENT_TYPE = "multipart/form-data";
                try {
                    URL url = new URL(MyHttpUtils.this.urlPath);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(MyHttpUtils.this.readTimeout);
                    conn.setConnectTimeout(MyHttpUtils.this.connectTimeout);
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Charset", "chset");
                    conn.setRequestProperty("connection", "keep-alive");
                    conn.setRequestProperty("Content-Type", CONTENT_TYPE + ";boundary=" + BOUNDARY);
                    OutputStream outputSteam = conn.getOutputStream();
                    DataOutputStream dos = new DataOutputStream(outputSteam);
                    for (File file : MyHttpUtils.this.files) {
                        Log.e((String)"get", (String)file.getName());
                        StringBuffer sb = new StringBuffer();
                        sb.append(PREFIX);
                        sb.append(BOUNDARY);
                        sb.append(LINE_END);
                        sb.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"" + LINE_END);
                        sb.append("Content-Type: application/octet-stream; charset=chset" + LINE_END);
                        sb.append(LINE_END);
                        dos.write(sb.toString().getBytes());
                        FileInputStream fis = new FileInputStream(file);
                        byte[] bytes = new byte[65536];
                        int len = 0;
                        while ((len = fis.read(bytes)) != -1) {
                            dos.write(bytes, 0, len);
                        }
                        fis.close();
                        dos.write(LINE_END.getBytes());
                    }
                    byte[] end_data = (PREFIX + BOUNDARY + PREFIX + LINE_END).getBytes();
                    dos.write(end_data);
                    dos.flush();
                    dos.close();
                    StringBuilder json = new StringBuilder();
                    if (conn.getResponseCode() == 200) {
                        int length = 0;
                        byte[] buf = new byte[0x100000];
                        InputStream cis = conn.getInputStream();
                        while ((length = cis.read(buf)) != -1) {
                            json.append(new String(buf, 0, length));
                        }
                        cis.close();
                        Message msg = MyHttpUtils.this.mHanler.obtainMessage();
                        msg.what = 1004;
                        msg.obj = json.toString();
                        MyHttpUtils.this.mHanler.sendMessage(msg);
                    } else {
                        MyHttpUtils.this.mHanler.sendEmptyMessage(1003);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1001);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MyHttpUtils.this.mHanler.sendEmptyMessage(1002);
                }
            }
        }.start();
    }
}

