/*
 * Decompiled with CFR 0.152.
 */
package wei.mark.standout;

import android.util.SparseArray;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import wei.mark.standout.StandOutWindow;
import wei.mark.standout.ui.Window;

public class WindowCache {
    public Map<Class<? extends StandOutWindow>, SparseArray<Window>> sWindows = new HashMap<Class<? extends StandOutWindow>, SparseArray<Window>>();

    public boolean isCached(int id2, Class<? extends StandOutWindow> cls) {
        return this.getCache(id2, cls) != null;
    }

    public Window getCache(int id2, Class<? extends StandOutWindow> cls) {
        SparseArray<Window> l2 = this.sWindows.get(cls);
        if (l2 == null) {
            return null;
        }
        return (Window)((Object)l2.get(id2));
    }

    public void putCache(int id2, Class<? extends StandOutWindow> cls, Window window) {
        SparseArray l2 = this.sWindows.get(cls);
        if (l2 == null) {
            l2 = new SparseArray();
            this.sWindows.put(cls, (SparseArray<Window>)l2);
        }
        l2.put(id2, (Object)window);
    }

    public void removeCache(int id2, Class<? extends StandOutWindow> cls) {
        SparseArray<Window> l2 = this.sWindows.get(cls);
        if (l2 != null) {
            l2.remove(id2);
            if (l2.size() == 0) {
                this.sWindows.remove(cls);
            }
        }
    }

    public int getCacheSize(Class<? extends StandOutWindow> cls) {
        SparseArray<Window> l2 = this.sWindows.get(cls);
        if (l2 == null) {
            return 0;
        }
        return l2.size();
    }

    public Set<Integer> getCacheIds(Class<? extends StandOutWindow> cls) {
        SparseArray<Window> l2 = this.sWindows.get(cls);
        if (l2 == null) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < l2.size(); ++i) {
            keys.add(l2.keyAt(i));
        }
        return keys;
    }

    public int size() {
        return this.sWindows.size();
    }
}

