/*
 * Decompiled with CFR 0.152.
 */
package com.zhj.downloadutils.ui;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.zhj.downloadutils.R;
import com.zhj.downloadutils.event.InstallEvent;
import com.zhj.downloadutils.event.UpdateAppBean;
import com.zhj.downloadutils.listener.IUpdateDialogFragmentListener;
import com.zhj.downloadutils.service.DownloadService;
import com.zhj.downloadutils.tools.AppUpdateUtils;
import com.zhj.downloadutils.tools.ColorUtil;
import com.zhj.downloadutils.tools.DrawableUtil;
import com.zhj.downloadutils.ui.NumberProgressBar;
import java.io.File;
import org.greenrobot.eventbus.EventBus;

public class UpdateDialogFragment
extends DialogFragment
implements View.OnClickListener {
    public static final String TIPS = "\u8bf7\u6388\u6743\u8bbf\u95ee\u5b58\u50a8\u7a7a\u95f4\u6743\u9650\uff0c\u5426\u5219App\u65e0\u6cd5\u66f4\u65b0";
    public static boolean isShow = false;
    private TextView mContentTextView;
    public Button mUpdateOkButton;
    private UpdateAppBean mUpdateApp;
    public NumberProgressBar mNumberProgressBar;
    private ImageView mIvClose;
    private TextView mTitleTextView;
    private ServiceConnection conn = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            UpdateDialogFragment.this.startDownloadApp((DownloadService.DownloadBinder)service);
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    };
    private LinearLayout mLlClose;
    private int mDefaultColor = -1490119;
    private int mDefaultPicResId = R.drawable.lib_update_app_top_bg;
    private ImageView mTopIv;
    private TextView mIgnore;
    private IUpdateDialogFragmentListener mUpdateDialogFragmentListener;
    private DownloadService.DownloadBinder mDownloadBinder;
    private Activity mActivity;

    public UpdateDialogFragment setUpdateDialogFragmentListener(IUpdateDialogFragmentListener updateDialogFragmentListener) {
        this.mUpdateDialogFragmentListener = updateDialogFragmentListener;
        return this;
    }

    public static UpdateDialogFragment newInstance(Bundle args) {
        UpdateDialogFragment fragment = new UpdateDialogFragment();
        if (args != null) {
            fragment.setArguments(args);
        }
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        isShow = true;
        this.setStyle(1, R.style.UpdateAppDialog);
        this.mActivity = this.getActivity();
    }

    public void onStart() {
        super.onStart();
        this.getDialog().setCanceledOnTouchOutside(false);
        this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    if (UpdateDialogFragment.this.mUpdateApp != null && UpdateDialogFragment.this.mUpdateApp.isConstraint()) {
                        UpdateDialogFragment.this.startActivity(new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME"));
                        return true;
                    }
                    return false;
                }
                return false;
            }
        });
        Window dialogWindow = this.getDialog().getWindow();
        dialogWindow.setGravity(17);
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        lp.height = displayMetrics.heightPixels;
        dialogWindow.setAttributes(lp);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.lib_update_app_dialog, container);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private void initView(View view) {
        this.mContentTextView = (TextView)view.findViewById(R.id.tv_update_info);
        this.mTitleTextView = (TextView)view.findViewById(R.id.tv_title);
        this.mUpdateOkButton = (Button)view.findViewById(R.id.btn_ok);
        this.mNumberProgressBar = (NumberProgressBar)view.findViewById(R.id.npb);
        this.mIvClose = (ImageView)view.findViewById(R.id.iv_close);
        this.mLlClose = (LinearLayout)view.findViewById(R.id.ll_close);
        this.mTopIv = (ImageView)view.findViewById(R.id.iv_top);
        this.mIgnore = (TextView)view.findViewById(R.id.tv_ignore);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initData();
    }

    private void initData() {
        this.mUpdateApp = (UpdateAppBean)this.getArguments().getSerializable("update_dialog_values");
        this.initTheme();
        if (this.mUpdateApp != null) {
            String dialogTitle = this.mUpdateApp.getUpdateDefDialogTitle();
            String newVersion = this.mUpdateApp.getNewVersion();
            String targetSize = this.mUpdateApp.getTargetSize();
            String updateLog = this.mUpdateApp.isConstraint() ? this.mUpdateApp.getMustUpdateLog() : this.mUpdateApp.getNeedUpdateLog();
            String msg = "";
            if (!TextUtils.isEmpty((CharSequence)targetSize)) {
                msg = "\u65b0\u7248\u672c\u5927\u5c0f\uff1a" + targetSize + "\n\n";
            }
            if (!TextUtils.isEmpty((CharSequence)updateLog)) {
                msg = msg + updateLog;
            }
            this.mContentTextView.setText((CharSequence)msg);
            this.mTitleTextView.setText((CharSequence)(TextUtils.isEmpty((CharSequence)dialogTitle) ? String.format("\u662f\u5426\u5347\u7ea7\u5230%s\u7248\u672c\uff1f", newVersion) : dialogTitle));
            if (this.mUpdateApp.isConstraint()) {
                this.mLlClose.setVisibility(8);
            } else if (this.mUpdateApp.isShowIgnoreVersion()) {
                this.mIgnore.setVisibility(0);
            }
            this.initEvents();
        }
    }

    private void initTheme() {
        int color = this.getArguments().getInt("", -1);
        int topResId = this.getArguments().getInt("", -1);
        if (-1 == topResId) {
            if (-1 == color) {
                this.setDialogTheme(this.mDefaultColor, this.mDefaultPicResId);
            } else {
                this.setDialogTheme(color, this.mDefaultPicResId);
            }
        } else if (-1 == color) {
            this.setDialogTheme(this.mDefaultColor, topResId);
        } else {
            this.setDialogTheme(color, topResId);
        }
    }

    private void setDialogTheme(int color, int topResId) {
        this.mTopIv.setImageResource(topResId);
        this.mUpdateOkButton.setBackgroundDrawable((Drawable)DrawableUtil.getDrawable(AppUpdateUtils.dip2px(4, (Context)this.getActivity()), color));
        this.mNumberProgressBar.setProgressTextColor(color);
        this.mNumberProgressBar.setReachedBarColor(color);
        this.mUpdateOkButton.setTextColor(ColorUtil.isTextColorDark(color) ? -16777216 : -1);
    }

    private void initEvents() {
        this.mUpdateOkButton.setOnClickListener((View.OnClickListener)this);
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mIgnore.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.btn_ok) {
            int flag = ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (flag != 0) {
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)TIPS, (int)1).show();
                } else {
                    this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                }
            } else {
                this.installApp();
            }
        } else if (i == R.id.iv_close) {
            this.cancelDownloadService();
            if (this.mUpdateDialogFragmentListener != null) {
                this.mUpdateDialogFragmentListener.onUpdateNotifyDialogCancel(this.mUpdateApp);
            }
            this.dismiss();
        } else if (i == R.id.tv_ignore) {
            AppUpdateUtils.saveIgnoreVersion((Context)this.getActivity(), this.mUpdateApp.getNewVersion());
            this.dismiss();
        }
    }

    public void cancelDownloadService() {
        if (this.mDownloadBinder != null) {
            this.mDownloadBinder.stop("\u53d6\u6d88\u4e0b\u8f7d");
        }
    }

    private void installApp() {
        if (AppUpdateUtils.appIsDownloaded(this.mUpdateApp)) {
            AppUpdateUtils.installApp((Fragment)this, AppUpdateUtils.getAppFile(this.mUpdateApp));
            if (!this.mUpdateApp.isConstraint()) {
                this.dismiss();
            } else {
                this.showInstallBtn(AppUpdateUtils.getAppFile(this.mUpdateApp));
            }
        } else {
            this.downloadApp();
            if (this.mUpdateApp.isHideDialog() && !this.mUpdateApp.isConstraint()) {
                this.dismiss();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.installApp();
            } else {
                Toast.makeText((Context)this.getActivity(), (CharSequence)TIPS, (int)1).show();
                this.dismiss();
            }
        }
    }

    private void downloadApp() {
        DownloadService.bindService(this.getActivity().getApplicationContext(), this.conn);
    }

    private void startDownloadApp(DownloadService.DownloadBinder binder) {
        if (this.mUpdateApp != null) {
            this.mDownloadBinder = binder;
            binder.start(this.mUpdateApp, new DownloadService.ProgressCallback(){

                @Override
                public void onStart() {
                    if (!UpdateDialogFragment.this.isRemoving()) {
                        UpdateDialogFragment.this.mNumberProgressBar.setVisibility(0);
                        UpdateDialogFragment.this.mUpdateOkButton.setVisibility(8);
                    }
                }

                @Override
                public void onProgress(final float progress, long totalSize) {
                    if (!UpdateDialogFragment.this.isRemoving() && UpdateDialogFragment.this.getActivity() != null) {
                        UpdateDialogFragment.this.getActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                UpdateDialogFragment.this.mNumberProgressBar.setProgress(Math.round(progress));
                                UpdateDialogFragment.this.mNumberProgressBar.setMax(100);
                            }
                        });
                    }
                }

                @Override
                public void setMax(long total) {
                }

                @Override
                public boolean onFinish(File file) {
                    if (!UpdateDialogFragment.this.isRemoving()) {
                        if (UpdateDialogFragment.this.mUpdateApp.isConstraint()) {
                            UpdateDialogFragment.this.showInstallBtn(file);
                        } else {
                            UpdateDialogFragment.this.dismissAllowingStateLoss();
                        }
                    }
                    return true;
                }

                @Override
                public void onError(String msg) {
                    if (!UpdateDialogFragment.this.isRemoving()) {
                        UpdateDialogFragment.this.dismissAllowingStateLoss();
                    }
                }

                @Override
                public boolean onInstallAppAndAppOnForeground(File file) {
                    if (!UpdateDialogFragment.this.mUpdateApp.isConstraint()) {
                        UpdateDialogFragment.this.dismiss();
                    }
                    if (UpdateDialogFragment.this.mActivity != null) {
                        EventBus.getDefault().post((Object)new InstallEvent(file));
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void showInstallBtn(final File file) {
        this.mNumberProgressBar.setVisibility(8);
        this.mUpdateOkButton.setText((CharSequence)"\u5b89\u88c5");
        this.mUpdateOkButton.setVisibility(0);
        this.mUpdateOkButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppUpdateUtils.installApp((Fragment)UpdateDialogFragment.this, file);
            }
        });
    }

    public void show(FragmentManager manager, String tag) {
        try {
            super.show(manager, tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDestroyView() {
        isShow = false;
        super.onDestroyView();
    }
}

