/*
 * Decompiled with CFR 0.152.
 */
package com.zhj.downloadutils.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import com.tbruyelle.rxpermissions2.RxPermissions;
import com.zhj.downloadutils.R;
import com.zhj.downloadutils.event.InstallEvent;
import com.zhj.downloadutils.event.UpdateAppBean;
import com.zhj.downloadutils.tools.AppUpdateUtils;
import com.zhj.downloadutils.tools.DownLoadUtils;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010\n\u001a\u00020\u0006H\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/zhj/downloadutils/ui/MainActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "mContext", "Landroid/content/Context;", "checkUpdate", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onInstallEvent", "installEvent", "Lcom/zhj/downloadutils/event/InstallEvent;", "download_release"})
public final class MainActivity
extends AppCompatActivity {
    private Context mContext;
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main);
        EventBus.getDefault().register((Object)this);
        this.mContext = (Context)this;
        this.checkUpdate();
    }

    private final void checkUpdate() {
        String path = "";
        if (Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted") || !Environment.isExternalStorageRemovable()) {
            try {
                File file = this.getExternalCacheDir();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                String string = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"externalCacheDir!!.absolutePath");
                path = string;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (TextUtils.isEmpty((CharSequence)path)) {
                File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalS\u2026ment.DIRECTORY_DOWNLOADS)");
                String string = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Environment.getExternalS\u2026Y_DOWNLOADS).absolutePath");
                path = string;
            }
        } else {
            File file = this.getCacheDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"cacheDir");
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cacheDir.absolutePath");
            path = string;
        }
        String message = "1. \u9002\u914d\u7ad6\u5c4f\u6218\u62a5\u5e26\u6765\u7684\u663e\u793a\u6548\u679c\u7684\u5f71\u54cd\uff0c\u9700\u8981\u6253\u5f00\u5927\u56fe\u624d\u80fd\u67e5\u770b\u5b8c\u6574\u6218\u62a5\n2. \u4fee\u590d\u534e\u4e3a\u624b\u673a\u6216android9.0\u7248\u672c\u53ef\u80fd\u51fa\u73b0\u5f02\u5e38\u5d29\u6e83\u7684\u95ee\u9898\n3. \u4fee\u590dandroid5 \u7248\u672c\u7684\u624b\u673a\u5728\u6d4f\u89c8\u6587\u7ae0\u662f\u53ef\u80fd\u5d29\u6e83\u7684\u95ee\u9898\n4. \u4fee\u590dapk\u4e0b\u8f7d\u5931\u8d25\u5d29\u6e83\u7684\u95ee\u9898";
        UpdateAppBean updateAppBean = new UpdateAppBean();
        updateAppBean.setNeedUpdateLog(message);
        updateAppBean.setTargetPath(path);
        updateAppBean.setNewVersion("2.7.0");
        updateAppBean.setTargetSize("16m");
        updateAppBean.setNewMd5("046dbcf3f1be7816847fe4ea042b2f4a");
        updateAppBean.setConstraint(false);
        updateAppBean.setMustUpdateLog("\u7531\u4e8e\u4e0d\u53ef\u6297\u529b\uff0c\u5fc5\u987b\u5347\u7ea7\u65b0\u7248\u672c\uff0c\u8bf7\u5347\u7ea7\u60a8\u7684\u5e94\u7528\u7a0b\u5e8f\u3002");
        updateAppBean.setApkFileUrl("https://bmob-cdn-14564.bmobcloud.com/2019/10/22/be03175340cabe2a80e03dbf26875036.apk");
        new DownLoadUtils(this).showReminderDialog(updateAppBean);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public final void onInstallEvent(@NotNull InstallEvent installEvent) {
        Intrinsics.checkParameterIsNotNull((Object)installEvent, (String)"installEvent");
        if (Build.VERSION.SDK_INT >= 26) {
            if (!this.getPackageManager().canRequestPackageInstalls()) {
                Context context = this.mContext;
                if (context == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
                }
                RxPermissions rxPermissions = new RxPermissions((Activity)context);
                rxPermissions.request(new String[]{"android.permission.REQUEST_INSTALL_PACKAGES"}).subscribe((Observer)new Observer<Boolean>(this, installEvent){
                    final /* synthetic */ MainActivity this$0;
                    final /* synthetic */ InstallEvent $installEvent;

                    public void onSubscribe(@NotNull Disposable d) {
                        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                    }

                    public void onNext(boolean aBoolean) {
                        if (aBoolean) {
                            AppUpdateUtils.installApp((Activity)this.this$0, this.$installEvent.getFile());
                        } else {
                            new DownLoadUtils(this.this$0).showUserRejectionDialog("\u70b9\u5c06\u53f0\u60f3\u8981\u5b89\u88c5\u65b0\u7248\u672c\uff0c\u5927\u4eba\u8bf7\u540c\u610f");
                        }
                    }

                    public void onError(@NotNull Throwable e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    }

                    public void onComplete() {
                    }
                    {
                        this.this$0 = $outer;
                        this.$installEvent = $captured_local_variable$1;
                    }
                });
            } else {
                AppUpdateUtils.installApp((Activity)this, installEvent.getFile());
            }
        } else {
            AppUpdateUtils.installApp(this.mContext, installEvent.getFile());
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

