/*
 * Decompiled with CFR 0.152.
 */
package com.zhj.downloadutils.tools;

import android.annotation.SuppressLint;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.NonNull;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpDownloadUtil {
    private static OkHttpDownloadUtil okHttpDownloadUtil;
    private final OkHttpClient okHttpClient = new OkHttpClient();
    File file;
    private String error_msg;
    int progress;
    private boolean isRun = true;

    public static OkHttpDownloadUtil get() {
        if (okHttpDownloadUtil == null) {
            okHttpDownloadUtil = new OkHttpDownloadUtil();
        }
        return okHttpDownloadUtil;
    }

    private OkHttpDownloadUtil() {
    }

    @SuppressLint(value={"CheckResult"})
    public void download(String url, final String path, final String fileName, final OnDownloadListener listener) {
        if (url.equals("")) {
            return;
        }
        Request request = new Request.Builder().url(url).build();
        Observable.create(emitter -> this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                emitter.onNext((Object)0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                InputStream is = null;
                byte[] buf = new byte[2048];
                int len = 0;
                FileOutputStream fos = null;
                try {
                    is = response.body().byteStream();
                    long total = response.body().contentLength();
                    String fileUri = path + "/" + fileName;
                    OkHttpDownloadUtil.this.file = new File(fileUri);
                    if (!OkHttpDownloadUtil.this.file.exists()) {
                        if (!OkHttpDownloadUtil.this.file.getParentFile().exists()) {
                            OkHttpDownloadUtil.this.file.getParentFile().mkdirs();
                        }
                        OkHttpDownloadUtil.this.file.createNewFile();
                    }
                    fos = new FileOutputStream(OkHttpDownloadUtil.this.file);
                    long sum = 0L;
                    int oldProgress = 0;
                    while ((len = is.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                        OkHttpDownloadUtil.this.progress = (int)((float)(sum += (long)len) * 1.0f / (float)total * 100.0f);
                        if (oldProgress == OkHttpDownloadUtil.this.progress) continue;
                        emitter.onNext((Object)1);
                        oldProgress = OkHttpDownloadUtil.this.progress;
                    }
                    fos.flush();
                    emitter.onNext((Object)2);
                }
                catch (Exception e) {
                    OkHttpDownloadUtil.this.error_msg = e.getMessage();
                    emitter.onNext((Object)0);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        })).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Integer>(){

            public void accept(Integer integer) throws Exception {
                if (integer == 0) {
                    OkHttpDownloadUtil.this.isRun = false;
                    if ("".equals(OkHttpDownloadUtil.this.error_msg)) {
                        listener.onDownloadFailed("\u4e0b\u8f7d\u5931\u8d25");
                    } else {
                        listener.onDownloadFailed(OkHttpDownloadUtil.this.error_msg);
                    }
                } else if (integer == 1 && OkHttpDownloadUtil.this.isRun) {
                    listener.onDownloading(OkHttpDownloadUtil.this.progress, 100L);
                } else {
                    OkHttpDownloadUtil.this.isRun = false;
                    listener.onDownloadSuccess(OkHttpDownloadUtil.this.file);
                }
            }
        });
    }

    private String isExistDir(String saveDir) throws IOException {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File downloadFile = new File(Environment.getExternalStorageDirectory(), saveDir);
            if (!downloadFile.mkdirs()) {
                downloadFile.createNewFile();
            }
            String savePath = downloadFile.getAbsolutePath();
            Log.e((String)"savePath", (String)savePath);
            return savePath;
        }
        return null;
    }

    private String getNameFromUrl(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    public static void download(@NonNull String url, @NonNull String path, @NonNull String fileName, final @NonNull FileCallback callback) {
        OkHttpDownloadUtil.get().download(url, path, fileName, new OnDownloadListener(){

            @Override
            public void onDownloadSuccess(File str) {
                callback.onResponse(str);
            }

            @Override
            public void onDownloading(int progress, long total) {
                callback.onProgress(progress, total);
            }

            @Override
            public void onDownloadFailed(String error) {
                callback.onError(error);
            }
        });
    }

    public static interface FileCallback {
        public void onProgress(float var1, long var2);

        public void onError(String var1);

        public void onResponse(File var1);

        public void onBefore();
    }

    public static interface OnDownloadListener {
        public void onDownloadSuccess(File var1);

        public void onDownloading(int var1, long var2);

        public void onDownloadFailed(String var1);
    }
}

