/*
 * Decompiled with CFR 0.152.
 */
package com.zhj.downloadutils.tools;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.widget.TextView;
import com.zhj.downloadutils.tools.ColorUtil;

public class DrawableUtil {
    private DrawableUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static GradientDrawable getSolidRectDrawable(int cornerRadius, int solidColor) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setCornerRadius((float)cornerRadius);
        gradientDrawable.setColor(solidColor);
        gradientDrawable.setGradientType(1);
        return gradientDrawable;
    }

    public static GradientDrawable getStrokeRectDrawable(int cornerRadius, int solidColor, int strokeColor, int strokeWidth) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setStroke(strokeWidth, strokeColor);
        gradientDrawable.setColor(solidColor);
        gradientDrawable.setCornerRadius((float)cornerRadius);
        gradientDrawable.setGradientType(1);
        return gradientDrawable;
    }

    public static StateListDrawable getStateListDrawable(Drawable pressedDrawable, Drawable normalDrawable) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842910, 16842919}, pressedDrawable);
        stateListDrawable.addState(new int[]{16842910}, normalDrawable);
        GradientDrawable gray = DrawableUtil.getSolidRectDrawable(10, -7829368);
        stateListDrawable.addState(new int[0], (Drawable)gray);
        return stateListDrawable;
    }

    public static StateListDrawable getDrawable(int cornerRadius, int pressedColor, int normalColor) {
        return DrawableUtil.getStateListDrawable((Drawable)DrawableUtil.getSolidRectDrawable(cornerRadius, pressedColor), (Drawable)DrawableUtil.getSolidRectDrawable(cornerRadius, normalColor));
    }

    public static StateListDrawable getStrokeSolidDrawable(int cornerRadiusPX, int strokeWidthPX, int subColor, int mainColor) {
        return DrawableUtil.getStateListDrawable((Drawable)DrawableUtil.getSolidRectDrawable(cornerRadiusPX, subColor), (Drawable)DrawableUtil.getStrokeRectDrawable(cornerRadiusPX, mainColor, subColor, strokeWidthPX));
    }

    public static StateListDrawable getSolidStrokeDrawable(int cornerRadiusPX, int strokeWidthPX, int subColor, int mainColor) {
        return DrawableUtil.getStateListDrawable((Drawable)DrawableUtil.getStrokeRectDrawable(cornerRadiusPX, subColor, mainColor, strokeWidthPX), (Drawable)DrawableUtil.getSolidRectDrawable(cornerRadiusPX, mainColor));
    }

    public static StateListDrawable getDrawable(int cornerRadius, int normalColor) {
        return DrawableUtil.getDrawable(cornerRadius, ColorUtil.colorDeep(normalColor), normalColor);
    }

    public static StateListDrawable getDrawable(int cornerRadius) {
        return DrawableUtil.getDrawable(cornerRadius, ColorUtil.getRandomColor());
    }

    public static StateListDrawable getDrawable() {
        return DrawableUtil.getDrawable(10);
    }

    public static StateListDrawable getRandomColorDrawable(int cornerRadius) {
        return DrawableUtil.getDrawable(cornerRadius, ColorUtil.getRandomColor(), ColorUtil.getRandomColor());
    }

    public static StateListDrawable getRandomColorDrawable() {
        return DrawableUtil.getRandomColorDrawable(10);
    }

    public static StateListDrawable getStrokeRandomColorDrawable() {
        return DrawableUtil.getStrokeSolidDrawable(10, 4, ColorUtil.getRandomColor(), 0);
    }

    public static void setTextStrokeTheme(TextView textView, int strokeWidth, int cornerRadius, int color) {
        textView.setBackgroundDrawable((Drawable)DrawableUtil.getStrokeSolidDrawable(cornerRadius, strokeWidth, color, -1));
        textView.setTextColor(ColorUtil.getColorStateList(-1, color));
        textView.getPaint().setFlags(32);
    }

    public static void setTextStrokeTheme(TextView textView, int strokeWidth, int cornerRadius) {
        DrawableUtil.setTextStrokeTheme(textView, strokeWidth, cornerRadius, ColorUtil.getRandomColor());
    }

    public static void setTextStrokeTheme(TextView textView) {
        DrawableUtil.setTextStrokeTheme(textView, 6, 10);
    }

    public static void setTextStrokeTheme(TextView textView, int color) {
        DrawableUtil.setTextStrokeTheme(textView, 6, 10, color);
    }

    public static void setTextSolidTheme(TextView textView, int strokeWidth, int cornerRadius, int color) {
        textView.setBackgroundDrawable((Drawable)DrawableUtil.getSolidStrokeDrawable(cornerRadius, strokeWidth, -1, color));
        textView.setTextColor(ColorUtil.getColorStateList(color, -1));
        textView.getPaint().setFlags(32);
    }

    public static void setTextSolidTheme(TextView textView, int strokeWidth, int cornerRadius) {
        DrawableUtil.setTextSolidTheme(textView, strokeWidth, cornerRadius, ColorUtil.getRandomColor());
    }

    public static void setTextSolidTheme(TextView textView) {
        DrawableUtil.setTextSolidTheme(textView, 6, 10);
    }
}

