/*
 * Decompiled with CFR 0.152.
 */
package com.zhj.downloadutils.tools;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import com.zhj.downloadutils.event.InstallEvent;
import com.zhj.downloadutils.event.UpdateAppBean;
import com.zhj.downloadutils.tools.Md5Util;
import java.io.File;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class AppUpdateUtils {
    public static final String IGNORE_VERSION = "ignore_version";
    private static final String PREFS_FILE = "update_app_config.xml";
    public static final int REQ_CODE_INSTALL_APP = 99;

    @SuppressLint(value={"MissingPermission"})
    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        return info != null && info.getType() == 1;
    }

    public static File getAppFile(UpdateAppBean updateAppBean) {
        String appName = AppUpdateUtils.getApkName(updateAppBean);
        return new File(updateAppBean.getTargetPath().concat(File.separator + updateAppBean.getNewVersion()).concat(File.separator + appName));
    }

    @NonNull
    public static String getApkName(UpdateAppBean updateAppBean) {
        String apkUrl = updateAppBean.getApkFileUrl();
        String appName = apkUrl.substring(apkUrl.lastIndexOf("/") + 1, apkUrl.length());
        if (!appName.endsWith(".apk")) {
            appName = "temp.apk";
        }
        return appName;
    }

    public static boolean appIsDownloaded(UpdateAppBean updateAppBean) {
        File appFile = AppUpdateUtils.getAppFile(updateAppBean);
        return !TextUtils.isEmpty((CharSequence)updateAppBean.getNewMd5()) && appFile.exists() && Md5Util.getFileMD5(appFile).equalsIgnoreCase(updateAppBean.getNewMd5());
    }

    public static boolean installApp(Context context, File appFile) {
        try {
            Intent intent = AppUpdateUtils.getInstallAppIntent(context, appFile);
            if (context.getPackageManager().queryIntentActivities(intent, 0).size() > 0) {
                context.startActivity(intent);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean installApp(Activity activity, File appFile) {
        if (Build.VERSION.SDK_INT >= 26) {
            boolean b = activity.getPackageManager().canRequestPackageInstalls();
            if (b) {
                try {
                    Intent intent = AppUpdateUtils.getInstallAppIntent((Context)activity, appFile);
                    if (activity.getPackageManager().queryIntentActivities(intent, 0).size() > 0) {
                        activity.startActivityForResult(intent, 99);
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.REQUEST_INSTALL_PACKAGES"}, (int)99);
            }
        } else {
            AppUpdateUtils.installApp(activity.getApplicationContext(), appFile);
        }
        return false;
    }

    public static boolean installApp(Fragment fragment, File appFile) {
        EventBus.getDefault().post((Object)new InstallEvent(appFile));
        return true;
    }

    public static Intent getInstallAppIntent(Context context, File appFile) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            if (Build.VERSION.SDK_INT >= 24) {
                intent.setFlags(65);
                Uri fileUri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileprovider"), (File)appFile);
                intent.setDataAndType(fileUri, "application/vnd.android.package-archive");
            } else {
                intent.setDataAndType(Uri.fromFile((File)appFile), "application/vnd.android.package-archive");
            }
            return intent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PackageInfo getPackageInfo(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAppOnForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        String packageName = context.getPackageName();
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static String getAppName(Context context) {
        PackageInfo packageInfo = AppUpdateUtils.getPackageInfo(context);
        if (packageInfo != null) {
            return packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
        }
        return "";
    }

    public static Drawable getAppIcon(Context context) {
        try {
            return context.getPackageManager().getApplicationIcon(context.getPackageName());
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static int dip2px(int dip, Context context) {
        return (int)((float)dip * AppUpdateUtils.getDensity(context) + 0.5f);
    }

    public static float getDensity(Context context) {
        return AppUpdateUtils.getDisplayMetrics((Context)context).density;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        return context.getResources().getDisplayMetrics();
    }

    public static String getManifestString(Context context, String name) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            return appInfo.metaData.getString(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SharedPreferences getSP(Context context) {
        return context.getSharedPreferences(PREFS_FILE, 0);
    }

    public static void saveIgnoreVersion(Context context, String newVersion) {
        AppUpdateUtils.getSP(context).edit().putString(IGNORE_VERSION, newVersion).apply();
    }

    public static boolean isNeedIgnore(Context context, String newVersion) {
        return AppUpdateUtils.getSP(context).getString(IGNORE_VERSION, "").equals(newVersion);
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected()) {
            return info.getState() == NetworkInfo.State.CONNECTED;
        }
        return false;
    }

    public static int getVersionCode(Context context) {
        int versionCode = 0;
        try {
            versionCode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException ex) {
            versionCode = 0;
        }
        return versionCode;
    }

    public static int getVersionCode(Context context, String packageName) {
        int versionCode = 0;
        try {
            versionCode = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException ex) {
            versionCode = 0;
        }
        return versionCode;
    }
}

