/*
 * Decompiled with CFR 0.152.
 */
package com.zhj.downloadutils.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import com.zhj.downloadutils.R;
import com.zhj.downloadutils.event.InstallEvent;
import com.zhj.downloadutils.event.UpdateAppBean;
import com.zhj.downloadutils.tools.AppUpdateUtils;
import com.zhj.downloadutils.tools.OkHttpDownloadUtil;
import java.io.File;
import org.greenrobot.eventbus.EventBus;

public class DownloadService
extends Service {
    private static final int NOTIFY_ID = 111;
    private static final String TAG = DownloadService.class.getSimpleName();
    private static final String CHANNEL_ID = "app_update_id";
    private static final CharSequence CHANNEL_NAME = "app_update_channel";
    public static boolean isRunning = false;
    private NotificationManager mNotificationManager;
    private DownloadBinder binder = new DownloadBinder();
    private NotificationCompat.Builder mBuilder;
    private boolean mDismissNotificationProgress = false;

    public static void bindService(Context context, ServiceConnection connection) {
        Intent intent = new Intent(context, DownloadService.class);
        context.startService(intent);
        context.bindService(intent, connection, 1);
        isRunning = true;
    }

    public boolean onUnbind(Intent intent) {
        isRunning = false;
        return super.onUnbind(intent);
    }

    public void onCreate() {
        super.onCreate();
        this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onDestroy() {
        this.mNotificationManager = null;
        super.onDestroy();
    }

    private void setUpNotification() {
        if (this.mDismissNotificationProgress) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, CHANNEL_NAME, 4);
            channel.enableVibration(false);
            channel.enableLights(false);
            this.mNotificationManager.createNotificationChannel(channel);
        }
        this.mBuilder = new NotificationCompat.Builder((Context)this, CHANNEL_ID);
        this.mBuilder.setContentTitle((CharSequence)"\u5f00\u59cb\u4e0b\u8f7d").setContentText((CharSequence)"\u6b63\u5728\u8fde\u63a5\u670d\u52a1\u5668").setSmallIcon(R.drawable.lib_update_app_update_icon).setLargeIcon(AppUpdateUtils.drawableToBitmap(AppUpdateUtils.getAppIcon((Context)this))).setOngoing(true).setAutoCancel(true).setWhen(System.currentTimeMillis());
        this.mNotificationManager.notify(111, this.mBuilder.build());
    }

    private void startDownload(UpdateAppBean updateApp, ProgressCallback progressCall) {
        this.mDismissNotificationProgress = updateApp.isDismissNotificationProgress();
        String apkUrl = updateApp.getApkFileUrl();
        if (TextUtils.isEmpty((CharSequence)apkUrl)) {
            String contentText = "\u65b0\u7248\u672c\u4e0b\u8f7d\u8def\u5f84\u9519\u8bef";
            this.stop(contentText);
            return;
        }
        String appName = DownloadService.getApkName(updateApp);
        File appDir = new File(updateApp.getTargetPath());
        if (!appDir.exists()) {
            appDir.mkdirs();
        }
        String target = appDir + File.separator + updateApp.getNewVersion();
        OkHttpDownloadUtil.download(apkUrl, target, appName, new FileDownloadCallBack(progressCall));
    }

    private void stop(String contentText) {
        if (this.mBuilder != null) {
            this.mBuilder.setContentTitle((CharSequence)AppUpdateUtils.getAppName((Context)this)).setContentText((CharSequence)contentText);
            Notification notification = this.mBuilder.build();
            notification.flags = 16;
            this.mNotificationManager.notify(111, notification);
        }
        this.close();
    }

    private void close() {
        this.stopSelf();
        isRunning = false;
    }

    @NonNull
    public static String getApkName(UpdateAppBean updateAppBean) {
        String apkUrl = updateAppBean.getApkFileUrl();
        String appName = apkUrl.substring(apkUrl.lastIndexOf("/") + 1, apkUrl.length());
        if (!appName.endsWith(".apk")) {
            appName = "temp.apk";
        }
        return appName;
    }

    class FileDownloadCallBack
    implements OkHttpDownloadUtil.FileCallback {
        private final ProgressCallback mCallBack;
        int oldRate = 0;

        public FileDownloadCallBack(ProgressCallback callback) {
            this.mCallBack = callback;
            this.onBefore();
        }

        @Override
        public void onBefore() {
            DownloadService.this.setUpNotification();
            if (this.mCallBack != null) {
                this.mCallBack.onStart();
            }
        }

        @Override
        public void onProgress(float progress, long total) {
            if (!isRunning) {
                return;
            }
            int rate = Math.round(progress);
            if (this.oldRate != rate) {
                if (this.mCallBack != null) {
                    this.mCallBack.setMax(total);
                    this.mCallBack.onProgress(progress, total);
                }
                if (DownloadService.this.mBuilder != null) {
                    DownloadService.this.mBuilder.setContentTitle((CharSequence)("\u6b63\u5728\u4e0b\u8f7d\uff1a" + AppUpdateUtils.getAppName((Context)DownloadService.this))).setContentText((CharSequence)(rate + "%")).setProgress(100, rate, false).setWhen(System.currentTimeMillis());
                    Notification notification = DownloadService.this.mBuilder.build();
                    notification.flags = 24;
                    DownloadService.this.mNotificationManager.notify(111, notification);
                }
                this.oldRate = rate;
            }
        }

        @Override
        public void onError(String error) {
            try {
                Toast.makeText((Context)DownloadService.this, (CharSequence)("\u66f4\u65b0\u65b0\u7248\u672c\u51fa\u9519\uff0c" + error), (int)0).show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mCallBack != null) {
                this.mCallBack.onError(error);
            }
            try {
                DownloadService.this.mNotificationManager.cancel(111);
                DownloadService.this.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(File file) {
            if (!isRunning) {
                return;
            }
            if (this.mCallBack != null && !this.mCallBack.onFinish(file)) {
                DownloadService.this.close();
                return;
            }
            try {
                if (AppUpdateUtils.isAppOnForeground((Context)DownloadService.this) || DownloadService.this.mBuilder == null) {
                    DownloadService.this.mNotificationManager.cancel(111);
                    if (this.mCallBack != null) {
                        boolean temp = this.mCallBack.onInstallAppAndAppOnForeground(file);
                        if (!temp) {
                            EventBus.getDefault().post((Object)new InstallEvent(file));
                        }
                    } else {
                        EventBus.getDefault().post((Object)new InstallEvent(file));
                    }
                } else {
                    Intent installAppIntent = AppUpdateUtils.getInstallAppIntent((Context)DownloadService.this, file);
                    PendingIntent contentIntent = PendingIntent.getActivity((Context)DownloadService.this, (int)0, (Intent)installAppIntent, (int)0x8000000);
                    DownloadService.this.mBuilder.setContentIntent(contentIntent).setContentTitle((CharSequence)AppUpdateUtils.getAppName((Context)DownloadService.this)).setContentText((CharSequence)"\u4e0b\u8f7d\u5b8c\u6210\uff0c\u8bf7\u70b9\u51fb\u5b89\u88c5").setProgress(0, 0, false).setDefaults(-1);
                    Notification notification = DownloadService.this.mBuilder.build();
                    notification.flags = 16;
                    DownloadService.this.mNotificationManager.notify(111, notification);
                }
                DownloadService.this.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DownloadService.this.close();
            }
        }
    }

    public class DownloadBinder
    extends Binder {
        public void start(UpdateAppBean updateApp, ProgressCallback callback) {
            DownloadService.this.startDownload(updateApp, callback);
        }

        public void stop(String msg) {
            DownloadService.this.stop(msg);
        }
    }

    public static interface ProgressCallback {
        public void onStart();

        public void onProgress(float var1, long var2);

        public void setMax(long var1);

        public boolean onFinish(File var1);

        public void onError(String var1);

        public boolean onInstallAppAndAppOnForeground(File var1);
    }
}

