/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall.confcall;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.hippocall.R;

public class CustomRatingBar
extends LinearLayout {
    private static final int MAX_STARS = 5;
    private static final float CURRENT_SCORE = 2.5f;
    private static final float HALF_SCORE = 0.5f;
    private static final int ANIM_DURATION = 100;
    private static final float PRESSED_STAR_SCALE = 1.1f;
    private static final float SCORE_3 = 3.0f;
    private static final double FIFTY = 50.0;
    private int mMaxStars = 5;
    private float mCurrentScore = 0.0f;
    private int mStarOnResource = R.drawable.star_blue;
    private int mStarOffResource = R.drawable.star_grey;
    private int mStarHalfResource = R.drawable.star_blue;
    private ImageView[] mStarsViews;
    private float mStarPadding;
    private IRatingBarCallbacks onScoreChanged;
    private int mLastStarId;
    private boolean mOnlyForDisplay;
    private double mLastX;
    private boolean mHalfStars = true;

    public CustomRatingBar(Context context) {
        super(context);
        this.init();
    }

    public CustomRatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeAttributes(attrs, context);
        this.init();
    }

    @TargetApi(value=11)
    public CustomRatingBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initializeAttributes(attrs, context);
        this.init();
    }

    public IRatingBarCallbacks getOnScoreChanged() {
        return this.onScoreChanged;
    }

    public void setOnScoreChanged(IRatingBarCallbacks onScoreChanged) {
        this.onScoreChanged = onScoreChanged;
    }

    public float getScore() {
        return this.mCurrentScore;
    }

    public void setScore(float score) {
        float mScore = score;
        mScore = (float)Math.round(score * 2.0f) / 2.0f;
        if (!this.mHalfStars) {
            mScore = Math.round(score);
        }
        this.mCurrentScore = mScore;
        this.refreshStars();
    }

    public void setScrollToSelect(boolean enabled) {
        this.mOnlyForDisplay = !enabled;
    }

    private void initializeAttributes(AttributeSet attrs, Context context) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CustomRatingBar);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.CustomRatingBar_maxStars) {
                this.mMaxStars = a.getInt(attr, 5);
                continue;
            }
            if (attr == R.styleable.CustomRatingBar_stars) {
                this.mCurrentScore = a.getFloat(attr, 2.5f);
                continue;
            }
            if (attr == R.styleable.CustomRatingBar_starHalf) {
                this.mStarHalfResource = a.getResourceId(attr, 17301620);
                continue;
            }
            if (attr == R.styleable.CustomRatingBar_starOn) {
                this.mStarOnResource = a.getResourceId(attr, 17301620);
                continue;
            }
            if (attr == R.styleable.CustomRatingBar_starOff) {
                this.mStarOffResource = a.getResourceId(attr, 17301621);
                continue;
            }
            if (attr == R.styleable.CustomRatingBar_starPadding) {
                this.mStarPadding = a.getDimension(attr, 0.0f);
                continue;
            }
            if (attr == R.styleable.CustomRatingBar_onlyForDisplay) {
                this.mOnlyForDisplay = a.getBoolean(attr, false);
                continue;
            }
            if (attr != R.styleable.CustomRatingBar_halfStars) continue;
            this.mHalfStars = a.getBoolean(attr, true);
        }
        a.recycle();
    }

    void init() {
        this.mStarsViews = new ImageView[this.mMaxStars];
        for (int i = 0; i < this.mMaxStars; ++i) {
            ImageView v = this.createStar();
            this.addView((View)v);
            this.mStarsViews[i] = v;
        }
        this.refreshStars();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    private float getScoreForPosition(float x) {
        if (this.mHalfStars) {
            return (float)Math.round(x / ((float)this.getWidth() / ((float)this.mMaxStars * 3.0f)) / 3.0f * 2.0f) / 2.0f;
        }
        float value = Math.round(x / ((float)this.getWidth() / (float)this.mMaxStars));
        if (value <= 0.0f) {
            value = 1.0f;
        }
        if (value > (float)this.mMaxStars) {
            value = this.mMaxStars;
        }
        return value;
    }

    private int getImageForScore(float score) {
        if (score > 0.0f) {
            return Math.round(score) - 1;
        }
        return -1;
    }

    private void refreshStars() {
        boolean flagHalf = this.mCurrentScore != 0.0f && this.mCurrentScore % 0.5f == 0.0f && this.mHalfStars;
        for (int i = 1; i <= this.mMaxStars; ++i) {
            if ((float)i <= this.mCurrentScore) {
                this.mStarsViews[i - 1].setImageResource(this.mStarOnResource);
                continue;
            }
            if (flagHalf && (float)i - 0.5f <= this.mCurrentScore) {
                this.mStarsViews[i - 1].setImageResource(this.mStarHalfResource);
                continue;
            }
            this.mStarsViews[i - 1].setImageResource(this.mStarOffResource);
        }
    }

    private ImageView createStar() {
        ImageView v = new ImageView(this.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.weight = 1.0f;
        v.setPadding((int)this.mStarPadding, 0, (int)this.mStarPadding, 0);
        v.setAdjustViewBounds(true);
        v.setScaleType(ImageView.ScaleType.FIT_CENTER);
        v.setLayoutParams((ViewGroup.LayoutParams)params);
        v.setImageResource(this.mStarOffResource);
        return v;
    }

    private ImageView getImageView(int position) {
        try {
            return this.mStarsViews[position];
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mOnlyForDisplay) {
            return true;
        }
        switch (event.getAction()) {
            case 1: {
                this.animateStarRelease(this.getImageView(this.mLastStarId));
                this.mLastStarId = -1;
                break;
            }
            case 2: {
                if (Math.abs((double)event.getX() - this.mLastX) > 50.0) {
                    this.requestDisallowInterceptTouchEvent(true);
                }
                float lastscore = this.mCurrentScore;
                this.mCurrentScore = this.getScoreForPosition(event.getX());
                if (lastscore == this.mCurrentScore) break;
                this.animateStarRelease(this.getImageView(this.mLastStarId));
                this.animateStarPressed(this.getImageView(this.getImageForScore(this.mCurrentScore)));
                this.mLastStarId = this.getImageForScore(this.mCurrentScore);
                this.refreshStars();
                if (this.onScoreChanged == null) break;
                this.onScoreChanged.scoreChanged(this.mCurrentScore);
                break;
            }
            case 0: {
                this.mLastX = event.getX();
                float lastscore = this.mCurrentScore;
                this.mCurrentScore = this.getScoreForPosition(event.getX());
                this.animateStarPressed(this.getImageView(this.getImageForScore(this.mCurrentScore)));
                this.mLastStarId = this.getImageForScore(this.mCurrentScore);
                if (lastscore == this.mCurrentScore) break;
                this.refreshStars();
                if (this.onScoreChanged == null) break;
                this.onScoreChanged.scoreChanged(this.mCurrentScore);
                break;
            }
        }
        return true;
    }

    private void animateStarPressed(ImageView star) {
        if (star != null) {
            ViewCompat.animate((View)star).scaleX(1.1f).scaleY(1.1f).setDuration(100L).start();
        }
    }

    private void animateStarRelease(ImageView star) {
        if (star != null) {
            ViewCompat.animate((View)star).scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
        }
    }

    public boolean isHalfStars() {
        return this.mHalfStars;
    }

    public void setHalfStars(boolean halfStars) {
        this.mHalfStars = halfStars;
    }

    public static interface IRatingBarCallbacks {
        public void scoreChanged(float var1);
    }
}

