/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippo.HippoConfig;
import com.hippo.model.FuguDeviceDetails;
import io.paperdb.Paper;

public final class CommonData {
    static String PAPER_CALL_STATUS = "hippo_call_status";
    static String PAPER_VIDEO_CALL = "hippo_video_call_cred";
    static String PAPER_CALL_TYPE = "hippo_call_type";
    static String PAPER_USER_ID = "hippo_user_id";

    public static String getCallStatus() {
        return (String)Paper.book().read(PAPER_CALL_STATUS);
    }

    public static String getCallType() {
        return (String)Paper.book().read(PAPER_CALL_TYPE);
    }

    public static JsonObject deviceDetails(Context context) {
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree((Object)new FuguDeviceDetails(CommonData.getAppVersion(context)).getDeviceDetails()).getAsJsonObject();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return deviceDetailsJson;
    }

    public static void setCallStatus(String callStatus) {
        Paper.book().write(PAPER_CALL_STATUS, (Object)callStatus);
    }

    public static void setCallAnswered(boolean b) {
        Paper.book().write("hippo_call_answer", (Object)b);
    }

    public static boolean isCallAnswered() {
        return (Boolean)Paper.book().read("hippo_call_answer", (Object)false);
    }

    public static void setCallType(String callType) {
        Paper.book().write(PAPER_CALL_TYPE, (Object)callType);
    }

    public static Long getUserId() {
        return Long.parseLong((String)Paper.book().read(PAPER_USER_ID));
    }

    public static int getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getPackageName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getUniqueIMEIId(Context activity) {
        String android_id;
        block7: {
            android_id = "";
            try {
                block6: {
                    try {
                        android_id = Settings.Secure.getString((ContentResolver)activity.getContentResolver(), (String)"android_id");
                    }
                    catch (Exception e) {
                        if (!HippoConfig.DEBUG) break block6;
                        e.printStackTrace();
                    }
                }
                android_id = TextUtils.isEmpty((CharSequence)android_id) ? Build.SERIAL : android_id;
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block7;
                e.printStackTrace();
            }
        }
        android_id = TextUtils.isEmpty((CharSequence)android_id) ? "12345" : android_id;
        try {
            android_id = android_id + CommonData.getPackageName(activity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return android_id;
    }

    public static boolean hasExtraView() {
        return (Boolean)Paper.book().read("hippo_call_extra_view", (Object)false);
    }

    public static void setExtraView(boolean b) {
        Paper.book().write("hippo_call_extra_view", (Object)b);
    }
}

