/*
 * Decompiled with CFR 0.152.
 */
package faye;

import android.os.Handler;
import android.os.Message;
import com.hippoagent.utils.Log;
import java.net.URI;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;

public class FuguAgentWebSocket
extends WebSocketClient {
    private static final String LOG_TAG = FuguAgentWebSocket.class.getSimpleName();
    public static final int ON_OPEN = 1;
    public static final int ON_CLOSE = 2;
    public static final int ON_MESSAGE = 3;
    public static final int ON_ERROR = 4;
    public static final int ON_PONG = 5;
    public static final int ON_NOT_CONNECTED = 6;
    private Handler messageHandler;

    public FuguAgentWebSocket(URI serverUri, Handler handler) {
        super(serverUri);
        this.messageHandler = handler;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)1));
    }

    public void onMessage(String s) {
        Log.v("Faye message", "Sending in faye ^%$^%$^%$^%$^$:   " + s);
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)3, (Object)s));
    }

    public void onClose(int code, String reason, boolean remote) {
        Log.i(LOG_TAG, "code: " + code + ", reason: " + reason + ", remote: " + remote);
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)2));
    }

    public void onError(Exception e) {
        e.printStackTrace();
        Log.e(LOG_TAG, "On FuguAgentWebSocket Error:" + e);
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)6));
    }

    public void onClosing(int code, String reason, boolean remote) {
        super.onClosing(code, reason, remote);
        Log.i(LOG_TAG, "#code: " + code + " #reason: " + reason + " #remote: " + remote);
    }

    public void setConnectionLostTimeout(int connectionLostTimeout) {
        super.setConnectionLostTimeout(connectionLostTimeout);
        Log.i(LOG_TAG, "connectionLostTimeout: " + connectionLostTimeout);
    }

    protected void startConnectionLostTimer() {
        super.startConnectionLostTimer();
        Log.e(LOG_TAG, "On startConnectionLostTimer");
    }

    public boolean reconnectBlocking() throws InterruptedException {
        return super.reconnectBlocking();
    }

    public void onWebsocketPong(WebSocket conn, Framedata f) {
        super.onWebsocketPong(conn, f);
        this.messageHandler.sendMessage(Message.obtain((Handler)this.messageHandler, (int)5, (Object)f));
        Log.e(LOG_TAG, "On onWebsocketPong");
    }

    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
        super.onWebsocketHandshakeReceivedAsClient(conn, request, response);
        Log.e(LOG_TAG, "On onWebsocketHandshakeReceivedAsClient");
    }
}

