/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.typekit;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.hippoagent.utils.typekit.ReflectionUtils;
import com.hippoagent.utils.typekit.TypekitFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;

public class TypekitLayoutInflater
extends LayoutInflater {
    private static final String[] CLASS_PREFIX_LIST = new String[]{"android.widget.", "android.webkit."};
    private TypekitFactory mTypekitFactory;
    private boolean mSetPrivateFactory = false;
    private Field mConstructorArgs = null;

    public TypekitLayoutInflater(Context context) {
        super(context);
        this.initLayoutFactories(false);
    }

    public TypekitLayoutInflater(LayoutInflater original, Context newContext, boolean cloned) {
        super(original, newContext);
        this.mTypekitFactory = new TypekitFactory();
        this.initLayoutFactories(cloned);
    }

    public LayoutInflater cloneInContext(Context newContext) {
        return new TypekitLayoutInflater(this, newContext, true);
    }

    private void initLayoutFactories(boolean cloned) {
        if (cloned) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 11 && this.getFactory2() != null && !(this.getFactory2() instanceof WrapperFactory2)) {
            this.setFactory2(this.getFactory2());
        }
        if (this.getFactory() != null && !(this.getFactory() instanceof WrapperFactory)) {
            this.setFactory(this.getFactory());
        }
    }

    public View inflate(int resource, ViewGroup root, boolean attachToRoot) {
        this.setPrivateFactoryInternal();
        return super.inflate(resource, root, attachToRoot);
    }

    public View inflate(XmlPullParser parser, ViewGroup root, boolean attachToRoot) {
        this.setPrivateFactoryInternal();
        return super.inflate(parser, root, attachToRoot);
    }

    private void setPrivateFactoryInternal() {
        if (this.mSetPrivateFactory) {
            return;
        }
        if (!(this.getContext() instanceof LayoutInflater.Factory2)) {
            this.mSetPrivateFactory = true;
            return;
        }
        Method setPrivateFactoryMethod = ReflectionUtils.getMethod(LayoutInflater.class, "setPrivateFactory");
        if (setPrivateFactoryMethod != null) {
            ReflectionUtils.invokeMethod((Object)this, setPrivateFactoryMethod, new PrivateWrapperFactory2((LayoutInflater.Factory2)this.getContext(), this, this.mTypekitFactory));
        }
        this.mSetPrivateFactory = true;
    }

    public void setFactory(LayoutInflater.Factory factory) {
        if (!(factory instanceof WrapperFactory)) {
            super.setFactory((LayoutInflater.Factory)new WrapperFactory(factory, this, this.mTypekitFactory));
        } else {
            super.setFactory(factory);
        }
    }

    @TargetApi(value=11)
    public void setFactory2(LayoutInflater.Factory2 factory2) {
        if (!(factory2 instanceof WrapperFactory2)) {
            super.setFactory2((LayoutInflater.Factory2)new WrapperFactory2(factory2, this.mTypekitFactory));
        } else {
            super.setFactory2(factory2);
        }
    }

    @TargetApi(value=11)
    protected View onCreateView(View parent, String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.mTypekitFactory.onViewCreated(super.onCreateView(parent, name, attrs), name, parent, this.getContext(), attrs);
    }

    protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        View view = null;
        for (String prefix : CLASS_PREFIX_LIST) {
            try {
                view = this.createView(name, prefix, attrs);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (view == null) {
            view = super.onCreateView(name, attrs);
        }
        return this.mTypekitFactory.onViewCreated(view, name, null, view.getContext(), attrs);
    }

    public View onActivityCreateView(View parent, View view, String name, Context context, AttributeSet attrs) {
        return this.mTypekitFactory.onViewCreated(this.createCustomViewInternal(parent, view, name, context, attrs), context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View createCustomViewInternal(View parent, View view, String name, Context viewContext, AttributeSet attrs) {
        if (view == null && name.indexOf(46) > -1) {
            if (this.mConstructorArgs == null) {
                this.mConstructorArgs = ReflectionUtils.getField(LayoutInflater.class, "mConstructorArgs");
            }
            Object[] mConstructorArgsArr = (Object[])ReflectionUtils.getValue(this.mConstructorArgs, (Object)this);
            Object lastContext = mConstructorArgsArr[0];
            mConstructorArgsArr[0] = viewContext;
            ReflectionUtils.setValue(this.mConstructorArgs, (Object)this, mConstructorArgsArr);
            try {
                view = this.createView(name, null, attrs);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            finally {
                mConstructorArgsArr[0] = lastContext;
                ReflectionUtils.setValue(this.mConstructorArgs, (Object)this, mConstructorArgsArr);
            }
        }
        return view;
    }

    @TargetApi(value=11)
    private static class PrivateWrapperFactory2
    extends WrapperFactory2 {
        private final TypekitLayoutInflater mInflater;

        public PrivateWrapperFactory2(LayoutInflater.Factory2 factory2, TypekitLayoutInflater inflater, TypekitFactory typekitFactory) {
            super(factory2, typekitFactory);
            this.mInflater = inflater;
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.mTypekitFactory.onViewCreated(this.mInflater.createCustomViewInternal(parent, this.mFactory2.onCreateView(parent, name, context, attrs), name, context, attrs), name, parent, context, attrs);
        }
    }

    @TargetApi(value=11)
    private static class WrapperFactory2
    implements LayoutInflater.Factory2 {
        protected final LayoutInflater.Factory2 mFactory2;
        protected final TypekitFactory mTypekitFactory;

        public WrapperFactory2(LayoutInflater.Factory2 mFactory2, TypekitFactory mDecorFactory) {
            this.mFactory2 = mFactory2;
            this.mTypekitFactory = mDecorFactory;
        }

        public View onCreateView(String name, Context context, AttributeSet attrs) {
            return this.mTypekitFactory.onViewCreated(this.mFactory2.onCreateView(name, context, attrs), name, null, context, attrs);
        }

        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            return this.mTypekitFactory.onViewCreated(this.mFactory2.onCreateView(parent, name, context, attrs), name, parent, context, attrs);
        }
    }

    private static class WrapperFactory
    implements LayoutInflater.Factory {
        private final LayoutInflater.Factory mFactory;
        private final TypekitLayoutInflater mInflater;
        private final TypekitFactory mTypekitFactory;

        public WrapperFactory(LayoutInflater.Factory factory, TypekitLayoutInflater inflater, TypekitFactory typekitFactory) {
            this.mFactory = factory;
            this.mInflater = inflater;
            this.mTypekitFactory = typekitFactory;
        }

        public View onCreateView(String name, Context context, AttributeSet attrs) {
            if (Build.VERSION.SDK_INT < 11) {
                return this.mTypekitFactory.onViewCreated(this.mInflater.createCustomViewInternal(null, this.mFactory.onCreateView(name, context, attrs), name, context, attrs), context, attrs);
            }
            return this.mTypekitFactory.onViewCreated(this.mFactory.onCreateView(name, context, attrs), name, null, context, attrs);
        }
    }
}

