/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.typekit;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.widget.Toolbar;
import com.hippoagent.R;
import com.hippoagent.utils.typekit.Typekit;
import com.hippoagent.utils.typekit.TypekitSpan;

public class TypekitFactory {
    public View onViewCreated(View view, String name, View parent, Context context, AttributeSet attrs) {
        if (view == null) {
            return null;
        }
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            this.applyFontForTextView(context, attrs, textView);
        } else if (view instanceof Toolbar) {
            Toolbar toolbar = (Toolbar)view;
            for (int i = 0; i < toolbar.getChildCount(); ++i) {
                View child = toolbar.getChildAt(i);
                if (!(child instanceof TextView)) continue;
                this.applyFontForTextView(context, attrs, (TextView)child);
            }
        }
        return view;
    }

    public View onViewCreated(View view, Context context, AttributeSet attrs) {
        return view;
    }

    private void applyFontForTextView(Context context, AttributeSet attrs, TextView textView) {
        String fontKey;
        if (textView.getTag(R.id.typekit) != null) {
            return;
        }
        Typekit typekit = Typekit.getInstance();
        TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.Typekit);
        String string2 = fontKey = array2 != null ? array2.getString(R.styleable.Typekit_fontName) : null;
        if (!TextUtils.isEmpty((CharSequence)fontKey)) {
            textView.setTypeface(typekit.get(fontKey));
        } else {
            Typeface typeface = textView.getTypeface();
            if (typeface == null || !typeface.isBold() && !typeface.isItalic()) {
                textView.setTypeface(typekit.get(Typekit.Style.Normal));
            } else if (typeface.isBold() && typeface.isItalic()) {
                textView.setTypeface(typekit.get(Typekit.Style.BoldItalic));
            } else if (typeface.isBold()) {
                textView.setTypeface(typekit.get(Typekit.Style.Bold));
            } else {
                textView.setTypeface(typekit.get(Typekit.Style.Italic));
            }
            if (textView.getText() instanceof Spanned) {
                Spanned spanned = (Spanned)textView.getText();
                StyleSpan[] spans = (StyleSpan[])spanned.getSpans(0, spanned.length(), StyleSpan.class);
                SpannableStringBuilder builder2 = new SpannableStringBuilder(textView.getText());
                builder2.setSpan((Object)new TypekitSpan(0, typekit), 0, spanned.length(), 34);
                if (spans != null && spans.length > 0) {
                    for (StyleSpan styleSpan : spans) {
                        int start = spanned.getSpanStart((Object)styleSpan);
                        int end = spanned.getSpanEnd((Object)styleSpan);
                        if (styleSpan.getStyle() == 1) {
                            builder2.setSpan((Object)new TypekitSpan(1, typekit), start, end, 34);
                            continue;
                        }
                        if (styleSpan.getStyle() == 3) {
                            builder2.setSpan((Object)new TypekitSpan(3, typekit), start, end, 34);
                            continue;
                        }
                        if (styleSpan.getStyle() != 2) continue;
                        builder2.setSpan((Object)new TypekitSpan(2, typekit), start, end, 34);
                    }
                }
                textView.setText((CharSequence)builder2);
            }
        }
        if (array2 != null) {
            array2.recycle();
        }
        textView.setTag(R.id.typekit, (Object)true);
    }
}

