/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.swipeLayout.frame;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.hippoagent.R;
import com.hippoagent.utils.swipeLayout.SwipeGestureManager;
import com.hippoagent.utils.swipeLayout.listener.LayoutShiftListener;
import com.hippoagent.utils.swipeLayout.listener.OnLayoutPercentageChangeListener;
import com.hippoagent.utils.swipeLayout.listener.OnLayoutSwipedListener;
import java.util.HashSet;
import java.util.Set;

public class SwipeableLayout
extends FrameLayout {
    private float swipeSpeed;
    private SwipeGestureManager swipeManager;
    private int swipeOrientationMode;
    private boolean scrollAndClickable;
    private boolean isSwipeable = true;
    private final Set<Integer> blocks = new HashSet<Integer>();
    private OnLayoutSwipedListener onLayoutSwipedListener;
    private OnLayoutPercentageChangeListener onLayoutPercentageChangeListener;
    private LayoutShiftListener layoutShiftListener;

    public SwipeableLayout(Context context) {
        super(context);
        this.inflateAttributes(context, null);
    }

    public SwipeableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.inflateAttributes(context, attrs);
    }

    public SwipeableLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.inflateAttributes(context, attrs);
    }

    @TargetApi(value=21)
    public SwipeableLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.inflateAttributes(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflateAttributes(Context context, @Nullable AttributeSet attributeSet) {
        this.swipeSpeed = 0.7f;
        this.swipeOrientationMode = 1;
        if (attributeSet != null) {
            TypedArray attributes = context.obtainStyledAttributes(attributeSet, R.styleable.SwipeableLayout);
            try {
                this.swipeSpeed = attributes.getFloat(R.styleable.SwipeableLayout_swipeSpeed, this.swipeSpeed);
                this.swipeOrientationMode = attributes.getInt(R.styleable.SwipeableLayout_swipeOrientation, this.swipeOrientationMode);
                this.scrollAndClickable = attributes.getBoolean(R.styleable.SwipeableLayout_scrollAndClickable, this.scrollAndClickable);
            }
            finally {
                attributes.recycle();
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.scrollAndClickable) {
            super.dispatchTouchEvent(ev);
        }
        return this.swipeManager.onTouch((View)this, ev);
    }

    public void initSwipeManager() {
        SwipeGestureManager.Builder builder2 = new SwipeGestureManager.Builder(this.getContext());
        builder2.setSwipeSpeed(this.swipeSpeed);
        builder2.setOrientationMode(this.swipeOrientationMode);
        builder2.setStartCoordinates(this.getX(), this.getY());
        this.swipeManager = builder2.create();
        this.swipeManager.setOnLayoutPercentageChangeListener(this.onLayoutPercentageChangeListener);
        this.swipeManager.setOnSwipedListener(this.onLayoutSwipedListener);
        this.swipeManager.setBlockSet(this.blocks);
        this.swipeManager.setLayoutShiftListener(this.layoutShiftListener);
        this.setOnTouchListener(this.swipeManager);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initSwipeManager();
    }

    public void addBlock(int orientationMode) {
        if (this.swipeManager != null) {
            this.swipeManager.addBlock(orientationMode);
        } else {
            this.blocks.add(orientationMode);
        }
    }

    public void isSwipeable(boolean isSwipeable) {
        if (this.swipeManager != null) {
            this.swipeManager.isSwipeable(isSwipeable);
        } else {
            this.isSwipeable = isSwipeable;
        }
    }

    public void removeBlock(int orientationMode) {
        if (this.swipeManager != null) {
            this.swipeManager.removeBlock(orientationMode);
        } else {
            this.blocks.remove(orientationMode);
        }
    }

    public void setSwipeSpeed(int swipeSpeed) {
        if (this.swipeManager != null) {
            this.swipeManager.setSwipeSpeed(swipeSpeed);
        } else {
            this.swipeSpeed = swipeSpeed;
        }
    }

    public void setSwipeOrientationMode(int orientationMode) {
        if (this.swipeManager != null) {
            this.swipeManager.setOrientationMode(orientationMode);
        } else {
            this.swipeOrientationMode = orientationMode;
        }
    }

    public void setOnSwipedListener(OnLayoutSwipedListener onLayoutSwipedListener) {
        this.onLayoutSwipedListener = onLayoutSwipedListener;
    }

    public void setOnLayoutPercentageChangeListener(OnLayoutPercentageChangeListener onLayoutPercentageChangeListener) {
        this.onLayoutPercentageChangeListener = onLayoutPercentageChangeListener;
    }

    public void setLayoutShiftListener(LayoutShiftListener layoutShiftListener) {
        this.layoutShiftListener = layoutShiftListener;
    }
}

