/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.app.Activity;
import android.content.Context;
import android.util.Patterns;
import android.widget.EditText;
import com.hippoagent.R;
import com.hippoagent.langs.Restring;

public class ValidateClass {
    private Activity context;
    private int fifteen = 15;
    private int ten = 10;
    private int twelve = 12;

    public ValidateClass(Activity context) {
        this.context = context;
    }

    public boolean genericEmpty(EditText et) {
        return et.getText().toString().trim().isEmpty();
    }

    public boolean genericEmpty(EditText et, String msg) {
        if (this.genericEmpty(et)) {
            return this.setErrorAndRequestFoucs(et, msg);
        }
        return true;
    }

    public boolean setErrorAndRequestFoucs(EditText et, String errorMessage) {
        et.setSelection(et.getText().toString().length());
        et.setHovered(true);
        et.requestFocus();
        et.setError((CharSequence)errorMessage);
        return false;
    }

    public Boolean checkPassword(EditText et) {
        if (this.genericEmpty(et)) {
            return this.setErrorAndRequestFoucs(et, Restring.getString((Context)this.context, R.string.PleaseEnterPassword));
        }
        if (et.getText().toString().length() < 6) {
            return this.setErrorAndRequestFoucs(et, Restring.getString((Context)this.context, R.string.PasswordContainAtleastSixChar));
        }
        return true;
    }

    public Boolean passwordMatch(EditText passEt, EditText confirmPassEt) {
        if (this.genericEmpty(confirmPassEt)) {
            return this.setErrorAndRequestFoucs(confirmPassEt, Restring.getString((Context)this.context, R.string.PleaseEnterConfrimPassword));
        }
        if (!passEt.getText().toString().equals(confirmPassEt.getText().toString())) {
            return this.setErrorAndRequestFoucs(confirmPassEt, Restring.getString((Context)this.context, R.string.PasswordDoesntMatch));
        }
        return true;
    }

    public Boolean checkName(EditText et) {
        if (this.genericEmpty(et)) {
            return this.setErrorAndRequestFoucs(et, Restring.getString((Context)this.context, R.string.PleaseEnterFirstName));
        }
        if (et.getText().toString().trim().length() < 3) {
            return this.setErrorAndRequestFoucs(et, Restring.getString((Context)this.context, R.string.NameThreeCharLong));
        }
        if (!et.getText().toString().matches("^[\\p{L} .'-]+$")) {
            return this.setErrorAndRequestFoucs(et, Restring.getString((Context)this.context, R.string.NameCannotContainSpecialCharacters));
        }
        return true;
    }

    public Boolean checkLastName(EditText et) {
        if (this.genericEmpty(et)) {
            return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterLastName));
        }
        if (!et.getText().toString().trim().matches("\\p{L}+")) {
            return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.LastNameCannotContainSpecialChar));
        }
        return true;
    }

    public Boolean checkEmail(EditText et) {
        String email = et.getText().toString().trim();
        if (this.genericEmpty(et)) {
            return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterEmailId));
        }
        if (!email.matches(Patterns.EMAIL_ADDRESS.toString())) {
            return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterValidEmail));
        }
        return true;
    }

    public Boolean checkPhoneNumber(EditText et, boolean loginScreen) {
        try {
            String phone = et.getText().toString();
            if (phone.matches("[^a-zA-Z]+")) {
                phone = phone.replace("[^a-zA-Z]+", "");
            }
            if (this.genericEmpty(et)) {
                return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterPhoneNo));
            }
            if (phone.trim().charAt(0) == '0') {
                return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PhoneNoCannotStartFromZero));
            }
            if (phone.trim().length() > this.fifteen) {
                return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PhoneLengthAtmostfifteen));
            }
            if (phone.trim().length() < this.ten && loginScreen) {
                return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterValidPhoneNo));
            }
            if (phone.trim().length() < this.twelve && !loginScreen) {
                return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterValidPhoneNo));
            }
            return true;
        }
        catch (NumberFormatException e) {
            return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterValidPhoneNo));
        }
    }

    public Boolean checkOTP(String otp, EditText et) {
        if (otp.compareTo("") == 0) {
            return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterOtp));
        }
        if (otp.length() < 4) {
            return this.setErrorAndRequestFoucs(et, this.context.getString(R.string.PleaseEnterFourDigitOtp));
        }
        return true;
    }
}

