/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.content.Context;
import android.widget.Toast;
import java.lang.ref.WeakReference;

public class ToastUtil {
    private static WeakReference<Context> mContext;
    private static ToastUtil mInstance;
    private Toast mToast;

    public static ToastUtil getInstance(Context ctx) {
        if (mInstance == null || mContext.get() == null) {
            mInstance = new ToastUtil(ctx);
        }
        return mInstance;
    }

    private ToastUtil(Context ctx) {
        mContext = new WeakReference<Context>(ctx);
    }

    public void showToast(String text) {
        if (this.mToast == null) {
            this.mToast = Toast.makeText((Context)((Context)mContext.get()), (CharSequence)text, (int)0);
        } else {
            this.mToast.setText((CharSequence)text);
            this.mToast.setDuration(0);
        }
        this.mToast.show();
    }

    public void showToast(int resID) {
        this.showToast(((Context)mContext.get()).getResources().getString(resID));
    }

    public void cancelToast() {
        if (this.mToast != null) {
            this.mToast.cancel();
        }
    }
}

