/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.hippoagent.R;

public class SelectableRoundedImageView
extends ImageView {
    public static final String TAG = "SelectableRoundedImageView";
    private int mResource = 0;
    private static final ImageView.ScaleType[] sScaleTypeArray = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
    private float mLeftTopCornerRadius = 0.0f;
    private float mRightTopCornerRadius = 0.0f;
    private float mLeftBottomCornerRadius = 0.0f;
    private float mRightBottomCornerRadius = 0.0f;
    private float mBorderWidth = 0.0f;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private ColorStateList mBorderColor = ColorStateList.valueOf((int)-16777216);
    private boolean isOval = false;
    private Drawable mDrawable;
    private float[] mRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public SelectableRoundedImageView(Context context) {
        super(context);
    }

    public SelectableRoundedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SelectableRoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SelectableRoundedImageView, defStyle, 0);
        int index = a.getInt(R.styleable.SelectableRoundedImageView_android_scaleType, -1);
        if (index >= 0) {
            this.setScaleType(sScaleTypeArray[index]);
        }
        this.mLeftTopCornerRadius = a.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_left_top_corner_radius, 0);
        this.mRightTopCornerRadius = a.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_right_top_corner_radius, 0);
        this.mLeftBottomCornerRadius = a.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_left_bottom_corner_radius, 0);
        this.mRightBottomCornerRadius = a.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_right_bottom_corner_radius, 0);
        if (this.mLeftTopCornerRadius < 0.0f || this.mRightTopCornerRadius < 0.0f || this.mLeftBottomCornerRadius < 0.0f || this.mRightBottomCornerRadius < 0.0f) {
            throw new IllegalArgumentException("radius values cannot be negative.");
        }
        this.mRadii = new float[]{this.mLeftTopCornerRadius, this.mLeftTopCornerRadius, this.mRightTopCornerRadius, this.mRightTopCornerRadius, this.mRightBottomCornerRadius, this.mRightBottomCornerRadius, this.mLeftBottomCornerRadius, this.mLeftBottomCornerRadius};
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_border_width, 0);
        if (this.mBorderWidth < 0.0f) {
            throw new IllegalArgumentException("border width cannot be negative.");
        }
        this.mBorderColor = a.getColorStateList(R.styleable.SelectableRoundedImageView_sriv_border_color);
        if (this.mBorderColor == null) {
            this.mBorderColor = ColorStateList.valueOf((int)-16777216);
        }
        this.isOval = a.getBoolean(R.styleable.SelectableRoundedImageView_sriv_oval, false);
        a.recycle();
        this.updateDrawable();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(scaleType);
        this.mScaleType = scaleType;
        this.updateDrawable();
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mResource = 0;
        this.mDrawable = SelectableRoundedCornerDrawable.fromDrawable(drawable2, this.getResources());
        super.setImageDrawable(this.mDrawable);
        this.updateDrawable();
    }

    public void setImageBitmap(Bitmap bm) {
        this.mResource = 0;
        this.mDrawable = SelectableRoundedCornerDrawable.fromBitmap(bm, this.getResources());
        super.setImageDrawable(this.mDrawable);
        this.updateDrawable();
    }

    public void setImageResource(int resId) {
        if (this.mResource != resId) {
            this.mResource = resId;
            this.mDrawable = this.resolveResource();
            super.setImageDrawable(this.mDrawable);
            this.updateDrawable();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.setImageDrawable(this.getDrawable());
    }

    private Drawable resolveResource() {
        Resources rsrc = this.getResources();
        if (rsrc == null) {
            return null;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = rsrc.getDrawable(this.mResource);
            }
            catch (Resources.NotFoundException e) {
                Log.w((String)TAG, (String)("Unable to find resource: " + this.mResource), (Throwable)e);
                this.mResource = 0;
            }
        }
        return SelectableRoundedCornerDrawable.fromDrawable(d, this.getResources());
    }

    private void updateDrawable() {
        if (this.mDrawable == null) {
            return;
        }
        ((SelectableRoundedCornerDrawable)this.mDrawable).setScaleType(this.mScaleType);
        ((SelectableRoundedCornerDrawable)this.mDrawable).setCornerRadii(this.mRadii);
        ((SelectableRoundedCornerDrawable)this.mDrawable).setBorderWidth(this.mBorderWidth);
        ((SelectableRoundedCornerDrawable)this.mDrawable).setBorderColor(this.mBorderColor);
        ((SelectableRoundedCornerDrawable)this.mDrawable).setOval(this.isOval);
    }

    public float getCornerRadius() {
        return this.mLeftTopCornerRadius;
    }

    public void setCornerRadiiDP(float leftTop, float rightTop, float leftBottom, float rightBottom) {
        float density = this.getResources().getDisplayMetrics().density;
        float lt = leftTop * density;
        float rt = rightTop * density;
        float lb = leftBottom * density;
        float rb = rightBottom * density;
        this.mRadii = new float[]{lt, lt, rt, rt, rb, rb, lb, lb};
        this.updateDrawable();
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidthDP(float width) {
        float scaledWidth = this.getResources().getDisplayMetrics().density * width;
        if (this.mBorderWidth == scaledWidth) {
            return;
        }
        this.mBorderWidth = scaledWidth;
        this.updateDrawable();
        this.invalidate();
    }

    public int getBorderColor() {
        return this.mBorderColor.getDefaultColor();
    }

    public void setBorderColor(int color2) {
        this.setBorderColor(ColorStateList.valueOf((int)color2));
    }

    public ColorStateList getBorderColors() {
        return this.mBorderColor;
    }

    public void setBorderColor(ColorStateList colors) {
        if (this.mBorderColor.equals(colors)) {
            return;
        }
        this.mBorderColor = colors != null ? colors : ColorStateList.valueOf((int)-16777216);
        this.updateDrawable();
        if (this.mBorderWidth > 0.0f) {
            this.invalidate();
        }
    }

    public boolean isOval() {
        return this.isOval;
    }

    public void setOval(boolean oval) {
        this.isOval = oval;
        this.updateDrawable();
        this.invalidate();
    }

    static class SelectableRoundedCornerDrawable
    extends Drawable {
        private static final String TAG = "SelectableRoundedCornerDrawable";
        private static final int DEFAULT_BORDER_COLOR = -16777216;
        private RectF mBounds = new RectF();
        private RectF mBorderBounds = new RectF();
        private final RectF mBitmapRect = new RectF();
        private final int mBitmapWidth;
        private final int mBitmapHeight;
        private final Paint mBitmapPaint;
        private final Paint mBorderPaint;
        private BitmapShader mBitmapShader;
        private float[] mRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        private float[] mBorderRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        private boolean mOval = false;
        private float mBorderWidth = 0.0f;
        private ColorStateList mBorderColor = ColorStateList.valueOf((int)-16777216);
        private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
        private Path mPath = new Path();
        private Bitmap mBitmap;
        private boolean mBoundsConfigured = false;

        public SelectableRoundedCornerDrawable(Bitmap bitmap, Resources r) {
            this.mBitmap = bitmap;
            this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            if (bitmap != null) {
                this.mBitmapWidth = bitmap.getScaledWidth(r.getDisplayMetrics());
                this.mBitmapHeight = bitmap.getScaledHeight(r.getDisplayMetrics());
            } else {
                this.mBitmapHeight = -1;
                this.mBitmapWidth = -1;
            }
            this.mBitmapRect.set(0.0f, 0.0f, (float)this.mBitmapWidth, (float)this.mBitmapHeight);
            this.mBitmapPaint = new Paint(1);
            this.mBitmapPaint.setStyle(Paint.Style.FILL);
            this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
            this.mBorderPaint = new Paint(1);
            this.mBorderPaint.setStyle(Paint.Style.STROKE);
            this.mBorderPaint.setColor(this.mBorderColor.getColorForState(this.getState(), -16777216));
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        }

        public static SelectableRoundedCornerDrawable fromBitmap(Bitmap bitmap, Resources r) {
            if (bitmap != null) {
                return new SelectableRoundedCornerDrawable(bitmap, r);
            }
            return null;
        }

        public static Drawable fromDrawable(Drawable drawable2, Resources r) {
            if (drawable2 != null) {
                if (drawable2 instanceof SelectableRoundedCornerDrawable) {
                    return drawable2;
                }
                if (drawable2 instanceof LayerDrawable) {
                    LayerDrawable ld = (LayerDrawable)drawable2;
                    int num = ld.getNumberOfLayers();
                    for (int i = 0; i < num; ++i) {
                        Drawable d = ld.getDrawable(i);
                        ld.setDrawableByLayerId(ld.getId(i), SelectableRoundedCornerDrawable.fromDrawable(d, r));
                    }
                    return ld;
                }
                Bitmap bm = SelectableRoundedCornerDrawable.drawableToBitmap(drawable2);
                if (bm != null) {
                    return new SelectableRoundedCornerDrawable(bm, r);
                }
                Log.w((String)TAG, (String)"Failed to create bitmap from drawable!");
            }
            return drawable2;
        }

        public static Bitmap drawableToBitmap(Drawable drawable2) {
            Bitmap bitmap;
            if (drawable2 == null) {
                return null;
            }
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
            int width = Math.max(drawable2.getIntrinsicWidth(), 2);
            int height = Math.max(drawable2.getIntrinsicHeight(), 2);
            try {
                bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable2.draw(canvas);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                bitmap = null;
            }
            return bitmap;
        }

        public boolean isStateful() {
            return this.mBorderColor.isStateful();
        }

        protected boolean onStateChange(int[] state) {
            int newColor = this.mBorderColor.getColorForState(state, 0);
            if (this.mBorderPaint.getColor() != newColor) {
                this.mBorderPaint.setColor(newColor);
                return true;
            }
            return super.onStateChange(state);
        }

        private void configureBounds(Canvas canvas) {
            Rect clipBounds = canvas.getClipBounds();
            Matrix canvasMatrix = canvas.getMatrix();
            if (ImageView.ScaleType.CENTER == this.mScaleType) {
                this.mBounds.set(clipBounds);
            } else if (ImageView.ScaleType.CENTER_CROP == this.mScaleType) {
                this.applyScaleToRadii(canvasMatrix);
                this.mBounds.set(clipBounds);
            } else if (ImageView.ScaleType.FIT_XY == this.mScaleType) {
                Matrix m = new Matrix();
                m.setRectToRect(this.mBitmapRect, new RectF(clipBounds), Matrix.ScaleToFit.FILL);
                this.mBitmapShader.setLocalMatrix(m);
                this.mBounds.set(clipBounds);
            } else if (ImageView.ScaleType.FIT_START == this.mScaleType || ImageView.ScaleType.FIT_END == this.mScaleType || ImageView.ScaleType.FIT_CENTER == this.mScaleType || ImageView.ScaleType.CENTER_INSIDE == this.mScaleType) {
                this.applyScaleToRadii(canvasMatrix);
                this.mBounds.set(this.mBitmapRect);
            } else if (ImageView.ScaleType.MATRIX == this.mScaleType) {
                this.applyScaleToRadii(canvasMatrix);
                this.mBounds.set(this.mBitmapRect);
            }
        }

        private void applyScaleToRadii(Matrix m) {
            float[] values = new float[9];
            m.getValues(values);
            for (int i = 0; i < this.mRadii.length; ++i) {
                this.mRadii[i] = this.mRadii[i] / values[0];
            }
        }

        private void adjustCanvasForBorder(Canvas canvas) {
            Matrix canvasMatrix = canvas.getMatrix();
            float[] values = new float[9];
            canvasMatrix.getValues(values);
            float scaleFactorX = values[0];
            float scaleFactorY = values[4];
            float translateX = values[2];
            float translateY = values[5];
            float newScaleX = this.mBounds.width() / (this.mBounds.width() + this.mBorderWidth + this.mBorderWidth);
            float newScaleY = this.mBounds.height() / (this.mBounds.height() + this.mBorderWidth + this.mBorderWidth);
            canvas.scale(newScaleX, newScaleY);
            if (ImageView.ScaleType.FIT_START == this.mScaleType || ImageView.ScaleType.FIT_END == this.mScaleType || ImageView.ScaleType.FIT_XY == this.mScaleType || ImageView.ScaleType.FIT_CENTER == this.mScaleType || ImageView.ScaleType.CENTER_INSIDE == this.mScaleType || ImageView.ScaleType.MATRIX == this.mScaleType) {
                canvas.translate(this.mBorderWidth, this.mBorderWidth);
            } else if (ImageView.ScaleType.CENTER == this.mScaleType || ImageView.ScaleType.CENTER_CROP == this.mScaleType) {
                canvas.translate(-translateX / (newScaleX * scaleFactorX), -translateY / (newScaleY * scaleFactorY));
                canvas.translate(-(this.mBounds.left - this.mBorderWidth), -(this.mBounds.top - this.mBorderWidth));
            }
        }

        private void adjustBorderWidthAndBorderBounds(Canvas canvas) {
            Matrix canvasMatrix = canvas.getMatrix();
            float[] values = new float[9];
            canvasMatrix.getValues(values);
            float scaleFactor = values[0];
            float viewWidth = this.mBounds.width() * scaleFactor;
            this.mBorderWidth = this.mBorderWidth * this.mBounds.width() / (viewWidth - 2.0f * this.mBorderWidth);
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
            this.mBorderBounds.set(this.mBounds);
            this.mBorderBounds.inset(-this.mBorderWidth / 2.0f, -this.mBorderWidth / 2.0f);
        }

        private void setBorderRadii() {
            for (int i = 0; i < this.mRadii.length; ++i) {
                if (!(this.mRadii[i] > 0.0f)) continue;
                this.mBorderRadii[i] = this.mRadii[i];
                this.mRadii[i] = this.mRadii[i] - this.mBorderWidth;
            }
        }

        public void draw(Canvas canvas) {
            canvas.save();
            if (!this.mBoundsConfigured) {
                this.configureBounds(canvas);
                if (this.mBorderWidth > 0.0f) {
                    this.adjustBorderWidthAndBorderBounds(canvas);
                    this.setBorderRadii();
                }
                this.mBoundsConfigured = true;
            }
            if (this.mOval) {
                if (this.mBorderWidth > 0.0f) {
                    this.adjustCanvasForBorder(canvas);
                    this.mPath.addOval(this.mBounds, Path.Direction.CW);
                    canvas.drawPath(this.mPath, this.mBitmapPaint);
                    this.mPath.reset();
                    this.mPath.addOval(this.mBorderBounds, Path.Direction.CW);
                    canvas.drawPath(this.mPath, this.mBorderPaint);
                } else {
                    this.mPath.addOval(this.mBounds, Path.Direction.CW);
                    canvas.drawPath(this.mPath, this.mBitmapPaint);
                }
            } else if (this.mBorderWidth > 0.0f) {
                this.adjustCanvasForBorder(canvas);
                this.mPath.addRoundRect(this.mBounds, this.mRadii, Path.Direction.CW);
                canvas.drawPath(this.mPath, this.mBitmapPaint);
                this.mPath.reset();
                this.mPath.addRoundRect(this.mBorderBounds, this.mBorderRadii, Path.Direction.CW);
                canvas.drawPath(this.mPath, this.mBorderPaint);
            } else {
                this.mPath.addRoundRect(this.mBounds, this.mRadii, Path.Direction.CW);
                canvas.drawPath(this.mPath, this.mBitmapPaint);
            }
            canvas.restore();
        }

        public void setCornerRadii(float[] radii) {
            if (radii == null) {
                return;
            }
            if (radii.length != 8) {
                throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
            }
            for (int i = 0; i < radii.length; ++i) {
                this.mRadii[i] = radii[i];
            }
        }

        public int getOpacity() {
            return this.mBitmap == null || this.mBitmap.hasAlpha() || this.mBitmapPaint.getAlpha() < 255 ? -3 : -1;
        }

        public void setAlpha(int alpha) {
            this.mBitmapPaint.setAlpha(alpha);
            this.invalidateSelf();
        }

        public void setColorFilter(ColorFilter cf) {
            this.mBitmapPaint.setColorFilter(cf);
            this.invalidateSelf();
        }

        public void setDither(boolean dither) {
            this.mBitmapPaint.setDither(dither);
            this.invalidateSelf();
        }

        public void setFilterBitmap(boolean filter) {
            this.mBitmapPaint.setFilterBitmap(filter);
            this.invalidateSelf();
        }

        public int getIntrinsicWidth() {
            return this.mBitmapWidth;
        }

        public int getIntrinsicHeight() {
            return this.mBitmapHeight;
        }

        public float getBorderWidth() {
            return this.mBorderWidth;
        }

        public void setBorderWidth(float width) {
            this.mBorderWidth = width;
            this.mBorderPaint.setStrokeWidth(width);
        }

        public int getBorderColor() {
            return this.mBorderColor.getDefaultColor();
        }

        public void setBorderColor(int color2) {
            this.setBorderColor(ColorStateList.valueOf((int)color2));
        }

        public ColorStateList getBorderColors() {
            return this.mBorderColor;
        }

        public void setBorderColor(ColorStateList colors) {
            if (colors == null) {
                this.mBorderWidth = 0.0f;
                this.mBorderColor = ColorStateList.valueOf((int)0);
                this.mBorderPaint.setColor(0);
            } else {
                this.mBorderColor = colors;
                this.mBorderPaint.setColor(this.mBorderColor.getColorForState(this.getState(), -16777216));
            }
        }

        public boolean isOval() {
            return this.mOval;
        }

        public void setOval(boolean oval) {
            this.mOval = oval;
        }

        public ImageView.ScaleType getScaleType() {
            return this.mScaleType;
        }

        public void setScaleType(ImageView.ScaleType scaleType) {
            if (scaleType == null) {
                return;
            }
            this.mScaleType = scaleType;
        }
    }
}

