/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import com.hippoagent.R;
import com.kbeanie.multipicker.api.CameraImagePicker;
import com.kbeanie.multipicker.api.ImagePicker;
import com.kbeanie.multipicker.api.callbacks.ImagePickerCallback;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import java.util.List;

public class ImageChooser
implements ImagePickerCallback {
    private static int CACHE_LOCATION = 200;
    private String CANCEL = "Cancel";
    private String CAMERA = "Take a New Photo";
    private String SETTING = "Settings";
    private String GALLERY = "Pick From Gallery";
    private String MULTIPLE = "Multiple";
    private String CHOOSE_IMAGE = "Select Picture";
    private String OK = "Ok";
    private String CAMERA_READ_WRITE_PERMISSION_MSG = "Permissions are required for camera & storage.";
    private String CAMERA_READ_WRITE_PERMISSION_DENIED = "Permissions denied. Please grant permission for camera & storage in setting";
    private String[] PERMISSION_CAMERA_READ_WRITE = new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final int PERMISSION_REQUEST_CODE_CAMERA_READ_WRITE = 1900;
    private String filePath;
    private Activity mActivity;
    private androidx.fragment.app.Fragment mFragment;
    private Fragment appFragment;
    private ImagePicker imagePicker;
    private CameraImagePicker cameraPicker;
    private AlertDialog mAlertDialog;

    public ImageChooser(Activity mActivity) {
        this.mActivity = mActivity;
    }

    public ImageChooser(androidx.fragment.app.Fragment mFragment) {
        this.mFragment = mFragment;
    }

    public ImageChooser(Fragment appFragment) {
        this.appFragment = appFragment;
    }

    public void onImagesChosen(List<ChosenImage> list) {
        if (list != null && list.size() > 0) {
            try {
                OnImageSelectListener mOnImageSelect = (OnImageSelectListener)(this.mActivity != null ? this.mActivity : (this.mFragment != null ? this.mFragment : this.appFragment));
                if (mOnImageSelect != null) {
                    mOnImageSelect.loadImage(list);
                }
            }
            catch (ClassCastException e) {
                Toast.makeText((Context)this.getActivityContext(), (CharSequence)"Implement OnImageSelectListener in calling class", (int)1).show();
            }
        }
    }

    public void onError(String s) {
        if (this.mAlertDialog != null && this.mAlertDialog.isShowing()) {
            this.mAlertDialog.dismiss();
        }
        AlertDialog.Builder builder2 = new AlertDialog.Builder((Context)this.getActivityContext());
        builder2.setMessage((CharSequence)s).setPositiveButton((CharSequence)this.OK, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                ImageChooser.this.mAlertDialog.dismiss();
            }
        });
        this.mAlertDialog = builder2.create();
        this.mAlertDialog.show();
    }

    private void requestMarshMallowPermission() {
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivityContext(), (String)"android.permission.CAMERA") || ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivityContext(), (String)"android.permission.READ_EXTERNAL_STORAGE") || ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivityContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            if (this.mAlertDialog != null && this.mAlertDialog.isShowing()) {
                this.mAlertDialog.dismiss();
            }
            AlertDialog.Builder builder2 = new AlertDialog.Builder((Context)this.getActivityContext());
            builder2.setMessage((CharSequence)this.CAMERA_READ_WRITE_PERMISSION_MSG).setPositiveButton((CharSequence)this.OK, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    ActivityCompat.requestPermissions((Activity)ImageChooser.this.getActivityContext(), (String[])ImageChooser.this.PERMISSION_CAMERA_READ_WRITE, (int)1900);
                }
            }).setNegativeButton((CharSequence)this.CANCEL, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    ImageChooser.this.mAlertDialog.dismiss();
                }
            });
            this.mAlertDialog = builder2.create();
            this.mAlertDialog.show();
        } else {
            ActivityCompat.requestPermissions((Activity)this.getActivityContext(), (String[])this.PERMISSION_CAMERA_READ_WRITE, (int)1900);
        }
    }

    private Activity getActivityContext() {
        return this.mActivity != null ? this.mActivity : (this.mFragment != null ? this.mFragment.getActivity() : (this.appFragment != null ? this.appFragment.getActivity() : null));
    }

    public void pickImageSingle() {
        this.imagePicker = this.getImagePicker();
        this.imagePicker.setFolderName("Random");
        this.imagePicker.setRequestId(1234);
        this.imagePicker.ensureMaxSize(500, 500);
        this.imagePicker.shouldGenerateMetadata(true);
        this.imagePicker.shouldGenerateThumbnails(true);
        this.imagePicker.setImagePickerCallback((ImagePickerCallback)this);
        Bundle bundle = new Bundle();
        bundle.putInt("android.intent.extras.CAMERA_FACING", 1);
        this.imagePicker.setCacheLocation(CACHE_LOCATION);
        this.imagePicker.pickImage();
    }

    public void takePicture() {
        this.cameraPicker = this.getCameraImagePicker();
        this.cameraPicker.setCacheLocation(CACHE_LOCATION);
        this.cameraPicker.setImagePickerCallback((ImagePickerCallback)this);
        this.cameraPicker.shouldGenerateMetadata(true);
        this.cameraPicker.shouldGenerateThumbnails(true);
        this.filePath = this.cameraPicker.pickImage();
    }

    private void pickImageMultiple() {
        this.imagePicker = this.getImagePicker();
        this.imagePicker.setImagePickerCallback((ImagePickerCallback)this);
        this.imagePicker.allowMultiple();
        this.imagePicker.pickImage();
    }

    private ImagePicker getImagePicker() {
        ImagePicker mImagePicker = this.mActivity != null ? new ImagePicker(this.mActivity) : (this.mFragment != null ? new ImagePicker(this.mFragment) : new ImagePicker(this.appFragment));
        return mImagePicker;
    }

    private CameraImagePicker getCameraImagePicker() {
        CameraImagePicker mCameraImagePicker = this.mActivity != null ? new CameraImagePicker(this.mActivity) : (this.mFragment != null ? new CameraImagePicker(this.mFragment) : new CameraImagePicker(this.appFragment));
        return mCameraImagePicker;
    }

    private void startInstalledAppDetailsActivity(Activity context) {
        if (context == null) {
            return;
        }
        Intent i = new Intent();
        i.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        i.addCategory("android.intent.category.DEFAULT");
        i.setData(Uri.parse((String)("package:" + context.getPackageName())));
        i.addFlags(0x10000000);
        i.addFlags(0x40000000);
        i.addFlags(0x800000);
        context.startActivity(i);
    }

    private boolean verifyPermissions(int[] grantResults) {
        if (grantResults.length < 1) {
            return false;
        }
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public void selectImage() {
        if (Build.VERSION.SDK_INT >= 23 && (ActivityCompat.checkSelfPermission((Context)this.getActivityContext(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0 || ActivityCompat.checkSelfPermission((Context)this.getActivityContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0 || ActivityCompat.checkSelfPermission((Context)this.getActivityContext(), (String)"android.permission.CAMERA") != 0)) {
            this.requestMarshMallowPermission();
            return;
        }
        if (this.mAlertDialog != null && this.mAlertDialog.isShowing()) {
            this.mAlertDialog.dismiss();
        }
        AlertDialog.Builder builder2 = new AlertDialog.Builder((Context)this.getActivityContext());
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivityContext());
        View dialogView = inflater.inflate(R.layout.dialog_image_chooser, null);
        Button takeImage = (Button)dialogView.findViewById(R.id.btnCamera);
        Button uploadImage = (Button)dialogView.findViewById(R.id.btnGallery);
        builder2.setView(dialogView);
        this.mAlertDialog = builder2.create();
        takeImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageChooser.this.mAlertDialog.dismiss();
                ImageChooser.this.takePicture();
            }
        });
        uploadImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageChooser.this.mAlertDialog.dismiss();
                ImageChooser.this.pickImageSingle();
            }
        });
        this.mAlertDialog.show();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1900: {
                if (this.verifyPermissions(grantResults)) {
                    this.selectImage();
                    break;
                }
                if (this.mAlertDialog != null && this.mAlertDialog.isShowing()) {
                    this.mAlertDialog.dismiss();
                }
                AlertDialog.Builder builder2 = new AlertDialog.Builder((Context)this.getActivityContext());
                builder2.setMessage((CharSequence)this.CAMERA_READ_WRITE_PERMISSION_DENIED).setPositiveButton((CharSequence)this.SETTING, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        ImageChooser.this.mAlertDialog.dismiss();
                        ImageChooser.this.startInstalledAppDetailsActivity(ImageChooser.this.getActivityContext());
                    }
                }).setNegativeButton((CharSequence)this.CANCEL, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        ImageChooser.this.mAlertDialog.dismiss();
                    }
                });
                this.mAlertDialog = builder2.create();
                this.mAlertDialog.show();
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            if (requestCode == 3111) {
                if (this.imagePicker == null) {
                    this.imagePicker = this.getImagePicker();
                    this.imagePicker.setImagePickerCallback((ImagePickerCallback)this);
                }
                this.imagePicker.submit(data);
            } else if (requestCode == 4222) {
                if (this.cameraPicker == null) {
                    this.cameraPicker = this.getCameraImagePicker();
                    this.cameraPicker.setImagePickerCallback((ImagePickerCallback)this);
                    this.cameraPicker.reinitialize(this.filePath);
                }
                this.cameraPicker.submit(data);
            }
        }
    }

    public static interface OnImageSelectListener {
        public void loadImage(List<ChosenImage> var1);
    }
}

