/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class HttpHandler {
    private static final String TAG = HttpHandler.class.getSimpleName();

    public String makeServiceCall(String reqUrl) {
        String response = null;
        try {
            URL url = new URL(reqUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            response = this.convertStreamToString(in);
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)("MalformedURLException: " + e.getMessage()));
        }
        catch (ProtocolException e) {
            Log.e((String)TAG, (String)("ProtocolException: " + e.getMessage()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("IOException: " + e.getMessage()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception: " + e.getMessage()));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

