/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import androidx.appcompat.widget.AppCompatEditText;
import java.util.ArrayList;
import java.util.List;

public class EditTextSelectable
extends AppCompatEditText {
    private KeyImeChange keyImeChangeListener;
    private List<onSelectionChangedListener> listeners = new ArrayList<onSelectionChangedListener>();

    public void setKeyImeChangeListener(KeyImeChange listener) {
        this.keyImeChangeListener = listener;
    }

    public EditTextSelectable(Context context) {
        super(context);
    }

    public EditTextSelectable(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public EditTextSelectable(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void addOnSelectionChangedListener(onSelectionChangedListener o) {
        this.listeners.add(o);
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        if (this.listeners != null) {
            for (onSelectionChangedListener l : this.listeners) {
                l.onSelectionChanged(selStart, selEnd);
            }
        }
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (this.keyImeChangeListener != null) {
            this.keyImeChangeListener.onKeyIme(keyCode, event);
        }
        return false;
    }

    public static interface KeyImeChange {
        public void onKeyIme(int var1, KeyEvent var2);
    }

    public static interface onSelectionChangedListener {
        public void onSelectionChanged(int var1, int var2);
    }
}

