/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.text.InputFilter;
import android.text.Spanned;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DecimalDigitsInputFilter
implements InputFilter {
    private final int digitsBeforeZero;
    private final int digitsAfterZero;
    private Pattern mPattern;

    public DecimalDigitsInputFilter(int digitsBeforeZero, int digitsAfterZero) {
        this.digitsBeforeZero = digitsBeforeZero;
        this.digitsAfterZero = digitsAfterZero;
        this.applyPattern(digitsBeforeZero, digitsAfterZero);
    }

    private void applyPattern(int digitsBeforeZero, int digitsAfterZero) {
        this.mPattern = Pattern.compile("[0-9]{0," + (digitsBeforeZero - 1) + "}+((\\.[0-9]{0," + (digitsAfterZero - 1) + "})?)|(\\.)?");
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        if (dest.toString().contains(".") || source.toString().contains(".")) {
            this.applyPattern(this.digitsBeforeZero + 2, this.digitsAfterZero);
        } else {
            this.applyPattern(this.digitsBeforeZero, this.digitsAfterZero);
        }
        Matcher matcher = this.mPattern.matcher((CharSequence)dest);
        if (!matcher.matches()) {
            return "";
        }
        return null;
    }
}

