/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.retrofit;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.utils.Log;
import java.util.HashMap;

public class CommonParams {
    HashMap<String, String> map = new HashMap();
    Gson gson = new GsonBuilder().create();

    private CommonParams(Builder builder2, boolean hasLang, String langCode) {
        JsonObject deviceDetailsJson = null;
        String deviceID = null;
        try {
            deviceDetailsJson = this.gson.toJsonTree((Object)new DeviceDetails(HippoApplication.getInstance().getAppVersion()).getDeviceDetails()).getAsJsonObject();
            Log.e("TAG", "" + this.gson.toJson((JsonElement)deviceDetailsJson));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            deviceID = HippoApplication.getInstance().getDeviceId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder2.map.put("source_type", String.valueOf(1));
        builder2.map.put("app_version", String.valueOf(260));
        builder2.map.put("device_type", String.valueOf(1));
        if (deviceDetailsJson != null) {
            builder2.map.put("device_details", this.gson.toJson((JsonElement)deviceDetailsJson));
        }
        if (!TextUtils.isEmpty((CharSequence)deviceID)) {
            builder2.map.put("device_id", deviceID);
        }
        if (HippoConfig.getInstance().getAttributes().getIsWhitelabel()) {
            builder2.map.put("reference_secret_key", HippoConfig.getInstance().getAttributes().getAppKey());
        }
        if (hasLang) {
            if (!TextUtils.isEmpty((CharSequence)langCode)) {
                builder2.map.put("lang", langCode);
            }
        } else if (!TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getCurrentLanguage())) {
            builder2.map.put("lang", HippoConfig.getInstance().getCurrentLanguage());
        }
        this.map = builder2.map;
    }

    public HashMap<String, String> getMap() {
        return this.map;
    }

    public static class Builder {
        HashMap<String, String> map = new HashMap();

        public Builder addAccessToken(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder add(String key, Object value) {
            this.map.put(key, String.valueOf(value));
            return this;
        }

        public Builder addAll(HashMap<String, String> objectHashMap) {
            this.map.putAll(objectHashMap);
            return this;
        }

        public CommonParams build() {
            return new CommonParams(this, false, "");
        }

        public CommonParams build(boolean hasLang, String langCode) {
            return new CommonParams(this, hasLang, langCode);
        }
    }
}

