/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.receiver;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import com.hippoagent.callback.OnCloseListener;
import com.hippoagent.callback.OnInitializedListener;
import com.hippoagent.receiver.FuguNetworkStateReceiver;
import com.hippoagent.utils.Log;

public class NetworkManager
implements OnCloseListener,
OnInitializedListener {
    private static final String LOG_TAG = NetworkManager.class.getSimpleName();
    private final FuguNetworkStateReceiver connectivityReceiver;
    private final ConnectivityManager connectivityManager;
    private static NetworkManager instance;
    private Application application;

    public static NetworkManager getInstance(Application application) {
        if (instance == null) {
            instance = new NetworkManager(application);
        }
        return instance;
    }

    private NetworkManager(Application application) {
        this.application = application;
        this.connectivityReceiver = new FuguNetworkStateReceiver();
        this.connectivityManager = (ConnectivityManager)application.getSystemService("connectivity");
    }

    @Override
    public void onInitialized() {
        Log.i(LOG_TAG, "onInitialized");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.application.registerReceiver((BroadcastReceiver)this.connectivityReceiver, filter);
    }

    @Override
    public void onClose() {
        try {
            Log.i(LOG_TAG, "connectivityReceiver unregistered");
            this.application.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
        }
        catch (IllegalArgumentException e) {
            Log.e(LOG_TAG, e.toString());
        }
    }
}

