/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.model.graph;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Comparator;

public class AgentsDatum {
    @SerializedName(value="agent_id")
    @Expose
    private Integer agentId;
    @SerializedName(value="agent_name")
    @Expose
    private String agentName;
    @SerializedName(value="assigned_count")
    @Expose
    private Integer assignedCount;
    @SerializedName(value="replied_count")
    @Expose
    private Integer repliedCount;
    @SerializedName(value="closed_count")
    @Expose
    private Integer closedCount;
    @SerializedName(value="avg_first_response")
    @Expose
    private Double avgFirstResponse;
    @SerializedName(value="avg_closed_time")
    @Expose
    private Double avgClosedTime;
    @SerializedName(value="currently_assigned")
    @Expose
    private Integer currentlyAssigned;
    @SerializedName(value="currently_replied")
    @Expose
    private Integer currentlyReplied;
    @SerializedName(value="currently_closed")
    @Expose
    private Integer currentlyClosed;
    public static Comparator<AgentsDatum> agentNameAscComparator = new Comparator<AgentsDatum>(){

        @Override
        public int compare(AgentsDatum s1, AgentsDatum s2) {
            String agentName1 = s1.getAgentName().toUpperCase().trim();
            String agentName2 = s2.getAgentName().toUpperCase().trim();
            return agentName1.compareTo(agentName2);
        }
    };
    public static Comparator<AgentsDatum> agentNameDesComparator = new Comparator<AgentsDatum>(){

        @Override
        public int compare(AgentsDatum s1, AgentsDatum s2) {
            String agentName1 = s1.getAgentName().toUpperCase().trim();
            String agentName2 = s2.getAgentName().toUpperCase().trim();
            return agentName2.compareTo(agentName1);
        }
    };
    public static Comparator<AgentsDatum> agentAssignedAscComparator = new Comparator<AgentsDatum>(){

        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return o1.getAssignedCount() - o2.getAssignedCount();
        }
    };
    public static Comparator<AgentsDatum> agentAssignedDecComparator = new Comparator<AgentsDatum>(){

        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return o2.getAssignedCount() - o1.getAssignedCount();
        }
    };
    public static Comparator<AgentsDatum> agentClosedAscComparator = new Comparator<AgentsDatum>(){

        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return o1.getCurrentlyClosed() - o2.getCurrentlyClosed();
        }
    };
    public static Comparator<AgentsDatum> agentClosedDecComparator = new Comparator<AgentsDatum>(){

        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return o2.getCurrentlyClosed() - o1.getCurrentlyClosed();
        }
    };
    public static Comparator<AgentsDatum> agentAvgRespAscComparator = new Comparator<AgentsDatum>(){

        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return Double.compare(o1.getAvgFirstResponse(), o2.getAvgFirstResponse());
        }
    };
    public static Comparator<AgentsDatum> agentAvgRespDecComparator = new Comparator<AgentsDatum>(){

        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return Double.compare(o2.getAvgFirstResponse(), o1.getAvgFirstResponse());
        }
    };

    public Integer getAgentId() {
        return this.agentId;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Integer getAssignedCount() {
        return this.assignedCount;
    }

    public void setAssignedCount(Integer assignedCount) {
        this.assignedCount = assignedCount;
    }

    public Integer getRepliedCount() {
        return this.repliedCount;
    }

    public void setRepliedCount(Integer repliedCount) {
        this.repliedCount = repliedCount;
    }

    public Integer getClosedCount() {
        return this.closedCount;
    }

    public void setClosedCount(Integer closedCount) {
        this.closedCount = closedCount;
    }

    public Double getAvgFirstResponse() {
        return this.avgFirstResponse;
    }

    public void setAvgFirstResponse(Double avgFirstResponse) {
        this.avgFirstResponse = avgFirstResponse;
    }

    public Double getAvgClosedTime() {
        return this.avgClosedTime;
    }

    public void setAvgClosedTime(Double avgClosedTime) {
        this.avgClosedTime = avgClosedTime;
    }

    public Integer getCurrentlyAssigned() {
        return this.currentlyAssigned;
    }

    public void setCurrentlyAssigned(Integer currentlyAssigned) {
        this.currentlyAssigned = currentlyAssigned;
    }

    public Integer getCurrentlyReplied() {
        return this.currentlyReplied;
    }

    public void setCurrentlyReplied(Integer currentlyReplied) {
        this.currentlyReplied = currentlyReplied;
    }

    public Integer getCurrentlyClosed() {
        return this.currentlyClosed;
    }

    public void setCurrentlyClosed(Integer currentlyClosed) {
        this.currentlyClosed = currentlyClosed;
    }
}

