/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.hippocall;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.confcall.HungUpBroadcast;
import com.hippoagent.confcall.OngoingCallService;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.dialogs.ShowDialg;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConnectionUtils;
import com.hippoagent.hippocall.AppContants;
import com.hippoagent.hippocall.CommonData;
import com.hippoagent.hippocall.FuguCallActivity;
import com.hippoagent.hippocall.MainCallingActivity;
import com.hippoagent.hippocall.StringAttributes;
import com.hippoagent.hippocall.VideoCallModel;
import com.hippoagent.hippocall.VideoCallService;
import com.hippoagent.hippocall.WebRTCCallConstants;
import com.hippoagent.hippocall.model.Message;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.groupCall.GroupCallData;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jitsi.meet.sdk.JitsiMeet;
import org.jitsi.meet.sdk.JitsiMeetActivity;
import org.jitsi.meet.sdk.JitsiMeetConferenceOptions;
import org.jitsi.meet.sdk.JitsiMeetUserInfo;
import org.json.JSONArray;
import org.json.JSONObject;

public class HippoCallConfig
implements FuguAppConstant {
    private static HippoCallConfig instance;
    private Boolean state = true;
    private CountDownTimer countDown;
    private StringAttributes actionString;
    private Context mContext;
    public static final String LOCAL_SURFACE = "hippo_local_status";
    public static final String REMOTE_SURFACE = "hippo_remote_status";
    public static final String FLIP_CAMERA = "hippo_flip_camera";
    private String INCOMING_CALL = "incoming Call";
    private String jitsiURL = "";
    private Context context;
    private JSONObject jsonObject;
    private Fragment fragment;
    boolean emitUserBusy;
    private volatile boolean isAppVisible;

    protected boolean isNetworkConnected() {
        return this.state;
    }

    public void networkStatus(boolean status2) {
        this.state = status2;
    }

    private HippoCallConfig() {
    }

    public String getJitsiURL() {
        if (TextUtils.isEmpty((CharSequence)this.jitsiURL) && HippoApplication.getInstance().getUserData() != null && HippoApplication.getInstance().getUserData().getBusinessProperty() != null && !TextUtils.isEmpty((CharSequence)HippoApplication.getInstance().getUserData().getBusinessProperty().getJitsiUrl())) {
            this.jitsiURL = HippoApplication.getInstance().getUserData().getBusinessProperty().getJitsiUrl();
        }
        return this.jitsiURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HippoCallConfig getInstance() {
        if (instance != null) return instance;
        Class<HippoCallConfig> clazz = HippoCallConfig.class;
        synchronized (HippoCallConfig.class) {
            if (instance != null) return instance;
            instance = new HippoCallConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Context getContext() {
        return this.mContext.getApplicationContext();
    }

    public void setCallBackListener(Context context) {
        this.mContext = context;
    }

    public void sendMessage(Long channelId, JSONObject jsonObject) {
        ConnectionManager.INSTANCE.publish("/" + channelId, jsonObject, true);
    }

    private void sendUserBusyBroadcast(Context context, long channelId, String messageUniqueId, String videoCallType, long userId) {
        Intent videoCallIntent = new Intent("hippo_video_call_intent");
        videoCallIntent.putExtra("channel_id", channelId);
        videoCallIntent.putExtra("muid", messageUniqueId);
        videoCallIntent.putExtra("video_call_type", videoCallType);
        videoCallIntent.putExtra("user_id", userId);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(videoCallIntent);
    }

    public void onNotificationReceived(Context context, JSONObject data) {
        block2: {
            try {
                this.onCallIncomming(context, data);
            }
            catch (Exception e) {
                if (!HippoConfig.getInstance().getAttributes().isShowLog()) break block2;
                e.printStackTrace();
            }
        }
    }

    public void onConfNotificationReceived(Context context, JSONObject data) {
        block2: {
            try {
                this.onStartConferenceCall(context, data);
            }
            catch (Exception e) {
                if (!HippoConfig.getInstance().getAttributes().isShowLog()) break block2;
                e.printStackTrace();
            }
        }
    }

    public void onCallClick(Context context, int callType, Long channelId, Integer userId, boolean isAgentFlow, boolean isAllowCall, String fullname, String image) {
        Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        if (!this.isMyServiceRunning(context, VideoCallService.class)) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            String messageUniqueId = UUID.randomUUID().toString();
            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
            String typeCall = WebRTCCallConstants.CallType.VIDEO.toString();
            if (callType == 2) {
                typeCall = WebRTCCallConstants.CallType.AUDIO.toString();
            }
            VideoCallModel videoCallModel = new VideoCallModel(channelId, image, fullname, userId, -1L, fullname, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, typeCall, "", "", "", "", "");
            videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        }
        context.startActivity(videoIntent);
    }

    public void onConfCallClick(Context context, VideoCallModel videoCallModel) {
        this.context = context;
        if (!this.isMyServiceRunning(context, OngoingCallService.class)) {
            Intent videoIntent = new Intent(context.getApplicationContext(), MainCallingActivity.class);
            videoIntent.addFlags(0x10000000);
            videoIntent.addFlags(0x800000);
            videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
            context.startActivity(videoIntent);
        }
    }

    private Long timeInMillis(String timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        Long timeInMilliseconds = 0L;
        try {
            Date mDate = sdf.parse(DateUtils.getInstance().convertToLocal(timeStamp));
            timeInMilliseconds = mDate.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timeInMilliseconds;
    }

    private void onCallIncomming(final Context context, JSONObject jsonObject) throws Exception {
        this.context = context;
        this.jsonObject = jsonObject;
        Log.v("TAG", "jsonObject = " + jsonObject.toString());
        ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
        List taskList = mngr.getRunningTasks(10);
        Integer userId = HippoApplication.getInstance().getUserData().getUserId();
        String fullname = jsonObject.optString("full_name");
        Long channelId = jsonObject.optLong("channel_id");
        String messageUniqueId = jsonObject.optString("muid");
        String videoCallType = jsonObject.optString("video_call_type", "");
        if (!((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippoagent.hippocall.FuguCallActivity") && !this.isMyServiceRunning(context, VideoCallService.class) && jsonObject.getInt("notification_type") == 14 && jsonObject.has("video_call_type") && jsonObject.optString("video_call_type").equals("START_CALL") && userId.compareTo(-1) != 0 && !jsonObject.optString("device_id", "").equals(UniqueIMEIID.getUniqueIMEIId(context)) && userId.compareTo(jsonObject.optInt("user_id")) != 0 && System.currentTimeMillis() - this.timeInMillis(jsonObject.getString("date_time")) < 30000L) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    HippoCallConfig.this.countDown = new CountDownTimer(30000L, 1000L){

                        public void onTick(long millisUntilFinished) {
                        }

                        public void onFinish() {
                            ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
                            List taskList = mngr.getRunningTasks(10);
                            if (!((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().contains("hippocall")) {
                                // empty if block
                            }
                        }
                    };
                    HippoCallConfig.this.countDown.start();
                }
            }, 0L);
            ConnectionManager.INSTANCE.initFayeConnection();
            ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
        } else if (jsonObject.getInt("notification_type") == 14 && jsonObject.has("video_call_type") && jsonObject.optString("video_call_type").equals("START_CALL")) {
            ConnectionManager.INSTANCE.initFayeConnection();
            try {
                JSONObject json = new JSONObject();
                json.put("video_call_type", (Object)WebRTCCallConstants.VideoCallType.USER_BUSY.toString());
                json.put("is_silent", true);
                json.put("user_id", (Object)userId);
                json.put("full_name", (Object)fullname);
                json.put("message_type", 18);
                json.put("is_typing", 0);
                json.put("muid", (Object)messageUniqueId);
                JSONObject devicePayload = new JSONObject();
                devicePayload.put("device_id", (Object)CommonData.getUniqueIMEIId(context));
                devicePayload.put("device_type", 1);
                devicePayload.put("app_version", (Object)"2.6.0");
                devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
                json.put("device_payload", (Object)devicePayload);
                ConnectionManager.INSTANCE.publish("/" + channelId, json);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.sendUserBusyBroadcast(context, channelId, messageUniqueId, videoCallType, userId.intValue());
        }
    }

    protected boolean isCallActive(Context context) {
        AudioManager manager = (AudioManager)context.getSystemService("audio");
        return manager.getMode() == 2;
    }

    public void oldSDKCall(String message, String channel) {
        Message turnCredentials = new AppContants().getTurnCredentials();
        Integer userId = HippoApplication.getInstance().getUserData().getUserId();
        String fullname = this.jsonObject.optString("full_name");
        Long channelId = this.jsonObject.optLong("channel_id");
        String messageUniqueId = this.jsonObject.optString("muid");
        String videoCallType = this.jsonObject.optString("video_call_type", "");
        String callType = this.jsonObject.optString("call_type", "");
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
        String userImage = !TextUtils.isEmpty((CharSequence)this.jsonObject.optString("user_image")) ? this.jsonObject.optString("user_image") : (!TextUtils.isEmpty((CharSequence)this.jsonObject.optString("thumbnail_url")) ? this.jsonObject.optString("thumbnail_url") : this.jsonObject.optString("image_url", ""));
        Intent videoIntent = new Intent(this.context.getApplicationContext(), FuguCallActivity.class);
        VideoCallModel videoCallModel = new VideoCallModel(channelId, userImage, fullname, userId, -1L, fullname, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId, callType.toUpperCase(), "", "", "", "", "");
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        this.callRecieved(this.context, message, videoIntent, this.jsonObject, videoCallModel, (long)userId);
    }

    private void callRecieved(Context context, String messageJson, Intent videoIntent, JSONObject notificationJson, VideoCallModel videoCallModel, Long myUserId) {
        try {
            JSONObject json = new JSONObject(messageJson);
            if (json.has("message_type") && json.getInt("message_type") == 18 && json.getString("muid").equals(notificationJson.getString("muid"))) {
                Log.e("VIDEO_JSON", json.toString());
                if (json.getString("video_call_type").equals("START_CALL")) {
                    JSONObject readyToConnectJson = new JSONObject();
                    readyToConnectJson.put("video_call_type", (Object)"READY_TO_CONNECT");
                    readyToConnectJson.put("is_silent", true);
                    readyToConnectJson.put("user_id", (Object)myUserId);
                    readyToConnectJson.put("message_type", 18);
                    readyToConnectJson.put("is_typing", 0);
                    readyToConnectJson.put("muid", (Object)notificationJson.getString("muid"));
                    this.addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel, notificationJson.getString("channel_id"), videoCallModel.getCallType());
                } else if (json.getString("video_call_type").equals("VIDEO_OFFER")) {
                    if (!this.isCallActive(context)) {
                        ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
                        List taskList = mngr.getRunningTasks(10);
                        this.countDown.cancel();
                        if (!(((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippocall.FuguCallActivity") || this.isMyServiceRunning(context, VideoCallService.class) || ((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().contains("GrantPermissionsActivity"))) {
                            videoIntent.putExtra("video_offer", messageJson);
                            if (Build.VERSION.SDK_INT > 28) {
                                this.startCallForegroundService(context, this.INCOMING_CALL, videoCallModel, messageJson);
                            } else {
                                context.startActivity(videoIntent);
                            }
                        }
                    } else {
                        JSONObject readyToConnectJson = new JSONObject();
                        readyToConnectJson.put("video_call_type", (Object)"USER_BUSY");
                        readyToConnectJson.put("is_silent", true);
                        readyToConnectJson.put("user_id", (Object)myUserId);
                        readyToConnectJson.put("message_type", 18);
                        readyToConnectJson.put("is_typing", 0);
                        readyToConnectJson.put("muid", (Object)notificationJson.getString("muid"));
                        this.addTurnCredentialsAndDeviceDetails(context, readyToConnectJson, videoCallModel, notificationJson.getString("channel_id"), videoCallModel.getCallType());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTurnCredentialsAndDeviceDetails(Context context, JSONObject readyToConnectJson, VideoCallModel videoCallModel, String channelId, String callType) {
        try {
            int i;
            JSONArray stunServers = new JSONArray();
            JSONArray turnServers = new JSONArray();
            JSONObject videoCallCredentials = new JSONObject();
            videoCallCredentials.put("turnApiKey", (Object)videoCallModel.getTurnApiKey());
            videoCallCredentials.put("username", (Object)videoCallModel.getTurnUserName());
            videoCallCredentials.put("credential", (Object)videoCallModel.getTurnCredential());
            for (i = 0; i < videoCallModel.getStunServers().size(); ++i) {
                stunServers.put((Object)videoCallModel.getStunServers().get(i));
            }
            for (i = 0; i < videoCallModel.getTurnServers().size(); ++i) {
                turnServers.put((Object)videoCallModel.getTurnServers().get(i));
            }
            JSONObject devicePayload = new JSONObject();
            devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId(context));
            devicePayload.put("device_type", 1);
            devicePayload.put("app_version", (Object)"2.0.5");
            devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
            videoCallCredentials.put("stun", (Object)stunServers);
            videoCallCredentials.put("turn", (Object)turnServers);
            readyToConnectJson.put("turn_creds", (Object)videoCallCredentials);
            readyToConnectJson.put("device_payload", (Object)devicePayload);
            readyToConnectJson.put("call_type", (Object)callType);
            this.publishSignalToFaye(channelId, readyToConnectJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void publishSignalToFaye(String channelId, JSONObject signalJson) {
        ConnectionManager.INSTANCE.publish("/" + channelId, signalJson);
    }

    protected Fragment getFragment() {
        return this.fragment;
    }

    private boolean isMyServiceRunning(Context context, Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private void sendBusyStatus(JSONObject jsonObject) {
        try {
            Integer userId = HippoApplication.getInstance().getUserData().getUserId();
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)jsonObject.optString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails(this.context));
            startCallJson.put("invite_link", (Object)jsonObject.optString("invite_link"));
            startCallJson.put("muid", (Object)jsonObject.optString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)jsonObject.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            this.sendMessage(jsonObject.optLong("channel_id"), startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onStartConferenceCall(Context context, JSONObject jsonObject) throws Exception {
        this.context = context;
        this.jsonObject = jsonObject;
        if (jsonObject.has("video_call_type")) {
            if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.START_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
                    this.emitUserBusy = true;
                    this.sendBusyStatus(jsonObject);
                } else {
                    Long channelId = jsonObject.optLong("channel_id");
                    ConnectionManager.INSTANCE.initFayeConnection();
                    ConnectionManager.INSTANCE.subScribeChannel("/" + HippoApplication.getInstance().getUserData().getUserChannel());
                    ConnectionManager.INSTANCE.unsubScribeChannel("/" + channelId);
                    ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink().equals(jsonObject.optString("invite_link"))) {
                    Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
                    hungupIntent.putExtra("action", "rejectCall");
                    hungupIntent.putExtra("muid", jsonObject.getString("muid"));
                    context.sendBroadcast(hungupIntent);
                    Intent mIntent = new Intent("CALL_HANGUP");
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
                    Intent mIntent2 = new Intent("video_conference_hungup_intent");
                    mIntent2.putExtra("invite_link", jsonObject.getString("invite_link"));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent2);
                } else {
                    Intent mIntent2 = new Intent("video_conference_hungup_intent");
                    mIntent2.putExtra("invite_link", jsonObject.getString("invite_link"));
                    mIntent2.putExtra("jitsi_url", jsonObject.optString("jitsi_url"));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent2);
                    if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                        ConnectionManager.INSTANCE.onClose();
                    }
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink().equals(jsonObject.optString("invite_link"))) {
                    Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
                    hungupIntent.putExtra("action", "rejectCall");
                    hungupIntent.putExtra("muid", jsonObject.getString("muid"));
                    context.sendBroadcast(hungupIntent);
                    Intent mIntent = new Intent("CALL_HANGUP");
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
                    Intent mIntent2 = new Intent("video_conference_hungup_intent");
                    mIntent2.putExtra("invite_link", jsonObject.getString("invite_link"));
                    mIntent2.putExtra("jitsi_url", jsonObject.optString("jitsi_url"));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent2);
                } else if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            }
        }
    }

    public JSONObject getDeviceDetails(Context context) {
        try {
            JSONObject devicePayload = new JSONObject();
            devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId(context));
            devicePayload.put("device_type", 1);
            devicePayload.put("app_version", (Object)"2.6.0");
            devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
            return devicePayload;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    protected void initOldCall(VideoCallModel videoCallModel) {
        try {
            Intent videoIntent = new Intent(this.context.getApplicationContext(), FuguCallActivity.class);
            videoIntent.addFlags(0x10000000);
            videoIntent.addFlags(0x800000);
            if (!this.isMyServiceRunning(this.context, VideoCallService.class)) {
                videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
            }
            this.context.startActivity(videoIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCallForegroundService(Context context, String status2, final VideoCallModel videoCallModel, String messageJson) {
        Intent startIntent = new Intent(context.getApplicationContext(), VideoCallService.class);
        String channelName = "";
        channelName = videoCallModel.getChannelName();
        startIntent.setAction("com.fuguchat.start");
        startIntent.putExtra("call_status", status2);
        startIntent.putExtra("channel_name", channelName);
        startIntent.putExtra("video_Call_model", (Parcelable)videoCallModel);
        startIntent.putExtra("init_full_screen_service", true);
        startIntent.putExtra("messageJson", messageJson);
        new Thread(new Runnable(){

            @Override
            public void run() {
                CommonData.setVideoCallModel(videoCallModel);
            }
        }).start();
        try {
            ContextCompat.startForegroundService((Context)context, (Intent)startIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URL getServerUrl() {
        URL serverURL;
        if (!TextUtils.isEmpty((CharSequence)this.getJitsiURL())) {
            try {
                URL serverURL2 = new URL(this.getJitsiURL());
                return serverURL2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            serverURL = new URL("https://conference.hippochat.io");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("Invalid server URL!");
        }
        return serverURL;
    }

    public void joinSession(Context context, String roomName, String title, int callType, String transactionId) {
        URL serverURL = this.getServerUrl();
        JitsiMeetUserInfo userInfo = new JitsiMeetUserInfo();
        try {
            userInfo.setDisplayName(title);
        }
        catch (Exception e) {
            userInfo.setDisplayName("Fellow User");
        }
        try {
            JitsiMeetConferenceOptions defaultOptions;
            if (callType == 2) {
                defaultOptions = new JitsiMeetConferenceOptions.Builder().setServerURL(serverURL).setWelcomePageEnabled(false).setAudioOnly(true).setFeatureFlag("chat.enabled", false).setFeatureFlag("invite.enabled", false).setUserInfo(userInfo).build();
                JitsiMeet.setDefaultConferenceOptions((JitsiMeetConferenceOptions)defaultOptions);
            } else {
                defaultOptions = new JitsiMeetConferenceOptions.Builder().setServerURL(serverURL).setWelcomePageEnabled(false).setAudioOnly(false).setFeatureFlag("chat.enabled", false).setFeatureFlag("invite.enabled", false).setUserInfo(userInfo).build();
                JitsiMeet.setDefaultConferenceOptions((JitsiMeetConferenceOptions)defaultOptions);
            }
        }
        catch (Exception e) {
            JitsiMeetConferenceOptions defaultOptions = new JitsiMeetConferenceOptions.Builder().setServerURL(serverURL).setWelcomePageEnabled(false).setAudioOnly(false).setFeatureFlag("chat.enabled", false).setFeatureFlag("invite.enabled", false).setUserInfo(userInfo).build();
            JitsiMeet.setDefaultConferenceOptions((JitsiMeetConferenceOptions)defaultOptions);
        }
        JitsiMeetConferenceOptions options = new JitsiMeetConferenceOptions.Builder().setRoom(roomName).build();
        OngoingCallService.NotificationServiceState.INSTANCE.setConferenceConnected(true);
        OngoingCallService.NotificationServiceState.INSTANCE.setTransactionId(transactionId);
        this.startOngoingCallService(context, transactionId);
        JitsiMeetActivity.launch((Context)context, (JitsiMeetConferenceOptions)options, (String)Restring.getString(context, R.string.hippo_calling_connection));
        ShowDialg.INSTANCE.hideDialog();
    }

    private void startOngoingCallService(Context context, String transactionId) {
        GroupCallData groupCallData = com.hippoagent.database.CommonData.getGroupData(transactionId);
        Intent startIntent = new Intent(context, OngoingCallService.class);
        startIntent.setAction("com.hippochat.notification.start");
        startIntent.putExtra("muid", groupCallData.getMuid());
        startIntent.putExtra("channel_id", (Serializable)groupCallData.getChannelId());
        ContextCompat.startForegroundService((Context)context, (Intent)startIntent);
    }

    public void startOngoingService(Context context, final String inviteLink, final String signalUniqueId, final Long channelId, final String jitsiLink) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                Intent startIntent = new Intent(HippoCallConfig.this.getContext(), OngoingCallService.class);
                startIntent.setAction("com.hippochat.notification.start");
                startIntent.putExtra("invite_link", inviteLink);
                startIntent.putExtra("muid", signalUniqueId);
                startIntent.putExtra("channel_id", (Serializable)channelId);
                startIntent.putExtra("jitsi_url", jitsiLink);
                ContextCompat.startForegroundService((Context)HippoCallConfig.this.getContext(), (Intent)startIntent);
            }
        }, 500L);
    }

    public void setAppStatus(boolean b) {
        this.isAppVisible = b;
    }

    public boolean isAppVisible() {
        return this.isAppVisible;
    }
}

