/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.hippocall;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippoagent.HippoConfig;
import com.hippoagent.hippocall.VideoCallModel;
import com.hippoagent.model.FuguDeviceDetails;
import io.paperdb.Paper;
import java.util.HashMap;

public final class CommonData {
    private static String name = "hippo.paperdb";
    static String PAPER_CALL_STATUS = "hippo_call_status";
    static String PAPER_VIDEO_CALL = "hippo_video_call_cred";
    static String PAPER_CALL_TYPE = "hippo_call_type";
    static String PAPER_USER_ID = "hippo_user_id";
    static String PAPER_CHANEL_ID = "hippo_channel_id";
    private static final String VIDEO_CALL_MODEL = "video_call_model_new";
    public static HashMap<String, Long> CHANNEL_IDS = new HashMap();

    public static String getCallStatus() {
        return (String)Paper.book((String)name).read(PAPER_CALL_STATUS);
    }

    public static String getCallType() {
        return (String)Paper.book((String)name).read(PAPER_CALL_TYPE);
    }

    public static JsonObject deviceDetails(Context context) {
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree((Object)new FuguDeviceDetails(CommonData.getAppVersion(context)).getDeviceDetails()).getAsJsonObject();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return deviceDetailsJson;
    }

    public static void setCallStatus(String callStatus) {
        Paper.book((String)name).write(PAPER_CALL_STATUS, (Object)callStatus);
    }

    public static void setCallAnswered(boolean b) {
        Paper.book((String)name).write("hippo_call_answer", (Object)b);
    }

    public static boolean isCallAnswered() {
        return (Boolean)Paper.book((String)name).read("hippo_call_answer", (Object)false);
    }

    public static void setCallType(String callType) {
        Paper.book((String)name).write(PAPER_CALL_TYPE, (Object)callType);
    }

    public static void setUserId(Long userId) {
        Paper.book((String)name).write(PAPER_USER_ID, (Object)userId);
    }

    public static Long getUserId() {
        return Long.parseLong((String)Paper.book((String)name).read(PAPER_USER_ID));
    }

    public static int getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getPackageName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getUniqueIMEIId(Context activity) {
        String android_id;
        block7: {
            android_id = "";
            try {
                block6: {
                    try {
                        android_id = Settings.Secure.getString((ContentResolver)activity.getContentResolver(), (String)"android_id");
                    }
                    catch (Exception e) {
                        if (!HippoConfig.getInstance().getAttributes().isShowLog()) break block6;
                        e.printStackTrace();
                    }
                }
                android_id = TextUtils.isEmpty((CharSequence)android_id) ? Build.SERIAL : android_id;
            }
            catch (Exception e) {
                if (!HippoConfig.getInstance().getAttributes().isShowLog()) break block7;
                e.printStackTrace();
            }
        }
        android_id = TextUtils.isEmpty((CharSequence)android_id) ? "12345" : android_id;
        try {
            android_id = android_id + CommonData.getPackageName(activity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return android_id;
    }

    public static boolean hasExtraView() {
        return (Boolean)Paper.book((String)name).read("hippo_call_extra_view", (Object)false);
    }

    public static void setExtraView(boolean b) {
        Paper.book((String)name).write("hippo_call_extra_view", (Object)b);
    }

    public static void setChannelIds(String transactionId, Long channelId) {
        try {
            CHANNEL_IDS = CommonData.getChannelId();
            if (CHANNEL_IDS.size() > 2500) {
                CHANNEL_IDS.clear();
            }
            CHANNEL_IDS.put(transactionId, channelId);
            Paper.book((String)name).write(PAPER_CHANEL_ID, CHANNEL_IDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HashMap<String, Long> getChannelId() {
        try {
            return (HashMap)Paper.book((String)name).read(PAPER_CHANEL_ID, new HashMap());
        }
        catch (Exception e) {
            return new HashMap<String, Long>();
        }
    }

    public static Long getChannelId(String transactionId) {
        try {
            CHANNEL_IDS = CommonData.getChannelId();
            return CHANNEL_IDS.get(transactionId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setVideoCallModel(VideoCallModel videoCallModel) {
        if (videoCallModel == null) {
            Paper.book((String)name).write(VIDEO_CALL_MODEL, (Object)"");
        } else {
            Paper.book((String)name).write(VIDEO_CALL_MODEL, (Object)videoCallModel);
        }
    }

    public static VideoCallModel getVideoCallModel() {
        return (VideoCallModel)Paper.book((String)name).read(VIDEO_CALL_MODEL);
    }
}

