/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.helper;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.OnGroupSessionListener;
import com.hippoagent.callback.UnreadListener;
import com.hippoagent.confcall.HippoAudioManager;
import com.hippoagent.confcall.HungUpBroadcast;
import com.hippoagent.confcall.OngoingCallService;
import com.hippoagent.confcall.PushReceiver;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.helper.BusEvents;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConnectionUtils;
import com.hippoagent.helper.FayeMessage;
import com.hippoagent.hippocall.AppContants;
import com.hippoagent.hippocall.CommonData;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.hippocall.VideoCallModel;
import com.hippoagent.hippocall.WebRTCCallConstants;
import com.hippoagent.hippocall.model.Message;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.utils.Log;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001f\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0016\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000eH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/hippoagent/helper/ParseMessage;", "", "()V", "GroupCallingFlow", "", "data", "Lorg/json/JSONObject;", "msg", "", "channel", "callingFlow", "checkAnswerFrom", "emitReadyToConnect", "userId", "", "(Lorg/json/JSONObject;Ljava/lang/Integer;)V", "emitUserBusy", "jsonObject", "emitUserChannelBusy", "endSessionConference", "hungupConference", "offerConference", "receivedMessage", "rejectConference", "removeTotalPushUnread", "channelId", "startConference", "updateCount", "hippoagentsdk_release"})
public final class ParseMessage {
    public static final ParseMessage INSTANCE;

    public final void receivedMessage(@Nullable String msg, @Nullable String channel) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        try {
            JSONObject data = new JSONObject(msg);
            switch (data.optInt("message_type")) {
                case 18: {
                    this.callingFlow(data, msg, channel);
                    break;
                }
                case 27: {
                    this.GroupCallingFlow(data, msg, channel);
                    break;
                }
                default: {
                    BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.RECEIVED_MESSAGE.toString(), channel, msg));
                    try {
                        if (data.optInt("notification_type") == 3) {
                            int n = data.optInt("assigned_to");
                            HippoApplication hippoApplication = HippoApplication.getInstance();
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
                            UserData userData = hippoApplication.getUserData();
                            Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
                            Integer n2 = userData.getUserId();
                            if (n2 != null && n == n2) {
                                HippoConfig hippoConfig = HippoConfig.getInstance();
                                Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
                                if (hippoConfig.getAssignmentListener() != null) {
                                    HippoConfig hippoConfig2 = HippoConfig.getInstance();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig2, (String)"HippoConfig.getInstance()");
                                    hippoConfig2.getAssignmentListener().onChatAssign(msg);
                                }
                            } else {
                                this.removeTotalPushUnread(data.optInt("channel_id"));
                            }
                        }
                        if (data.optInt("notification_type") == 1) {
                            int n = data.optInt("last_sent_by_id", -1);
                            HippoApplication hippoApplication = HippoApplication.getInstance();
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
                            UserData userData = hippoApplication.getUserData();
                            Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
                            Integer n3 = userData.getUserId();
                            if (n3 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (n == n3) {
                                this.removeTotalPushUnread(data.optInt("channel_id"));
                                break;
                            }
                            this.updateCount(data.optInt("channel_id"));
                            break;
                        }
                        if (data.optInt("notification_type") == 6) {
                            this.removeTotalPushUnread(data.optInt("channel_id"));
                        }
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        }
        catch (Exception e) {
            BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.RECEIVED_MESSAGE.toString(), channel, msg));
        }
    }

    private final void GroupCallingFlow(JSONObject data, String msg, String channel) {
        String string2 = data.getString(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE());
        if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.JitsiCallType.JOIN_GROUP_CALL.toString())) {
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            UserData userData = hippoApplication.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
            Integer finalUserId1 = userData.getUserId();
            HippoApplication hippoApplication2 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
            String deviceId = CommonData.getUniqueIMEIId(hippoApplication2.getApplicationContext());
            String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
            Integer n = finalUserId1;
            int n2 = data.optInt("user_id", -1);
            if (n != null && n == n2 && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
                Intent mIntent2 = new Intent("video_conference_hungup_intent");
                mIntent2.putExtra("invite_link", data.getString("invite_link"));
                HippoApplication hippoApplication3 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication3), (String)"HippoApplication.getInstance()");
                LocalBroadcastManager.getInstance((Context)hippoApplication3.getApplicationContext()).sendBroadcast(mIntent2);
                HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
                Context context = hippoCallConfig.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
                if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
                    HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
                    HippoAudioManager.getInstance(hippoCallConfig2.getContext()).stop(false);
                    HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
                    Intent startIntent = new Intent(hippoCallConfig3.getContext(), OngoingCallService.class);
                    HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
                    hippoCallConfig4.getContext().stopService(startIntent);
                }
                HippoApplication hippoApplication4 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication4), (String)"HippoApplication.getInstance()");
                Context context2 = hippoApplication4.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"HippoApplication.getInstance().applicationContext");
                if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.END_GROUP_CALL.toString())) {
            this.endSessionConference(data);
        }
    }

    private final void callingFlow(JSONObject data, String msg, String channel) {
        String string2 = data.getString(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE());
        if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.START_CONFERENCE.toString())) {
            this.startConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.OFFER_CONFERENCE.toString())) {
            this.offerConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
            this.rejectConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString())) {
            this.hungupConference(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.ANSWER_CONFERENCE.toString())) {
            String string3;
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            UserData userData = hippoApplication.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
            Integer finalUserId1 = userData.getUserId();
            HippoApplication hippoApplication2 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
            String deviceId = CommonData.getUniqueIMEIId(hippoApplication2.getApplicationContext());
            try {
                String string4 = data.optJSONObject("device_payload").optString("device_id");
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"data.optJSONObject(\"devi\u2026\").optString(\"device_id\")");
                string3 = string4;
            }
            catch (Exception e) {
                string3 = "";
            }
            String remoteDeviceId = string3;
            Integer n = finalUserId1;
            int n2 = data.optInt("user_id", -1);
            if (n != null && n == n2 && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
                Intent mIntent32 = new Intent("video_conference_hungup_intent");
                mIntent32.putExtra("invite_link", data.getString("invite_link"));
                mIntent32.putExtra("jitsi_url", data.optString("jitsi_url"));
                HippoApplication hippoApplication3 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication3), (String)"HippoApplication.getInstance()");
                LocalBroadcastManager.getInstance((Context)hippoApplication3.getApplicationContext()).sendBroadcast(mIntent32);
                HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
                Context context = hippoCallConfig.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
                if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
                    HippoCallConfig hippoCallConfig2 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig2, (String)"HippoCallConfig.getInstance()");
                    Intent startIntent = new Intent(hippoCallConfig2.getContext(), OngoingCallService.class);
                    HippoCallConfig hippoCallConfig3 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig3, (String)"HippoCallConfig.getInstance()");
                    hippoCallConfig3.getContext().stopService(startIntent);
                    HippoCallConfig hippoCallConfig4 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig4, (String)"HippoCallConfig.getInstance()");
                    HippoAudioManager.getInstance(hippoCallConfig4.getContext()).stop(false);
                }
                HippoApplication hippoApplication4 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication4), (String)"HippoApplication.getInstance()");
                Context context2 = hippoApplication4.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"HippoApplication.getInstance().applicationContext");
                if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.CALL_HUNG_UP.toString())) {
            String mIntent32;
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            UserData userData = hippoApplication.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
            Integer finalUserId1 = userData.getUserId();
            HippoApplication hippoApplication5 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication5), (String)"HippoApplication.getInstance()");
            String deviceId = CommonData.getUniqueIMEIId(hippoApplication5.getApplicationContext());
            try {
                String string5 = data.optJSONObject("device_payload").optString("device_id");
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"data.optJSONObject(\"devi\u2026\").optString(\"device_id\")");
                mIntent32 = string5;
            }
            catch (Exception e) {
                mIntent32 = "";
            }
            String remoteDeviceId = mIntent32;
            Integer n = finalUserId1;
            int mIntent32 = data.optInt("user_id", -1);
            if (n != null && n == mIntent32 && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
                Intent mIntent2 = new Intent("video_conference_hungup_intent");
                mIntent2.putExtra("invite_link", data.getString("invite_link"));
                HippoApplication hippoApplication6 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication6), (String)"HippoApplication.getInstance()");
                LocalBroadcastManager.getInstance((Context)hippoApplication6.getApplicationContext()).sendBroadcast(mIntent2);
                HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
                Context context = hippoCallConfig.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
                if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
                    HippoCallConfig hippoCallConfig5 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig5, (String)"HippoCallConfig.getInstance()");
                    Intent startIntent = new Intent(hippoCallConfig5.getContext(), OngoingCallService.class);
                    HippoCallConfig hippoCallConfig6 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig6, (String)"HippoCallConfig.getInstance()");
                    hippoCallConfig6.getContext().stopService(startIntent);
                    HippoCallConfig hippoCallConfig7 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig7, (String)"HippoCallConfig.getInstance()");
                    HippoAudioManager.getInstance(hippoCallConfig7.getContext()).stop(false);
                }
                HippoApplication hippoApplication7 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication7), (String)"HippoApplication.getInstance()");
                Context context3 = hippoApplication7.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"HippoApplication.getInstance().applicationContext");
                if (!ConnectionUtils.INSTANCE.isAppRunning(context3)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE.toString())) {
            BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            if (StringsKt.equals((String)OngoingCallService.CallState.INSTANCE.getMuid(), (String)data.optString("muid"), (boolean)true)) {
                OngoingCallService.CallState.INSTANCE.setReadyToConnect(1);
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.START_CALL.toString())) {
            HippoCallConfig.getInstance().oldSDKCall(msg, channel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.VideoCallType.VIDEO_OFFER.toString())) {
            HippoCallConfig.getInstance().oldSDKCall(msg, channel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE.toString())) {
            HippoConfig.getInstance().setBusyMuid(data.getString("muid"));
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            UserData userData = hippoApplication.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
            Integer finalUserId1 = userData.getUserId();
            HippoApplication hippoApplication8 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication8), (String)"HippoApplication.getInstance()");
            String deviceId = CommonData.getUniqueIMEIId(hippoApplication8.getApplicationContext());
            String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
            Integer n = finalUserId1;
            int mIntent2 = data.optInt("user_id", -1);
            if (n != null && n == mIntent2 && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
                Intent mIntent22 = new Intent("video_conference_hungup_intent");
                mIntent22.putExtra("invite_link", data.getString("invite_link"));
                mIntent22.putExtra("jitsi_url", data.optString("jitsi_url"));
                HippoApplication hippoApplication9 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication9), (String)"HippoApplication.getInstance()");
                LocalBroadcastManager.getInstance((Context)hippoApplication9.getApplicationContext()).sendBroadcast(mIntent22);
                HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
                Context context = hippoCallConfig.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoCallConfig.getInstance().context");
                if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
                    HippoCallConfig hippoCallConfig8 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig8, (String)"HippoCallConfig.getInstance()");
                    Intent startIntent = new Intent(hippoCallConfig8.getContext(), OngoingCallService.class);
                    HippoCallConfig hippoCallConfig9 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig9, (String)"HippoCallConfig.getInstance()");
                    hippoCallConfig9.getContext().stopService(startIntent);
                    HippoCallConfig hippoCallConfig10 = HippoCallConfig.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig10, (String)"HippoCallConfig.getInstance()");
                    HippoAudioManager.getInstance(hippoCallConfig10.getContext()).stop(false);
                }
                HippoApplication hippoApplication10 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication10), (String)"HippoApplication.getInstance()");
                Context context4 = hippoApplication10.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"HippoApplication.getInstance().applicationContext");
                if (!ConnectionUtils.INSTANCE.isAppRunning(context4)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                BusProvider.getInstance().post((Object)new FayeMessage(FuguAppConstant.FayeBusEvent.MESSAGE_RECEIVED.toString(), channel, msg));
            }
            Log.e("msg", "~~&~^*&^~*&^~*&^~*^~*~^*~^*~&^~*^~*&^~*&~^*~&^&*~ => " + msg);
        }
    }

    private final void startConference(JSONObject data) {
        Integer finalUserId1;
        HippoApplication hippoApplication = HippoApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
        UserData userData = hippoApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
        Integer n = finalUserId1 = userData.getUserId();
        int n2 = data.optInt("user_id", -1);
        if (!(n != null && n == n2 || OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected())) {
            boolean flag = true;
            if (StringsKt.equals((String)OngoingCallService.CallState.INSTANCE.getMuid(), (String)data.optString("muid"), (boolean)true) && OngoingCallService.CallState.INSTANCE.getReadyToConnect() == 1) {
                flag = false;
            }
            if (flag) {
                this.emitReadyToConnect(data, finalUserId1);
            }
            return;
        }
        if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            this.emitUserBusy(data, finalUserId1);
            this.emitUserChannelBusy(data, finalUserId1);
        }
    }

    private final void offerConference(JSONObject data) {
        Integer finalUserId1;
        HippoApplication hippoApplication = HippoApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
        UserData userData = hippoApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
        Integer n = finalUserId1 = userData.getUserId();
        int n2 = data.optInt("user_id", -1);
        if (!(n != null && n == n2 || OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected())) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            HippoApplication hippoApplication2 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
            UserData userData2 = hippoApplication2.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData2, (String)"HippoApplication.getInstance().userData");
            String myName = userData2.getFullName();
            HippoApplication hippoApplication3 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication3), (String)"HippoApplication.getInstance()");
            UserData userData3 = hippoApplication3.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData3, (String)"HippoApplication.getInstance().userData");
            String myImage = userData3.getUserImage();
            HippoApplication hippoApplication4 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication4), (String)"HippoApplication.getInstance()");
            UserData userData4 = hippoApplication4.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData4, (String)"HippoApplication.getInstance().userData");
            Integer userId = userData4.getUserId();
            String fullname = data.optString("full_name");
            long channelId = data.optLong("channel_id");
            String messageUniqueId = data.optString("muid");
            String videoCallType = data.optString("video_call_type", "");
            String callType = data.optString("call_type", "");
            String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
            String userImage = data.optString("user_thumbnail_image");
            String jitsiUrl = data.optString("jitsi_url");
            String string2 = data.optString("user_thumbnail_image");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"user_thumbnail_image\")");
            String string3 = data.optString("full_name");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"full_name\")");
            Integer n3 = userId;
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"userId");
            int n4 = n3;
            String string4 = fullname;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"fullname");
            String string5 = turnCredentials.getTurnApiKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"turnCredentials.getTurnApiKey()");
            String string6 = turnCredentials.getUsername();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"turnCredentials.getUsername()");
            String string7 = turnCredentials.getCredentials();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"turnCredentials.getCredentials()");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string8 = callType;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"callType");
            String string9 = string8;
            String string10 = messageUniqueId;
            String string11 = activityLaunchState;
            ArrayList<String> arrayList3 = arrayList2;
            ArrayList<String> arrayList4 = arrayList;
            String string12 = string7;
            String string13 = string6;
            String string14 = string5;
            String string15 = string4;
            long l = -1L;
            int n5 = n4;
            String string16 = string3;
            String string17 = string2;
            long l2 = channelId;
            boolean bl = false;
            String string18 = string9;
            if (string18 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string19 = string18.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"(this as java.lang.String).toUpperCase()");
            String string20 = string19;
            String string21 = jitsiUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)string21, (String)"jitsiUrl");
            String string22 = myImage;
            String string23 = myName;
            String string24 = "";
            String string25 = string21;
            String string26 = "";
            String string27 = string20;
            String string28 = string10;
            String string29 = string11;
            ArrayList<String> arrayList5 = arrayList3;
            ArrayList<String> arrayList6 = arrayList4;
            String string30 = string12;
            String string31 = string13;
            String string32 = string14;
            String string33 = string15;
            long l3 = l;
            int n6 = n5;
            String string34 = string16;
            String string35 = string17;
            long l4 = l2;
            VideoCallModel videoCallModel = new VideoCallModel(l4, string35, string34, n6, l3, string33, string32, string31, string30, arrayList6, arrayList5, string29, string28, string27, string26, string25, string24, string23, string22);
            HippoConfig hippoConfig = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
            if (StringsKt.equals((String)hippoConfig.getBusyMuid(), (String)data.getString(WebRTCCallConstants.Companion.getMESSAGE_UNIQUE_ID()), (boolean)true)) {
                return;
            }
            if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid(), (Object)data.getString(WebRTCCallConstants.Companion.getMESSAGE_UNIQUE_ID()))) {
                return;
            }
            String string36 = data.getString(WebRTCCallConstants.Companion.getMESSAGE_UNIQUE_ID());
            Intrinsics.checkExpressionValueIsNotNull((Object)string36, (String)"data.getString(MESSAGE_UNIQUE_ID)");
            OngoingCallService.NotificationServiceState.INSTANCE.setMuid(string36);
            String string37 = data.getString("invite_link");
            Intrinsics.checkExpressionValueIsNotNull((Object)string37, (String)"data.getString(\"invite_link\")");
            OngoingCallService.NotificationServiceState.INSTANCE.setInviteLink(string37);
            PushReceiver fuguNotificationConfig = new PushReceiver().getInstance();
            HippoApplication hippoApplication5 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication5), (String)"HippoApplication.getInstance()");
            Context context = hippoApplication5.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoApplication.getInstance().applicationContext");
            fuguNotificationConfig.incomingCallNotification(context, data, videoCallModel);
        }
    }

    private final void rejectConference(JSONObject data) {
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
        HippoApplication hippoApplication = HippoApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
        Context context = hippoApplication.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoApplication.getInstance().applicationContext");
        if (ConnectionUtils.INSTANCE.isMyServiceRunning(context, OngoingCallService.class)) {
            HippoApplication hippoApplication2 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
            Intent startIntent = new Intent(hippoApplication2.getApplicationContext(), OngoingCallService.class);
            HippoApplication hippoApplication3 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication3), (String)"HippoApplication.getInstance()");
            hippoApplication3.getApplicationContext().stopService(startIntent);
        } else if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            BusProvider.getInstance().post((Object)new FayeMessage(WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString(), "", ""));
            HippoApplication hippoApplication4 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication4), (String)"HippoApplication.getInstance()");
            Context context2 = hippoApplication4.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"HippoApplication.getInstance().applicationContext");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context2)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void endSessionConference(JSONObject data) {
        if (OngoingCallService.NotificationServiceState.INSTANCE.getTransactionId().equals(data.optString("transaction_id"))) {
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            Intent hungupIntent = new Intent(hippoApplication.getApplicationContext(), HungUpBroadcast.class);
            hungupIntent.putExtra("action", "endSession");
            HippoApplication hippoApplication2 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
            hippoApplication2.getApplicationContext().sendBroadcast(hungupIntent);
            Intent mIntent = new Intent("CALL_HANGUP");
            HippoApplication hippoApplication3 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication3), (String)"HippoApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoApplication3.getApplicationContext()).sendBroadcast(mIntent);
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoApplication hippoApplication4 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication4), (String)"HippoApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoApplication4.getApplicationContext()).sendBroadcast(mIntent2);
        }
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
        HippoConfig hippoConfig = HippoConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
        if (hippoConfig.getGroupSessionListener() != null) {
            HippoConfig hippoConfig2 = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig2, (String)"HippoConfig.getInstance()");
            OnGroupSessionListener onGroupSessionListener = hippoConfig2.getGroupSessionListener();
            String string2 = data.optString("transaction_id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"transaction_id\")");
            onGroupSessionListener.onSessionEnded(string2);
        }
    }

    private final void hungupConference(JSONObject data) {
        HippoCallConfig hippoCallConfig = HippoCallConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)hippoCallConfig, (String)"HippoCallConfig.getInstance()");
        HippoAudioManager.getInstance(hippoCallConfig.getContext()).stop(false);
        if (Intrinsics.areEqual((Object)OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink(), (Object)data.optString("invite_link"))) {
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            Intent hungupIntent = new Intent(hippoApplication.getApplicationContext(), HungUpBroadcast.class);
            hungupIntent.putExtra("action", "rejectCall");
            hungupIntent.putExtra("muid", data.getString("muid"));
            HippoApplication hippoApplication2 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
            hippoApplication2.getApplicationContext().sendBroadcast(hungupIntent);
            Intent mIntent = new Intent("CALL_HANGUP");
            HippoApplication hippoApplication3 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication3), (String)"HippoApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoApplication3.getApplicationContext()).sendBroadcast(mIntent);
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoApplication hippoApplication4 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication4), (String)"HippoApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoApplication4.getApplicationContext()).sendBroadcast(mIntent2);
        } else {
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoApplication.getApplicationContext()).sendBroadcast(mIntent2);
            HippoApplication hippoApplication5 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication5), (String)"HippoApplication.getInstance()");
            Context context = hippoApplication5.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoApplication.getInstance().applicationContext");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void checkAnswerFrom(JSONObject data) {
        HippoApplication hippoApplication = HippoApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
        UserData userData = hippoApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
        Integer finalUserId1 = userData.getUserId();
        HippoApplication hippoApplication2 = HippoApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
        String deviceId = CommonData.getUniqueIMEIId(hippoApplication2.getApplicationContext());
        String remoteDeviceId = data.getJSONObject("device_payload").optString("device_id");
        Integer n = finalUserId1;
        int n2 = data.optInt("user_id", -1);
        if (n != null && n == n2 && Intrinsics.areEqual((Object)deviceId, (Object)remoteDeviceId) ^ true) {
            Intent mIntent2 = new Intent("video_conference_hungup_intent");
            mIntent2.putExtra("invite_link", data.getString("invite_link"));
            HippoApplication hippoApplication3 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication3), (String)"HippoApplication.getInstance()");
            LocalBroadcastManager.getInstance((Context)hippoApplication3.getApplicationContext()).sendBroadcast(mIntent2);
            HippoApplication hippoApplication4 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication4), (String)"HippoApplication.getInstance()");
            Context context = hippoApplication4.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoApplication.getInstance().applicationContext");
            if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                ConnectionManager.INSTANCE.onClose();
            }
        }
    }

    private final void emitReadyToConnect(JSONObject data, Integer userId) {
        try {
            String string2 = data.getString("muid");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.getString(FuguAppConstant.MESSAGE_UNIQUE_ID)");
            OngoingCallService.CallState.INSTANCE.setMuid(string2);
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", true);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.READY_TO_CONNECT_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)data.getString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            try {
                String string3 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
                HippoApplication hippoApplication = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
                startCallJson.put(string3, (Object)com.hippoagent.database.CommonData.deviceDetails(hippoApplication.getApplicationContext()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            startCallJson.put("invite_link", (Object)data.getString("invite_link"));
            startCallJson.put("jitsi_url", (Object)data.optString("jitsi_url"));
            startCallJson.put("muid", (Object)data.getString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)data.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            String channelId = "/" + data.optLong("channel_id");
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
            Log.e("Video_CONF-->", startCallJson.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void emitUserBusy(JSONObject jsonObject, Integer userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)jsonObject.optString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            String string2 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            startCallJson.put(string2, (Object)CommonData.deviceDetails(hippoApplication.getApplicationContext()));
            startCallJson.put("invite_link", (Object)jsonObject.optString("invite_link"));
            startCallJson.put("jitsi_url", (Object)jsonObject.optString("jitsi_url"));
            startCallJson.put("muid", (Object)jsonObject.optString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)jsonObject.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            String channelId = "/" + jsonObject.optLong("channel_id");
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void emitUserChannelBusy(JSONObject jsonObject, Integer userId) {
        try {
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("server_push", true);
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)jsonObject.optString("channel_id"));
            startCallJson.put("message_type", 18);
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            String string2 = WebRTCCallConstants.Companion.getDEVICE_PAYLOAD();
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            startCallJson.put(string2, (Object)CommonData.deviceDetails(hippoApplication.getApplicationContext()));
            startCallJson.put("invite_link", (Object)jsonObject.optString("invite_link"));
            startCallJson.put("jitsi_url", (Object)jsonObject.optString("jitsi_url"));
            startCallJson.put("muid", (Object)jsonObject.optString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)jsonObject.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            StringBuilder stringBuilder = new StringBuilder().append("/");
            HippoApplication hippoApplication2 = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
            UserData userData = hippoApplication2.getUserData();
            Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
            String channelId = stringBuilder.append(userData.getUserChannel().toString()).toString();
            ConnectionManager.INSTANCE.publish(channelId, startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void updateCount(int channelId) {
        try {
            HippoConfig hippoConfig = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
            if (hippoConfig.getInternalListener() != null) {
                HippoConfig hippoConfig2 = HippoConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig2, (String)"HippoConfig.getInstance()");
                hippoConfig2.getInternalListener().addTotalPushUnread(channelId);
            } else {
                for (UnreadListener listener : HippoApplication.getInstance().getUIListeners(UnreadListener.class)) {
                    if (listener == null) continue;
                    listener.addTotalPushUnread(channelId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void removeTotalPushUnread(int channelId) {
        try {
            HippoConfig hippoConfig = HippoConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
            if (hippoConfig.getInternalListener() != null) {
                HippoConfig hippoConfig2 = HippoConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig2, (String)"HippoConfig.getInstance()");
                hippoConfig2.getInternalListener().removeTotalPushUnread(channelId);
            } else {
                for (UnreadListener listener : HippoApplication.getInstance().getUIListeners(UnreadListener.class)) {
                    if (listener == null) continue;
                    listener.removeTotalPushUnread(channelId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ParseMessage() {
    }

    static {
        ParseMessage parseMessage;
        INSTANCE = parseMessage = new ParseMessage();
    }
}

