/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.helper;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.hippoagent.Config;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.callback.CountDownTimerListener;
import com.hippoagent.callback.OnCloseListener;
import com.hippoagent.callback.OnInitializedListener;
import com.hippoagent.confcall.OngoingCallService;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.helper.BusEvents;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConnectionUtils;
import com.hippoagent.helper.FayeMessage;
import com.hippoagent.helper.ParseMessage;
import com.hippoagent.model.LoginResponse.UserData;
import faye.FuguAgentFayeClient;
import faye.FuguAgentFayeClientListener;
import faye.FuguAgentMetaMessage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0005J\n\u0010)\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010*\u001a\u00020\u0018H\u0002J\u0006\u0010+\u001a\u00020&J\u0006\u0010,\u001a\u00020\rJ\b\u0010-\u001a\u00020&H\u0016J\b\u0010.\u001a\u00020&H\u0016J\b\u0010\u001c\u001a\u00020&H\u0002J\u0016\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u000202J\u001e\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\rJ\b\u00104\u001a\u00020&H\u0002J\b\u00105\u001a\u00020&H\u0002J\u0010\u00106\u001a\u00020&2\b\u00107\u001a\u0004\u0018\u00010 J\b\u00108\u001a\u00020&H\u0002J\b\u00109\u001a\u00020&H\u0002J\b\u0010:\u001a\u00020&H\u0002J\u000e\u0010;\u001a\u00020&2\u0006\u00100\u001a\u00020\u0018J\b\u0010<\u001a\u00020&H\u0002J\u000e\u0010=\u001a\u00020&2\u0006\u00100\u001a\u00020\u0018J\b\u0010>\u001a\u00020&H\u0002J\u000e\u0010?\u001a\u00020&2\u0006\u00100\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006@"}, d2={"Lcom/hippoagent/helper/ConnectionManager;", "Lcom/hippoagent/callback/OnCloseListener;", "Lcom/hippoagent/callback/OnInitializedListener;", "()V", "CONNECTED_TO_INTERNET", "", "CONNECTED_TO_INTERNET_VIA_WIFI", "MAX_COUNT", "MAX_RETRY_ATTEMPTS", "NETWORK_STATUS", "NOT_CONNECTED", "RECONNECTION_TIME", "connecting", "", "fayeClient", "Lfaye/FuguAgentFayeClient;", "forceStop", "getForceStop", "()Z", "setForceStop", "(Z)V", "isDelaySubscribe", "mChannels", "Ljava/util/HashSet;", "", "mPendingChannels", "meta", "Lfaye/FuguAgentMetaMessage;", "pongCount", "retryCount", "stopConnection", "timerListener", "Lcom/hippoagent/callback/CountDownTimerListener;", "getTimerListener$hippoagentsdk_release", "()Lcom/hippoagent/callback/CountDownTimerListener;", "setTimerListener$hippoagentsdk_release", "(Lcom/hippoagent/callback/CountDownTimerListener;)V", "attemptAutoConnection", "", "changeStatus", "status", "getFayeClient", "getFayeUrl", "initFayeConnection", "isConnected", "onClose", "onInitialized", "publish", "channel", "jsonObject", "Lorg/json/JSONObject;", "canStoreLocally", "reconnectConnection", "saveSubsribedChannels", "setCountDownTimerListener", "listener", "setListener", "stopAutoAttemptConnection", "stopFayeClient", "subScribeChannel", "subscribeDelayPendingChannels", "subscribeOnDelay", "subscribePendingChannels", "unsubScribeChannel", "hippoagentsdk_release"})
public final class ConnectionManager
implements OnCloseListener,
OnInitializedListener {
    private static FuguAgentFayeClient fayeClient;
    private static FuguAgentMetaMessage meta;
    private static final HashSet<String> mChannels;
    private static final HashSet<String> mPendingChannels;
    private static boolean connecting;
    private static boolean isDelaySubscribe;
    private static final int RECONNECTION_TIME = 5000;
    private static int retryCount;
    private static boolean stopConnection;
    private static final int NOT_CONNECTED = 0;
    private static final int CONNECTED_TO_INTERNET = 1;
    private static final int CONNECTED_TO_INTERNET_VIA_WIFI = 2;
    private static int NETWORK_STATUS;
    private static int pongCount;
    private static final int MAX_COUNT = 20;
    private static final int MAX_RETRY_ATTEMPTS = 50;
    @Nullable
    private static CountDownTimerListener timerListener;
    private static boolean forceStop;
    public static final ConnectionManager INSTANCE;

    @Override
    public void onClose() {
        this.stopFayeClient();
    }

    @Override
    public void onInitialized() {
        this.initFayeConnection();
    }

    public final void initFayeConnection() {
        fayeClient = this.getFayeClient();
        forceStop = false;
        if (fayeClient != null && !this.isConnected() && !connecting) {
            FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
            if (fuguAgentFayeClient == null) {
                Intrinsics.throwNpe();
            }
            fuguAgentFayeClient.connectServer();
            connecting = true;
        }
        this.setListener();
    }

    private final FuguAgentFayeClient getFayeClient() {
        if (fayeClient == null) {
            JSONObject jsonExt = new JSONObject();
            try {
                HippoApplication hippoApplication = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
                if (hippoApplication.getUserData() == null) {
                    connecting = false;
                    return null;
                }
                HippoApplication hippoApplication2 = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication2), (String)"HippoApplication.getInstance()");
                UserData userData = hippoApplication2.getUserData();
                Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
                Integer n = userData.getUserId();
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"HippoApplication.getInstance().userData.userId");
                jsonExt.put("user_id", n.intValue());
                jsonExt.put("device_type", 1);
                jsonExt.put("source", 1);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            meta.setAllExt(jsonExt.toString());
            fayeClient = new FuguAgentFayeClient(this.getFayeUrl(), meta);
        }
        return fayeClient;
    }

    private final void reconnectConnection() {
        this.initFayeConnection();
    }

    private final String getFayeUrl() {
        return Config.getFayeServerUrl() + "faye";
    }

    private final void setListener() {
        if (fayeClient != null) {
            FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
            if (fuguAgentFayeClient == null) {
                Intrinsics.throwNpe();
            }
            fuguAgentFayeClient.setmManagerListener(new FuguAgentFayeClientListener(){

                public void onConnectedServer(@Nullable FuguAgentFayeClient fc) {
                    ConnectionManager.access$setStopConnection$p(ConnectionManager.INSTANCE, true);
                    ConnectionManager.access$setConnecting$p(ConnectionManager.INSTANCE, true);
                    ConnectionManager.access$setRetryCount$p(ConnectionManager.INSTANCE, 0);
                    if (!ConnectionManager.access$isDelaySubscribe$p(ConnectionManager.INSTANCE)) {
                        ConnectionManager.access$subscribePendingChannels(ConnectionManager.INSTANCE);
                    } else {
                        ConnectionManager.access$subscribeDelayPendingChannels(ConnectionManager.INSTANCE);
                    }
                    BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.CONNECTED_SERVER.toString(), "", ""));
                    ConnectionManager.access$stopAutoAttemptConnection(ConnectionManager.INSTANCE);
                }

                public void onDisconnectedServer(@Nullable FuguAgentFayeClient fc) {
                    ConnectionManager.access$setConnecting$p(ConnectionManager.INSTANCE, false);
                    ConnectionManager.access$setStopConnection$p(ConnectionManager.INSTANCE, false);
                    if (!ConnectionManager.INSTANCE.getForceStop()) {
                        ConnectionManager.access$saveSubsribedChannels(ConnectionManager.INSTANCE);
                        BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.DISCONNECTED_SERVER.toString(), "", ""));
                        ConnectionManager.access$attemptAutoConnection(ConnectionManager.INSTANCE);
                    }
                }

                public void onReceivedMessage(@Nullable FuguAgentFayeClient fc, @Nullable String msg, @Nullable String channel) {
                    ConnectionManager.access$setStopConnection$p(ConnectionManager.INSTANCE, true);
                    ConnectionManager.access$setConnecting$p(ConnectionManager.INSTANCE, true);
                    ConnectionManager.access$setRetryCount$p(ConnectionManager.INSTANCE, 0);
                    ParseMessage.INSTANCE.receivedMessage(msg, channel);
                }

                public void onPongReceived() {
                    ConnectionManager.access$setStopConnection$p(ConnectionManager.INSTANCE, true);
                    ConnectionManager.access$setConnecting$p(ConnectionManager.INSTANCE, true);
                    ConnectionManager.access$setRetryCount$p(ConnectionManager.INSTANCE, 0);
                    ConnectionManager.access$subscribePendingChannels(ConnectionManager.INSTANCE);
                    BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.PONG_RECEIVED.toString(), "", ""));
                    ConnectionManager.access$pongCount(ConnectionManager.INSTANCE);
                }

                public void onWebSocketError() {
                    ConnectionManager.access$setConnecting$p(ConnectionManager.INSTANCE, false);
                    ConnectionManager.access$setPongCount$p(ConnectionManager.INSTANCE, 0);
                    BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.WEBSOCKET_ERROR.toString(), "", ""));
                }

                public void onErrorReceived(@Nullable FuguAgentFayeClient fc, @Nullable String msg, @Nullable String channel) {
                    ConnectionManager.access$setConnecting$p(ConnectionManager.INSTANCE, true);
                    BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.ERROR_RECEIVED.toString(), channel, msg));
                    if (ConnectionManager.INSTANCE.getTimerListener$hippoagentsdk_release() != null) {
                        CountDownTimerListener countDownTimerListener = ConnectionManager.INSTANCE.getTimerListener$hippoagentsdk_release();
                        if (countDownTimerListener == null) {
                            Intrinsics.throwNpe();
                        }
                        countDownTimerListener.onErrorReceived(channel, msg);
                    }
                }

                public void onNotConnected() {
                    ConnectionManager.access$setConnecting$p(ConnectionManager.INSTANCE, false);
                    ConnectionManager.access$setPongCount$p(ConnectionManager.INSTANCE, 0);
                    BusProvider.getInstance().post((Object)new FayeMessage(BusEvents.NOT_CONNECTED.toString(), "", ""));
                }
            });
        }
    }

    @Nullable
    public final CountDownTimerListener getTimerListener$hippoagentsdk_release() {
        return timerListener;
    }

    public final void setTimerListener$hippoagentsdk_release(@Nullable CountDownTimerListener countDownTimerListener) {
        timerListener = countDownTimerListener;
    }

    public final void setCountDownTimerListener(@Nullable CountDownTimerListener listener) {
        timerListener = listener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConnected() {
        if (fayeClient == null) return false;
        FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
        if (fuguAgentFayeClient == null) {
            Intrinsics.throwNpe();
        }
        if (!fuguAgentFayeClient.isConnectedServer()) return false;
        FuguAgentFayeClient fuguAgentFayeClient2 = fayeClient;
        if (fuguAgentFayeClient2 == null) {
            Intrinsics.throwNpe();
        }
        if (!fuguAgentFayeClient2.isOpened()) return false;
        return true;
    }

    public final void subScribeChannel(@NotNull String channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        if (this.isConnected()) {
            if (!mChannels.contains(channel)) {
                mChannels.add(channel);
                FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
                if (fuguAgentFayeClient == null) {
                    Intrinsics.throwNpe();
                }
                fuguAgentFayeClient.subscribeChannel(channel);
            }
        } else {
            mPendingChannels.add(channel);
            this.reconnectConnection();
        }
    }

    public final void subscribeOnDelay(@NotNull String channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        if (this.isConnected()) {
            if (!mChannels.contains(channel)) {
                mChannels.add(channel);
                FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
                if (fuguAgentFayeClient == null) {
                    Intrinsics.throwNpe();
                }
                fuguAgentFayeClient.subscribeChannel(channel);
            } else {
                mChannels.add(channel);
                FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
                if (fuguAgentFayeClient == null) {
                    Intrinsics.throwNpe();
                }
                fuguAgentFayeClient.subscribeChannel(channel);
            }
        } else {
            isDelaySubscribe = true;
            mPendingChannels.add(channel);
            this.reconnectConnection();
        }
    }

    public final void unsubScribeChannel(@NotNull String channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        mChannels.remove(channel);
        if (fayeClient != null) {
            FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
            if (fuguAgentFayeClient == null) {
                Intrinsics.throwNpe();
            }
            fuguAgentFayeClient.unsubscribeChannel(channel);
        }
    }

    public final void publish(@NotNull String channel, @NotNull JSONObject jsonObject) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        this.publish(channel, jsonObject, false);
    }

    public final void publish(@NotNull String channel, @NotNull JSONObject jsonObject, boolean canStoreLocally) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        if (this.isConnected()) {
            try {
                HippoConfig hippoConfig = HippoConfig.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfig, (String)"HippoConfig.getInstance()");
                String string2 = hippoConfig.getCurrentLanguage();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    jsonObject.put("lang", (Object)string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
            if (fuguAgentFayeClient == null) {
                Intrinsics.throwNpe();
            }
            fuguAgentFayeClient.publish(channel, jsonObject);
        } else {
            mPendingChannels.add(channel);
            this.reconnectConnection();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void pongCount() {
        if (++pongCount <= 20) return;
        if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) return;
        if (HippoApplication.getInstance() != null) {
            HippoApplication hippoApplication = HippoApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
            Context context = hippoApplication.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"HippoApplication.getInstance().applicationContext");
            if (ConnectionUtils.INSTANCE.isAppRunning(context)) {
                pongCount = 0;
                return;
            }
        }
        this.stopFayeClient();
    }

    public final boolean getForceStop() {
        return forceStop;
    }

    public final void setForceStop(boolean bl) {
        forceStop = bl;
    }

    private final void stopFayeClient() {
        if (fayeClient != null && !OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
            HandlerThread thread = new HandlerThread("TerminateThread");
            thread.start();
            new Handler(thread.getLooper()).post((Runnable)stopFayeClient.1.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void subscribePendingChannels() {
        ConnectionManager connectionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (connectionManager) {
            boolean bl3 = false;
            if (mPendingChannels.size() > 0) {
                HashSet<String> tempChannel = mPendingChannels;
                for (String channel : tempChannel) {
                    FuguAgentFayeClient fuguAgentFayeClient = fayeClient;
                    if (fuguAgentFayeClient == null) {
                        Intrinsics.throwNpe();
                    }
                    fuguAgentFayeClient.subscribeChannel(channel);
                }
                mPendingChannels.removeAll((Collection)tempChannel);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void subscribeDelayPendingChannels() {
        new Handler().postDelayed((Runnable)subscribeDelayPendingChannels.1.INSTANCE, 2000L);
    }

    public final void changeStatus(int status2) {
        NETWORK_STATUS = status2;
        int n = status2;
        if (n == NOT_CONNECTED) {
            this.saveSubsribedChannels();
            this.stopAutoAttemptConnection();
            retryCount = 0;
        } else if (n == CONNECTED_TO_INTERNET || n == CONNECTED_TO_INTERNET_VIA_WIFI) {
            this.initFayeConnection();
        }
    }

    private final synchronized void saveSubsribedChannels() {
        connecting = false;
        if (mChannels.size() > 0) {
            mPendingChannels.addAll((Collection<String>)mChannels);
            mChannels.clear();
        }
    }

    private final void attemptAutoConnection() {
        if (NETWORK_STATUS != NOT_CONNECTED && retryCount < 50 && !stopConnection) {
            ++retryCount;
            try {
                new Timer().schedule(new TimerTask(){

                    public void run() {
                        try {
                            if (!ConnectionManager.access$getStopConnection$p(ConnectionManager.INSTANCE)) {
                                ConnectionManager.INSTANCE.initFayeConnection();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, RECONNECTION_TIME);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void stopAutoAttemptConnection() {
    }

    private ConnectionManager() {
    }

    static {
        ConnectionManager connectionManager;
        INSTANCE = connectionManager = new ConnectionManager();
        meta = new FuguAgentMetaMessage();
        mChannels = new HashSet();
        mPendingChannels = new HashSet();
        RECONNECTION_TIME = 5000;
        CONNECTED_TO_INTERNET = 1;
        CONNECTED_TO_INTERNET_VIA_WIFI = 2;
        NETWORK_STATUS = 1;
    }

    public static final /* synthetic */ boolean access$getStopConnection$p(ConnectionManager $this) {
        ConnectionManager connectionManager = $this;
        return stopConnection;
    }

    public static final /* synthetic */ void access$setStopConnection$p(ConnectionManager $this, boolean bl) {
        ConnectionManager connectionManager = $this;
        stopConnection = bl;
    }

    public static final /* synthetic */ boolean access$getConnecting$p(ConnectionManager $this) {
        ConnectionManager connectionManager = $this;
        return connecting;
    }

    public static final /* synthetic */ void access$setConnecting$p(ConnectionManager $this, boolean bl) {
        ConnectionManager connectionManager = $this;
        connecting = bl;
    }

    public static final /* synthetic */ int access$getRetryCount$p(ConnectionManager $this) {
        ConnectionManager connectionManager = $this;
        return retryCount;
    }

    public static final /* synthetic */ void access$setRetryCount$p(ConnectionManager $this, int n) {
        ConnectionManager connectionManager = $this;
        retryCount = n;
    }

    public static final /* synthetic */ boolean access$isDelaySubscribe$p(ConnectionManager $this) {
        ConnectionManager connectionManager = $this;
        return isDelaySubscribe;
    }

    public static final /* synthetic */ void access$setDelaySubscribe$p(ConnectionManager $this, boolean bl) {
        ConnectionManager connectionManager = $this;
        isDelaySubscribe = bl;
    }

    public static final /* synthetic */ void access$subscribePendingChannels(ConnectionManager $this) {
        $this.subscribePendingChannels();
    }

    public static final /* synthetic */ void access$subscribeDelayPendingChannels(ConnectionManager $this) {
        $this.subscribeDelayPendingChannels();
    }

    public static final /* synthetic */ void access$stopAutoAttemptConnection(ConnectionManager $this) {
        $this.stopAutoAttemptConnection();
    }

    public static final /* synthetic */ void access$saveSubsribedChannels(ConnectionManager $this) {
        $this.saveSubsribedChannels();
    }

    public static final /* synthetic */ void access$attemptAutoConnection(ConnectionManager $this) {
        $this.attemptAutoConnection();
    }

    public static final /* synthetic */ void access$pongCount(ConnectionManager $this) {
        $this.pongCount();
    }

    public static final /* synthetic */ int access$getPongCount$p(ConnectionManager $this) {
        ConnectionManager connectionManager = $this;
        return pongCount;
    }

    public static final /* synthetic */ void access$setPongCount$p(ConnectionManager $this, int n) {
        ConnectionManager connectionManager = $this;
        pongCount = n;
    }

    public static final /* synthetic */ FuguAgentFayeClient access$getFayeClient$p(ConnectionManager $this) {
        ConnectionManager connectionManager = $this;
        return fayeClient;
    }

    public static final /* synthetic */ void access$setFayeClient$p(ConnectionManager $this, FuguAgentFayeClient fuguAgentFayeClient) {
        ConnectionManager connectionManager = $this;
        fayeClient = fuguAgentFayeClient;
    }

    public static final /* synthetic */ HashSet access$getMPendingChannels$p(ConnectionManager $this) {
        ConnectionManager connectionManager = $this;
        return mPendingChannels;
    }

    public static final /* synthetic */ HashSet access$getMChannels$p(ConnectionManager $this) {
        ConnectionManager connectionManager = $this;
        return mChannels;
    }
}

