/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.app.ActivityOptionsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.easyfilepicker.R;
import com.easyfilepicker.easypermissions.AppSettingsDialog;
import com.easyfilepicker.easypermissions.EasyPermissions;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.ImageDisplayActivity;
import com.hippoagent.dialogs.CustomAlertDialog;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.ProfileData;
import com.hippoagent.helper.ConversationApiHelper;
import com.hippoagent.model.EditProfileResponse;
import com.hippoagent.model.Image;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.ImageChooser;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.PhoneFunctions;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.filelogger.Logger;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import com.squareup.otto.Subscribe;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import retrofit2.Callback;

public class EditProfileFragmentNew
extends Fragment
implements ImageChooser.OnImageSelectListener,
EasyPermissions.PermissionCallbacks {
    private boolean isEditable = false;
    private EditText tvEmail;
    private EditText tvName;
    private EditText tvPhone;
    private TextView tvSave;
    private LinearLayout ivImageEdit;
    private AppCompatImageView ivProfile;
    private AppCompatImageView ivBack;
    private AppCompatImageView ivEdit;
    private View ivImage;
    private ImageChooser imageChooser;
    private File profileImgFile;
    private String imageFile;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.profileImgFile = null;
        if (this.getArguments() != null) {
            this.isEditable = this.getArguments().getBoolean("isEditable");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.activity_profile_new, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.tvName = (EditText)view.findViewById(R.id.tvName);
        this.tvEmail = (EditText)view.findViewById(R.id.tvEmail);
        this.tvPhone = (EditText)view.findViewById(R.id.tvPhone);
        this.ivImageEdit = (LinearLayout)view.findViewById(R.id.ivImageEdit);
        this.tvSave = (TextView)view.findViewById(R.id.tvSave);
        this.ivProfile = (AppCompatImageView)view.findViewById(R.id.ivProfile);
        this.ivBack = (AppCompatImageView)view.findViewById(R.id.ivBack);
        this.ivEdit = (AppCompatImageView)view.findViewById(R.id.ivEdit);
        this.ivImage = view.findViewById(R.id.ivImage);
        this.tvName.setText((CharSequence)HippoApplication.getInstance().getUserData().getFullName());
        this.loadImage(HippoApplication.getInstance().getUserData().getUserImage());
        this.tvEmail.setText((CharSequence)HippoApplication.getInstance().getUserData().getEmail());
        PhoneFunctions phoneFunctions = new PhoneFunctions();
        String phoneNumber = HippoApplication.getInstance().getUserData().getPhoneNumber();
        String phone = "";
        if (!TextUtils.isEmpty((CharSequence)phoneNumber) && phoneNumber.substring(0, 1).equals("+")) {
            phone = phoneNumber.substring(1, phoneNumber.length());
        }
        String countryCode = phoneFunctions.getCountry(this.getResources().getStringArray(R.array.CountryCodes), phone);
        if (!TextUtils.isEmpty((CharSequence)phoneNumber)) {
            this.tvPhone.setText((CharSequence)phoneNumber.substring(countryCode.length() + 1));
        }
        this.imageChooser = new ImageChooser(this);
        if (this.isEditable) {
            this.isEditable = true;
            this.enableTextView(this.tvName);
            this.enableTextView(this.tvPhone);
            this.tvSave.setVisibility(0);
            this.tvName.setSelection(this.tvName.getText().length());
            this.ivImageEdit.setVisibility(0);
            this.ivEdit.setVisibility(8);
        } else {
            this.nonEditable();
        }
        this.ivEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditProfileFragmentNew.this.isEditable = true;
                EditProfileFragmentNew.this.enableTextView(EditProfileFragmentNew.this.tvName);
                EditProfileFragmentNew.this.enableTextView(EditProfileFragmentNew.this.tvPhone);
                EditProfileFragmentNew.this.tvSave.setVisibility(0);
                EditProfileFragmentNew.this.tvName.setSelection(EditProfileFragmentNew.this.tvName.getText().length());
                EditProfileFragmentNew.this.ivImageEdit.setVisibility(0);
                EditProfileFragmentNew.this.ivEdit.setVisibility(8);
            }
        });
        this.ivImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditProfileFragmentNew.this.ivProfile.performClick();
            }
        });
        this.ivProfile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    if (!Utils.preventMultipleClicks()) {
                        return;
                    }
                    Intent imageIntent = new Intent((Context)EditProfileFragmentNew.this.getActivity(), ImageDisplayActivity.class);
                    Image image = new Image(HippoApplication.getInstance().getUserData().getUserImage(), HippoApplication.getInstance().getUserData().getUserImage(), "", "", "");
                    imageIntent.putExtra("image", (Serializable)image);
                    ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)EditProfileFragmentNew.this.getActivity(), (View)EditProfileFragmentNew.this.ivProfile, (String)"");
                    EditProfileFragmentNew.this.startActivity(imageIntent, options.toBundle());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.ivImageEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditProfileFragmentNew.this.openImageChooser();
            }
        });
        this.tvSave.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditProfileFragmentNew.this.editAgentData();
            }
        });
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditProfileFragmentNew.this.getActivity().onBackPressed();
            }
        });
    }

    private void openImageChooser() {
        boolean isGranted = EasyPermissions.hasPermissions((Context)this.getContext(), (String[])new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        if (isGranted) {
            new CustomAlertDialog.Builder((Context)this.getActivity()).setTitle("Select option").setPositiveButton("Camera", new CustomAlertDialog.CustomDialogInterface.OnClickListener(){

                @Override
                public void onClick() {
                    EditProfileFragmentNew.this.imageChooser.takePicture();
                }
            }).setNegativeButton("Gallery", new CustomAlertDialog.CustomDialogInterface.OnClickListener(){

                @Override
                public void onClick() {
                    EditProfileFragmentNew.this.imageChooser.pickImageSingle();
                }
            }).show();
        } else {
            EasyPermissions.requestPermissions((Fragment)this, (String)this.getString(R.string.vw_rationale_storage), (int)124, (String[])new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        }
    }

    private void nonEditable() {
        this.tvEmail.setFocusable(false);
        this.tvEmail.setFocusableInTouchMode(false);
        this.tvEmail.getBackground().setColorFilter(Color.parseColor((String)"#f9f9f9"), PorterDuff.Mode.SRC_IN);
        this.tvName.setFocusable(false);
        this.tvName.setFocusableInTouchMode(false);
        this.tvName.getBackground().setColorFilter(Color.parseColor((String)"#f9f9f9"), PorterDuff.Mode.SRC_IN);
        this.tvPhone.setFocusable(false);
        this.tvPhone.setFocusableInTouchMode(false);
        this.tvPhone.getBackground().setColorFilter(Color.parseColor((String)"#f9f9f9"), PorterDuff.Mode.SRC_IN);
    }

    @Subscribe
    public void onUserData(ProfileData profileData) {
        if (profileData.type == 1) {
            this.updateUserData(profileData.agentProfileDetails);
        }
    }

    private void updateUserData(AgentProfileDetails agentProfileDetails) {
        this.tvEmail.setText((CharSequence)agentProfileDetails.getData().getEmail());
        this.tvName.setText((CharSequence)agentProfileDetails.getData().getFullName());
        this.loadImage(agentProfileDetails.getData().getUserImage());
        PhoneFunctions phoneFunctions = new PhoneFunctions();
        String phoneNumber = HippoApplication.getInstance().getUserData().getPhoneNumber();
        String phone = "";
        if (!TextUtils.isEmpty((CharSequence)phoneNumber) && phoneNumber.substring(0, 1).equals("+")) {
            phone = phoneNumber.substring(1, phoneNumber.length());
        }
        String countryCode = phoneFunctions.getCountry(this.getResources().getStringArray(R.array.CountryCodes), phone);
        if (!TextUtils.isEmpty((CharSequence)phoneNumber)) {
            this.tvPhone.setText((CharSequence)phoneNumber.substring(countryCode.length() + 1));
        }
    }

    private void loadImage(String url) {
        try {
            RequestOptions options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).placeholder(R.drawable.placeholder)).error(R.drawable.placeholder)).fitCenter()).priority(Priority.HIGH);
            Glide.with((FragmentActivity)this.getActivity()).asBitmap().apply((BaseRequestOptions)options).load(url).into((ImageView)this.ivProfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister((Object)this);
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    private void editAgentData() {
        if (this.isNetworkAvailable()) {
            MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
            MultipartParams multipartParams = multipartBuilder.build();
            if (this.profileImgFile != null) {
                this.imageFile = null;
                this.imageFile = this.profileImgFile.toString();
                multipartParams = multipartBuilder.addFile("file", new File(this.imageFile)).add("access_token", HippoApplication.getInstance().getUserData().getAccessToken()).add("en_user_id", String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId())).add("agent_type", String.valueOf(HippoApplication.getInstance().getUserData().getAgentType())).add("business_id", String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId())).add("full_name", this.tvName.getText().toString()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity())).add("device_type", "1").build();
            } else {
                multipartParams = multipartBuilder.add("access_token", HippoApplication.getInstance().getUserData().getAccessToken()).add("en_user_id", HippoApplication.getInstance().getUserData().getEnUserId()).add("agent_type", String.valueOf(HippoApplication.getInstance().getUserData().getAgentType())).add("business_id", String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId())).add("full_name", this.tvName.getText().toString()).add("device_type", "1").add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity())).build();
            }
            RestClient.getApiInterface().editAgentInfo(multipartParams.getMap()).enqueue((Callback)new ResponseResolver<EditProfileResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(true)){

                @Override
                public void success(EditProfileResponse editProfileResponse) {
                    Logger.INSTANCE.apiResponse("/api/agent/editInfo", "");
                    Intent iRec = new Intent("com.fugu.agent.update");
                    iRec.putExtra("agent_name", EditProfileFragmentNew.this.tvName.getText().toString());
                    iRec.putExtra("agent_pic", EditProfileFragmentNew.this.imageFile);
                    EditProfileFragmentNew.this.getActivity().sendBroadcast(iRec);
                    HippoApplication.getInstance().getUserData().setFullName(EditProfileFragmentNew.this.tvName.getText().toString());
                    if (EditProfileFragmentNew.this.profileImgFile != null) {
                        if (editProfileResponse.getData() != null && !TextUtils.isEmpty((CharSequence)editProfileResponse.getData().getUserImage())) {
                            HippoApplication.getInstance().getAgentProfileDetails().getData().setUserImage(editProfileResponse.getData().getUserImage());
                            HippoApplication.getInstance().getUserData().setUserImage(editProfileResponse.getData().getUserImage());
                        } else {
                            new ConversationApiHelper().getAgentData();
                        }
                    }
                    Toast.makeText((Context)EditProfileFragmentNew.this.getActivity(), (CharSequence)EditProfileFragmentNew.this.getResources().getString(R.string.profile_save_succ), (int)0).show();
                    EditProfileFragmentNew.this.nonEditable();
                    EditProfileFragmentNew.this.ivEdit.setVisibility(0);
                    EditProfileFragmentNew.this.ivImageEdit.setVisibility(8);
                    EditProfileFragmentNew.this.tvSave.setVisibility(8);
                }

                @Override
                public void failure(APIError error) {
                    Logger.INSTANCE.apiFailed("/api/agent/editInfo", error.getMessage());
                    Toast.makeText((Context)EditProfileFragmentNew.this.getActivity(), (CharSequence)error.getMessage(), (int)0).show();
                }
            });
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 3111 || requestCode == 4222) {
            this.imageChooser.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1900) {
            this.imageChooser.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @Override
    public void loadImage(List<ChosenImage> list) {
        this.profileImgFile = new File(list.get(0).getOriginalPath());
        LoadImageFile.getInstance().loadImage((Context)this.getActivity(), list.get(0).getThumbnailPath(), R.drawable.agent_ic_profile_placeholder, (ImageView)this.ivProfile, 3);
    }

    private void enableTextView(EditText tvName) {
        tvName.setFocusable(true);
        tvName.setFocusableInTouchMode(true);
        tvName.setClickable(true);
        tvName.invalidate();
        tvName.getBackground().setColorFilter(-16777216, PorterDuff.Mode.SRC_IN);
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public void onPermissionsGranted(int i, @NonNull List<String> list) {
        this.openImageChooser();
    }

    public void onPermissionsDenied(int i, @NonNull List<String> perms) {
        if (EasyPermissions.somePermissionPermanentlyDenied((Fragment)this, perms)) {
            new AppSettingsDialog.Builder((Fragment)this).build().show();
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"Please grant permission", (int)0).show();
        }
    }
}

