/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.hippoagent.R;
import com.hippoagent.activities.ProfileActivityName;
import com.hippoagent.appData.UserOnBoard;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.utils.ImageChooser;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.PhoneFunctions;
import com.hippoagent.utils.ValidateClass;
import com.hippoagent.utils.filePicker.ImageUtils;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;
import java.util.List;

public class EditProfileFragment
extends Fragment
implements View.OnClickListener,
ImageChooser.OnImageSelectListener {
    private ImageUtils imageUtils;
    private RelativeLayout rlImage;
    private RelativeLayout rlParent;
    private CircleImageView ivAgentImage;
    private AgentProfileDetails agentProfileDetails;
    private EditText etAgentName;
    private EditText etAgentEmail;
    private EditText etPhone;
    private Button btnSaveInfo;
    private ImageChooser imageChooser;
    private File profileImgFile;
    private String imageFile;
    private int userOnBoardingValue = 0;
    private ProfileActivityName profileActivity;

    public static EditProfileFragment newInstance() {
        EditProfileFragment fragment = new EditProfileFragment();
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_edit_profile, container, false);
        this.profileActivity = (ProfileActivityName)this.getActivity();
        if (this.getArguments() != null && this.getArguments().getInt("user_onboard_value") != 0) {
            this.userOnBoardingValue = this.getArguments().getInt("user_onboard_value");
        }
        this.initView(view);
        if (this.userOnBoardingValue == 0) {
            this.getSetData();
        }
        return view;
    }

    private void initView(View view) {
        this.rlImage = (RelativeLayout)view.findViewById(R.id.rlImage);
        this.rlParent = (RelativeLayout)view.findViewById(R.id.rlParent);
        this.rlImage.setOnClickListener((View.OnClickListener)this);
        this.ivAgentImage = (CircleImageView)view.findViewById(R.id.ivAgentImage);
        this.etAgentName = (EditText)view.findViewById(R.id.etAgentName);
        this.etAgentName.setOnClickListener((View.OnClickListener)this);
        this.etAgentEmail = (EditText)view.findViewById(R.id.etAgentEmail);
        this.etAgentEmail.setOnClickListener((View.OnClickListener)this);
        this.etPhone = (EditText)view.findViewById(R.id.etPhone);
        this.etPhone.setOnClickListener((View.OnClickListener)this);
        this.etAgentName.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 5) {
                    EditProfileFragment.this.etPhone.setFocusableInTouchMode(true);
                    EditProfileFragment.this.etPhone.setFocusable(true);
                    EditProfileFragment.this.etPhone.requestFocus();
                    EditProfileFragment.this.etPhone.setSelection(EditProfileFragment.this.etPhone.length());
                    return true;
                }
                return false;
            }
        });
        this.btnSaveInfo = (Button)view.findViewById(R.id.btnSaveInfo);
        this.btnSaveInfo.setOnClickListener((View.OnClickListener)this);
        if (UserOnBoard.get(this.userOnBoardingValue) == UserOnBoard.BOTH_NAME_PASSWORD) {
            this.btnSaveInfo.setText((CharSequence)this.getString(R.string.next));
        }
        this.imageChooser = new ImageChooser(this);
        this.etPhone.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    ValidateClass validateClass = new ValidateClass((Activity)EditProfileFragment.this.getActivity());
                    if (validateClass.genericEmpty(EditProfileFragment.this.etPhone, EditProfileFragment.this.getString(R.string.phone_empty_msg)) && validateClass.genericEmpty(EditProfileFragment.this.etAgentName, EditProfileFragment.this.getString(R.string.name_empty_msg))) {
                        EditProfileFragment.this.editAgentData();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void getSetData() {
        this.agentProfileDetails = new AgentProfileDetails();
        this.agentProfileDetails = (AgentProfileDetails)this.getArguments().getParcelable("agentData");
        if (this.agentProfileDetails != null && this.agentProfileDetails.getData() != null) {
            this.etAgentName.setText((CharSequence)this.agentProfileDetails.getData().getFullName());
            this.etAgentEmail.setText((CharSequence)this.agentProfileDetails.getData().getEmail());
            LoadImageFile.getInstance().loadImage((Context)this.getActivity(), this.agentProfileDetails.getData().getUserImage(), (ImageView)this.ivAgentImage);
            this.imageFile = this.agentProfileDetails.getData().getUserImage();
            PhoneFunctions phoneFunctions = new PhoneFunctions();
            String phone = "";
            if (!TextUtils.isEmpty((CharSequence)this.agentProfileDetails.getData().getPhoneNumber()) && this.agentProfileDetails.getData().getPhoneNumber().substring(0, 1).equals("+")) {
                phone = this.agentProfileDetails.getData().getPhoneNumber().substring(1, this.agentProfileDetails.getData().getPhoneNumber().length());
            }
            String countryCode = phoneFunctions.getCountry(this.getResources().getStringArray(R.array.CountryCodes), phone);
            if (!TextUtils.isEmpty((CharSequence)this.agentProfileDetails.getData().getPhoneNumber())) {
                this.etPhone.setText((CharSequence)this.agentProfileDetails.getData().getPhoneNumber().substring(countryCode.length() + 1));
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.rlImage) {
            this.imageChooser.selectImage();
        } else if (id2 == R.id.btnSaveInfo) {
            this.getActivity().getWindow().getDecorView().clearFocus();
            ValidateClass validateClass = new ValidateClass((Activity)this.getActivity());
            if (this.userOnBoardingValue > 0) {
                if (validateClass.genericEmpty(this.etAgentName, this.getString(R.string.name_empty_msg))) {
                    this.editAgentData(true);
                }
            } else if (validateClass.genericEmpty(this.etPhone, this.getString(R.string.phone_empty_msg)) && validateClass.genericEmpty(this.etAgentName, this.getString(R.string.name_empty_msg))) {
                this.editAgentData();
            }
        } else if (id2 == R.id.etPhone || id2 == R.id.etAgentName) {
            // empty if block
        }
    }

    private void editAgentData() {
    }

    private void editAgentData(boolean flag) {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 3111 || requestCode == 4222) {
            this.imageChooser.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1900) {
            this.imageChooser.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @Override
    public void loadImage(List<ChosenImage> list) {
        this.profileImgFile = new File(list.get(0).getThumbnailPath());
        LoadImageFile.getInstance().loadImage((Context)this.getActivity(), list.get(0).getThumbnailPath(), R.drawable.agent_ic_profile_placeholder, (ImageView)this.ivAgentImage, 3);
    }
}

