/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.google.gson.Gson;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.ProfileActivityName;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.ValidateClass;
import com.hippoagent.utils.filelogger.Logger;
import java.util.HashMap;
import retrofit2.Callback;

public class ChangePasswordFragment
extends Fragment
implements View.OnClickListener {
    private EditText etPassword;
    private EditText etConfirmPassword;
    private EditText etOldPassword;
    private Button btnSave;
    private ImageView ivEyePass;
    private ImageView ivEyeConfPass;
    private ImageView ivOldEyePass;
    private boolean isEyePress = false;
    private boolean isConfEyePress = false;
    private boolean isOldEyePress = false;
    private RelativeLayout rlParent;
    private int userOnBoardingValue = 0;
    private LinearLayout llOldPass;
    private View oldlineView;
    private Toolbar toolbar;

    public static ChangePasswordFragment newInstance() {
        ChangePasswordFragment fragment = new ChangePasswordFragment();
        return fragment;
    }

    public static ChangePasswordFragment newInstance(int userOnBoardingValue) {
        ChangePasswordFragment fragment = new ChangePasswordFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("user_onboard_value", userOnBoardingValue);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.userOnBoardingValue = this.getArguments().getInt("user_onboard_value", 0);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_change_password, container, false);
        this.initView(view);
        return view;
    }

    private void initView(View view) {
        this.toolbar = (Toolbar)view.findViewById(R.id.toolbar);
        if (this.getActivity() instanceof ProfileActivityName) {
            ((ProfileActivityName)this.getActivity()).setSupportActionBar(this.toolbar);
            ((ProfileActivityName)this.getActivity()).setToolbar(this.toolbar, this.getResources().getString(R.string.change_password));
            this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ((ProfileActivityName)ChangePasswordFragment.this.getActivity()).onBackPressed();
                }
            });
        }
        this.etPassword = (EditText)view.findViewById(R.id.etPassword);
        this.etConfirmPassword = (EditText)view.findViewById(R.id.etConfirmPassword);
        this.etOldPassword = (EditText)view.findViewById(R.id.etOldPassword);
        this.oldlineView = view.findViewById(R.id.oldlineView);
        this.llOldPass = (LinearLayout)view.findViewById(R.id.llOldPass);
        if (this.userOnBoardingValue != 0) {
            this.llOldPass.setVisibility(8);
            this.oldlineView.setVisibility(8);
        }
        this.btnSave = (Button)view.findViewById(R.id.btnSave);
        this.btnSave.setOnClickListener((View.OnClickListener)this);
        this.ivEyePass = (ImageView)view.findViewById(R.id.ivEyePass);
        this.ivEyePass.setOnClickListener((View.OnClickListener)this);
        this.ivEyeConfPass = (ImageView)view.findViewById(R.id.ivEyeConfPass);
        this.ivEyeConfPass.setOnClickListener((View.OnClickListener)this);
        this.ivOldEyePass = (ImageView)view.findViewById(R.id.ivOldEyePass);
        this.ivOldEyePass.setOnClickListener((View.OnClickListener)this);
        this.rlParent = (RelativeLayout)view.findViewById(R.id.rlParent);
        this.etConfirmPassword.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    ValidateClass validateClass = new ValidateClass((Activity)ChangePasswordFragment.this.getActivity());
                    if (ChangePasswordFragment.this.userOnBoardingValue == 0) {
                        validateClass.genericEmpty(ChangePasswordFragment.this.etOldPassword, ChangePasswordFragment.this.getString(R.string.old_pass_empty_msg));
                        validateClass.checkPassword(ChangePasswordFragment.this.etOldPassword);
                    }
                    if (validateClass.genericEmpty(ChangePasswordFragment.this.etPassword, ChangePasswordFragment.this.getString(R.string.new_pass_empty_msg)) && validateClass.genericEmpty(ChangePasswordFragment.this.etConfirmPassword, ChangePasswordFragment.this.getString(R.string.conf_pass_empty_msg)) && validateClass.checkPassword(ChangePasswordFragment.this.etPassword).booleanValue() && validateClass.passwordMatch(ChangePasswordFragment.this.etPassword, ChangePasswordFragment.this.etConfirmPassword).booleanValue()) {
                        if (ChangePasswordFragment.this.etPassword.getText().toString().equals(ChangePasswordFragment.this.etOldPassword.getText().toString())) {
                            Toast.makeText((Context)ChangePasswordFragment.this.getActivity(), (CharSequence)ChangePasswordFragment.this.getResources().getString(R.string.same_pass_err), (int)0).show();
                        } else {
                            ChangePasswordFragment.this.changePassApi();
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnSave) {
            this.getActivity().getWindow().getDecorView().clearFocus();
            ValidateClass validateClass = new ValidateClass((Activity)this.getActivity());
            if (this.userOnBoardingValue == 0) {
                validateClass.genericEmpty(this.etOldPassword, this.getString(R.string.old_pass_empty_msg));
                validateClass.checkPassword(this.etOldPassword);
            }
            if (validateClass.checkPassword(this.etPassword).booleanValue() && validateClass.passwordMatch(this.etPassword, this.etConfirmPassword).booleanValue()) {
                if (this.etPassword.getText().toString().equals(this.etOldPassword.getText().toString())) {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)this.getResources().getString(R.string.same_pass_err), (int)0).show();
                } else {
                    this.changePassApi();
                }
            }
        } else if (id2 == R.id.ivOldEyePass) {
            if (this.isOldEyePress) {
                this.ivOldEyePass.setImageResource(R.drawable.agent_ic_eye_inactive);
                this.etOldPassword.setInputType(129);
                this.isOldEyePress = false;
            } else {
                this.ivOldEyePass.setImageResource(R.drawable.agent_ic_eye_active);
                this.etOldPassword.setInputType(144);
                this.isOldEyePress = true;
            }
            this.etOldPassword.setSelection(this.etOldPassword.getText().length());
        } else if (id2 == R.id.ivEyePass) {
            if (this.isEyePress) {
                this.ivEyePass.setImageResource(R.drawable.agent_ic_eye_inactive);
                this.etPassword.setInputType(129);
                this.isEyePress = false;
            } else {
                this.ivEyePass.setImageResource(R.drawable.agent_ic_eye_active);
                this.etPassword.setInputType(144);
                this.isEyePress = true;
            }
            this.etPassword.setSelection(this.etPassword.getText().length());
        } else if (id2 == R.id.ivEyeConfPass) {
            if (this.isConfEyePress) {
                this.ivEyeConfPass.setImageResource(R.drawable.agent_ic_eye_inactive);
                this.etConfirmPassword.setInputType(129);
                this.isConfEyePress = false;
            } else {
                this.ivEyeConfPass.setImageResource(R.drawable.agent_ic_eye_active);
                this.etConfirmPassword.setInputType(144);
                this.isConfEyePress = true;
            }
            this.etConfirmPassword.setSelection(this.etConfirmPassword.getText().length());
        } else if (id2 == R.id.inputOldPassword || id2 == R.id.inputPassword || id2 == R.id.inputConfirmPassword) {
            // empty if block
        }
    }

    private void changePassApi() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
        params.put("new_password", this.etPassword.getText().toString());
        if (this.userOnBoardingValue == 0) {
            params.put("old_password", this.etOldPassword.getText().toString());
        }
        CommonParams commonParams = new CommonParams.Builder().addAll(params).build();
        Logger.INSTANCE.apiRequest("api/agent/changePassword", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().changePassword(commonParams.getMap()).enqueue((Callback)new ResponseResolver<AgentProfileDetails>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(true)){

            @Override
            public void success(AgentProfileDetails editProfileResponse) {
                Logger.INSTANCE.apiResponse("api/agent/changePassword", "");
                if (ChangePasswordFragment.this.userOnBoardingValue != 0) {
                    if (ChangePasswordFragment.this.getActivity() instanceof ProfileActivityName) {
                        ((ProfileActivityName)ChangePasswordFragment.this.getActivity()).afterAgentOnBoard();
                    } else {
                        ChangePasswordFragment.this.getActivity().onBackPressed();
                    }
                } else {
                    Toast.makeText((Context)ChangePasswordFragment.this.getActivity(), (CharSequence)ChangePasswordFragment.this.getResources().getString(R.string.pass_save_succ), (int)0).show();
                    ChangePasswordFragment.this.getActivity().onBackPressed();
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("api/agent/changePassword", error.getMessage());
                Toast.makeText((Context)ChangePasswordFragment.this.getActivity(), (CharSequence)error.getMessage(), (int)0).show();
            }
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.hardKeyboardHidden != 1 && newConfig.hardKeyboardHidden == 2) {
            this.getActivity().getWindow().getDecorView().clearFocus();
        }
    }
}

