/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fcm;

import android.R;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.media.AudioAttributes;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.Html;
import android.text.TextUtils;
import androidx.core.app.NotificationCompat;
import androidx.core.app.Person;
import androidx.core.app.RemoteInput;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.fcm.AudioPlay;
import com.hippoagent.fcm.CancelIntentService;
import com.hippoagent.fcm.NotificationDatabase;
import com.hippoagent.fcm.PushNotification;
import com.hippoagent.fcm.RetryIntentService;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.PushIntentService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0006J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/hippoagent/fcm/PushHandler;", "Lcom/hippoagent/datastructure/FuguAppConstant;", "()V", "BK_SOUND_TIME", "", "CHANNEL_ONE_NAME", "", "getCHANNEL_ONE_NAME", "()Ljava/lang/String;", "KEY_REPLY", "getKEY_REPLY", "setKEY_REPLY", "(Ljava/lang/String;)V", "NOTIFICATION_CHANNEL_ID", "getNOTIFICATION_CHANNEL_ID", "notificationSoundEnabled", "", "getPriority", "getRingtoneAudioAttributes", "Landroid/media/AudioAttributes;", "getTimeMilliSec", "", "timeStamp", "notificationHelper", "", "context", "Landroid/content/Context;", "data", "Lorg/json/JSONObject;", "notificationMissedCall", "notificationVerify", "playSound", "recreatePush", "channelId", "sendingMessage", "showMissedCall", "showNewConversation", "showVerification", "Reply", "hippoagentsdk_release"})
public final class PushHandler
implements FuguAppConstant {
    @NotNull
    private final String NOTIFICATION_CHANNEL_ID = "12001";
    @NotNull
    private final String CHANNEL_ONE_NAME = "Default notification";
    @NotNull
    private String KEY_REPLY = "key_reply";
    private final int BK_SOUND_TIME = 15;
    private boolean notificationSoundEnabled;

    @NotNull
    public final String getNOTIFICATION_CHANNEL_ID() {
        return this.NOTIFICATION_CHANNEL_ID;
    }

    @NotNull
    public final String getCHANNEL_ONE_NAME() {
        return this.CHANNEL_ONE_NAME;
    }

    @NotNull
    public final String getKEY_REPLY() {
        return this.KEY_REPLY;
    }

    public final void setKEY_REPLY(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.KEY_REPLY = string2;
    }

    public final void notificationHelper(@NotNull Context context, @NotNull JSONObject data, boolean notificationSoundEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        JSONObject messageJson = data;
        this.notificationSoundEnabled = notificationSoundEnabled;
        this.showNewConversation(context, data);
    }

    public final void notificationMissedCall(@NotNull Context context, @NotNull JSONObject data) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.showMissedCall(context, data);
    }

    public final void notificationVerify(@NotNull Context context, @NotNull JSONObject data) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.showVerification(context, data);
    }

    public final void recreatePush(@NotNull Context context, int channelId, @NotNull String sendingMessage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sendingMessage, (String)"sendingMessage");
        ArrayList<PushNotification> notificationList = NotificationDatabase.INSTANCE.getNotifications(channelId);
        PushNotification pushNotification = notificationList.get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)pushNotification, (String)"notificationList[0]");
        PushNotification pushData = pushNotification;
        JSONObject data = new JSONObject();
        data.put("channel_id", pushData.getChannelId());
        data.put("push_message", (Object)sendingMessage);
        data.put("title", (Object)pushData.getTitle());
        data.put("date_time", (Object)pushData.getDateTime());
        data.put("user_id", pushData.getUserID());
        data.put("disable_reply", pushData.getDisableReply());
        data.put("label", (Object)pushData.getLabel());
        data.put("is_recreated", true);
        int channelId2 = pushData.getChannelId();
        String title = "Message sending failed!";
        String message = sendingMessage;
        String timeStamp = pushData.getDateTime();
        int icon = R.mipmap.ic_launcher;
        Intent notificationIntent = new Intent(context, PushIntentService.class);
        notificationIntent.putExtra("json", data.toString());
        notificationIntent.setFlags(0x10008000);
        PendingIntent pi = PendingIntent.getService((Context)context, (int)((int)data.getLong("channel_id")), (Intent)notificationIntent, (int)0x8000000);
        NotificationCompat.Builder mBuilder = null;
        mBuilder = new NotificationCompat.Builder(context, this.NOTIFICATION_CHANNEL_ID);
        Intent retryIntent = new Intent(context, RetryIntentService.class);
        retryIntent.putExtra("json", data.toString());
        retryIntent.setFlags(0x10008000);
        PendingIntent rpi = PendingIntent.getService((Context)context, (int)channelId2, (Intent)retryIntent, (int)0x8000000);
        Intent cancelIntent = new Intent(context, CancelIntentService.class);
        cancelIntent.putExtra("channel_id", channelId2);
        PendingIntent cpi = PendingIntent.getService((Context)context, (int)channelId2, (Intent)cancelIntent, (int)0x8000000);
        NotificationCompat.Action replyAction = new NotificationCompat.Action.Builder(17301646, (CharSequence)"RETRY", rpi).build();
        NotificationCompat.Action cancelAction = new NotificationCompat.Action.Builder(17301646, (CharSequence)"CANCEL", cpi).build();
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.addLine((CharSequence)message);
        mBuilder.setContentTitle((CharSequence)title);
        mBuilder.setContentIntent(pi);
        mBuilder.setStyle((NotificationCompat.Style)inboxStyle);
        String string2 = DateUtils.getInstance().convertToLocal(timeStamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DateUtils.getInstance().convertToLocal(timeStamp)");
        mBuilder.setWhen(this.getTimeMilliSec(string2));
        mBuilder.setSmallIcon(R.mipmap.hippo_notif);
        mBuilder.setDefaults(1);
        mBuilder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)icon));
        mBuilder.setContentText((CharSequence)Html.fromHtml((String)message));
        mBuilder.setPriority(this.getPriority());
        mBuilder.setAutoCancel(true);
        mBuilder.addAction(replyAction);
        mBuilder.addAction(cancelAction);
        mBuilder.setDeleteIntent(cpi);
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        if (Build.VERSION.SDK_INT >= 26) {
            int importance = 4;
            NotificationChannel notificationChannel = new NotificationChannel(this.NOTIFICATION_CHANNEL_ID, (CharSequence)this.CHANNEL_ONE_NAME, importance);
            notificationChannel.enableLights(true);
            notificationChannel.setLightColor(-65536);
            notificationChannel.enableVibration(true);
            notificationChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
            boolean bl = notificationManager != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string3 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            notificationManager.createNotificationChannel(notificationChannel);
        }
        Notification notification = mBuilder.build();
        if (Build.VERSION.SDK_INT >= 21) {
            Resources resources = context.getResources();
            Package package_ = R.class.getPackage();
            if (package_ == null) {
                Intrinsics.throwNpe();
            }
            int smallIconViewId = resources.getIdentifier("right_icon", "id", package_.getName());
            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null) {
                        notification.contentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.headsUpContentView != null) {
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.bigContentView != null) {
                        notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        notificationManager.notify(channelId2, notification);
    }

    private final void showNewConversation(Context context, JSONObject data) {
        int i;
        int channelId = data.optInt("channel_id", -1);
        String string2 = data.optString("new_message");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"new_message\")");
        String message = string2;
        String string3 = data.optString("title");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"title\")");
        String title = string3;
        String timeStamp = data.optString("date_time");
        int userId = data.optInt("user_id", -1);
        int disableReply = data.optInt("disable_reply", 0);
        String label = data.optString("label", "User");
        String sendName = data.optString("last_sent_by_full_name", "");
        int icon = R.mipmap.ic_launcher;
        ArrayList<Object> notificationList = new ArrayList();
        notificationList = NotificationDatabase.INSTANCE.getNotifications(channelId);
        String string4 = timeStamp;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"timeStamp");
        String string5 = label;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"label");
        notificationList.add(new PushNotification(channelId, message, string4, title, userId, disableReply, string5));
        NotificationDatabase.INSTANCE.setNotification(channelId, notificationList);
        Intent cancelIntent = new Intent(context, CancelIntentService.class);
        cancelIntent.putExtra("channel_id", channelId);
        PendingIntent dismissPi = PendingIntent.getService((Context)context, (int)channelId, (Intent)cancelIntent, (int)0x8000000);
        Intent notificationIntent = new Intent(context, PushIntentService.class);
        notificationIntent.putExtra("channelId", channelId);
        notificationIntent.putExtra("label", label);
        notificationIntent.putExtra("disable_reply", disableReply);
        notificationIntent.putExtra("user_id", userId);
        notificationIntent.putExtra("json", data.toString());
        PendingIntent pi = PendingIntent.getService((Context)context, (int)((int)data.getLong("channel_id")), (Intent)notificationIntent, (int)0x8000000);
        RemoteInput remoteInput = new RemoteInput.Builder(this.KEY_REPLY).setLabel((CharSequence)"Enter your reply here").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)remoteInput, (String)"RemoteInput.Builder(KEY_\u2026\n                .build()");
        RemoteInput remoteInput2 = remoteInput;
        NotificationCompat.Action replyAction = new NotificationCompat.Action.Builder(17301646, (CharSequence)"REPLY", pi).addRemoteInput(remoteInput2).setAllowGeneratedReplies(true).build();
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, this.NOTIFICATION_CHANNEL_ID);
        ArrayList<Object> notificationListToBeDisplayed = new ArrayList<Object>();
        int maxLines = 6;
        int n = 0;
        int n2 = ((Collection)notificationList).size();
        while (n < n2) {
            notificationListToBeDisplayed.add(notificationList.get(i));
            ++i;
        }
        Person person = new Person.Builder().setName((CharSequence)sendName).setIcon(null).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)person, (String)"Person.Builder().setName\u2026me).setIcon(null).build()");
        Person sender = person;
        NotificationCompat.MessagingStyle messageStyle = new NotificationCompat.MessagingStyle(sender);
        for (i = 0; i < notificationListToBeDisplayed.size(); ++i) {
            Person senderPerson;
            Intrinsics.checkExpressionValueIsNotNull((Object)new Person.Builder().setName((CharSequence)sendName).setIcon(null).build(), (String)"Person.Builder()\n       \u2026                 .build()");
            NotificationCompat.MessagingStyle.Message senderMessage = new NotificationCompat.MessagingStyle.Message((CharSequence)Html.fromHtml((String)((PushNotification)notificationListToBeDisplayed.get(i)).getMessage()), new Date().getTime(), senderPerson);
            messageStyle.addMessage(senderMessage);
        }
        messageStyle.setConversationTitle((CharSequence)title);
        messageStyle.build();
        mBuilder.setContentTitle((CharSequence)title);
        mBuilder.setContentIntent(pi);
        mBuilder.setStyle((NotificationCompat.Style)messageStyle);
        String string6 = DateUtils.getInstance().convertToLocal(timeStamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"DateUtils.getInstance().convertToLocal(timeStamp)");
        mBuilder.setWhen(this.getTimeMilliSec(string6));
        mBuilder.setSmallIcon(R.mipmap.hippo_notif);
        if (this.notificationSoundEnabled) {
            mBuilder.setDefaults(1);
        }
        mBuilder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)icon));
        mBuilder.setContentText((CharSequence)Html.fromHtml((String)message));
        mBuilder.setPriority(this.getPriority());
        mBuilder.setAutoCancel(true);
        mBuilder.addAction(replyAction);
        mBuilder.setDeleteIntent(dismissPi);
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        if (Build.VERSION.SDK_INT >= 26) {
            int importance = 4;
            NotificationChannel notificationChannel = new NotificationChannel(this.NOTIFICATION_CHANNEL_ID, (CharSequence)this.CHANNEL_ONE_NAME, importance);
            notificationChannel.enableLights(true);
            notificationChannel.setLightColor(-65536);
            if (this.notificationSoundEnabled) {
                notificationChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, this.getRingtoneAudioAttributes());
            }
            notificationChannel.enableVibration(true);
            notificationChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
            boolean bl = notificationManager != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string7 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string7));
            }
            notificationManager.createNotificationChannel(notificationChannel);
        }
        Notification notification = mBuilder.build();
        if (Build.VERSION.SDK_INT >= 21) {
            Resources resources = context.getResources();
            Package package_ = R.class.getPackage();
            if (package_ == null) {
                Intrinsics.throwNpe();
            }
            int smallIconViewId = resources.getIdentifier("right_icon", "id", package_.getName());
            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null) {
                        notification.contentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.headsUpContentView != null) {
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.bigContentView != null) {
                        notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        notificationManager.notify(channelId, notification);
    }

    private final void showVerification(Context context, JSONObject data) {
        String string2 = data.optString("message");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"message\")");
        String message = string2;
        String string3 = data.optString("title");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"title\")");
        String title = string3;
        String timeStamp = data.optString("date_time");
        int icon = R.mipmap.ic_launcher;
        Intent notificationIntent = new Intent(context, PushIntentService.class);
        notificationIntent.putExtra("json", data.toString());
        notificationIntent.putExtra("is_promotional", true);
        notificationIntent.setFlags(0x10008000);
        PendingIntent pi = PendingIntent.getService((Context)context, (int)112, (Intent)notificationIntent, (int)0x8000000);
        NotificationCompat.Builder mBuilder = null;
        mBuilder = new NotificationCompat.Builder(context, this.NOTIFICATION_CHANNEL_ID);
        mBuilder.setContentTitle((CharSequence)title);
        mBuilder.setContentIntent(pi);
        String string4 = DateUtils.getInstance().convertToLocal(timeStamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"DateUtils.getInstance().convertToLocal(timeStamp)");
        mBuilder.setWhen(this.getTimeMilliSec(string4));
        mBuilder.setSmallIcon(R.mipmap.hippo_notif);
        mBuilder.setDefaults(1);
        mBuilder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)icon));
        mBuilder.setContentText((CharSequence)Html.fromHtml((String)message));
        mBuilder.setPriority(this.getPriority());
        mBuilder.setAutoCancel(true);
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        if (Build.VERSION.SDK_INT >= 26) {
            int importance = 4;
            NotificationChannel notificationChannel = new NotificationChannel(this.NOTIFICATION_CHANNEL_ID, (CharSequence)this.CHANNEL_ONE_NAME, importance);
            notificationChannel.enableLights(true);
            notificationChannel.setLightColor(-65536);
            notificationChannel.enableVibration(true);
            boolean bl = notificationManager != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string5 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string5));
            }
            notificationManager.createNotificationChannel(notificationChannel);
        }
        Notification notification = mBuilder.build();
        if (Build.VERSION.SDK_INT >= 21) {
            Resources resources = context.getResources();
            Package package_ = R.class.getPackage();
            if (package_ == null) {
                Intrinsics.throwNpe();
            }
            int smallIconViewId = resources.getIdentifier("right_icon", "id", package_.getName());
            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null) {
                        notification.contentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.headsUpContentView != null) {
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.bigContentView != null) {
                        notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int id2 = (int)System.currentTimeMillis();
        notificationManager.notify(id2, notification);
    }

    private final void showMissedCall(Context context, JSONObject data) {
        String string2 = data.optString("message");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"message\")");
        String message = string2;
        String string3 = data.optString("title");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"title\")");
        String title = string3;
        String timeStamp = data.optString("date_time");
        int icon = R.mipmap.ic_launcher;
        Intent notificationIntent = new Intent(context, PushIntentService.class);
        notificationIntent.putExtra("json", data.toString());
        notificationIntent.putExtra("is_promotional", true);
        notificationIntent.setFlags(0x10008000);
        PendingIntent pi = PendingIntent.getService((Context)context, (int)112, (Intent)notificationIntent, (int)0x8000000);
        NotificationCompat.Builder mBuilder = null;
        mBuilder = new NotificationCompat.Builder(context, this.NOTIFICATION_CHANNEL_ID);
        mBuilder.setContentTitle((CharSequence)title);
        mBuilder.setContentIntent(pi);
        String string4 = DateUtils.getInstance().convertToLocal(timeStamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"DateUtils.getInstance().convertToLocal(timeStamp)");
        mBuilder.setWhen(this.getTimeMilliSec(string4));
        mBuilder.setSmallIcon(R.mipmap.hippo_notif);
        mBuilder.setDefaults(1);
        mBuilder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)icon));
        mBuilder.setContentText((CharSequence)Html.fromHtml((String)message));
        mBuilder.setPriority(this.getPriority());
        mBuilder.setAutoCancel(true);
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        if (Build.VERSION.SDK_INT >= 26) {
            int importance = 4;
            NotificationChannel notificationChannel = new NotificationChannel(this.NOTIFICATION_CHANNEL_ID, (CharSequence)this.CHANNEL_ONE_NAME, importance);
            notificationChannel.enableLights(true);
            notificationChannel.setLightColor(-65536);
            notificationChannel.enableVibration(true);
            if (this.notificationSoundEnabled) {
                notificationChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, this.getRingtoneAudioAttributes());
            }
            boolean bl = notificationManager != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string5 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string5));
            }
            notificationManager.createNotificationChannel(notificationChannel);
        }
        Notification notification = mBuilder.build();
        if (Build.VERSION.SDK_INT >= 21) {
            Resources resources = context.getResources();
            Package package_ = R.class.getPackage();
            if (package_ == null) {
                Intrinsics.throwNpe();
            }
            int smallIconViewId = resources.getIdentifier("right_icon", "id", package_.getName());
            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null) {
                        notification.contentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.headsUpContentView != null) {
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.bigContentView != null) {
                        notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int id2 = (int)System.currentTimeMillis();
        notificationManager.notify(id2, notification);
    }

    private final int getPriority() {
        return Build.VERSION.SDK_INT >= 24 ? 5 : 1;
    }

    private final void playSound(Context context) {
        if (CommonData.isBkUser()) {
            Intent intent = new Intent(context, AudioPlay.class);
            intent.putExtra("type", 1);
            intent.putExtra("time", this.BK_SOUND_TIME);
            context.startService(intent);
        }
    }

    private final long getTimeMilliSec(String timeStamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            if (!TextUtils.isEmpty((CharSequence)timeStamp)) {
                Date date;
                Date date2 = date = format.parse(timeStamp);
                Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"date");
                return date2.getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    @TargetApi(value=21)
    private final AudioAttributes getRingtoneAudioAttributes() {
        return new AudioAttributes.Builder().setContentType(0).setUsage(8).build();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/hippoagent/fcm/PushHandler$Reply;", "", "()V", "KEY_REPLY", "", "getKEY_REPLY$hippoagentsdk_release", "()Ljava/lang/String;", "setKEY_REPLY$hippoagentsdk_release", "(Ljava/lang/String;)V", "getReplyMessage", "", "intent", "Landroid/content/Intent;", "hippoagentsdk_release"})
    public static final class Reply {
        @NotNull
        private static String KEY_REPLY;
        public static final Reply INSTANCE;

        @NotNull
        public final String getKEY_REPLY$hippoagentsdk_release() {
            return KEY_REPLY;
        }

        public final void setKEY_REPLY$hippoagentsdk_release(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
            KEY_REPLY = string2;
        }

        @Nullable
        public final CharSequence getReplyMessage(@NotNull Intent intent) {
            Bundle remoteInput;
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            Bundle bundle = remoteInput = RemoteInput.getResultsFromIntent((Intent)intent);
            return bundle != null ? bundle.getCharSequence(KEY_REPLY) : null;
        }

        private Reply() {
        }

        static {
            Reply reply;
            INSTANCE = reply = new Reply();
            KEY_REPLY = "key_reply";
        }
    }
}

