/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fcm;

import android.R;
import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.util.Patterns;
import androidx.core.app.NotificationCompat;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.utils.DateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class NotificationUtils {
    private static String TAG = NotificationUtils.class.getSimpleName();
    public static final String NOTIFICATION_CHANNEL_ID = "12001";
    public static final String CHANNEL_ONE_NAME = "Default notification";
    private Context mContext;

    public NotificationUtils(Context mContext) {
        this.mContext = mContext;
    }

    public void showNotificationMessage(String title, String message, String timeStamp, Intent intent, int channedId) {
        this.showNotificationMessage(title, message, timeStamp, intent, null, channedId);
    }

    public void showNotificationMessage(String title, String message, String timeStamp, Intent intent, String imageUrl, int channedId) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        int icon = R.mipmap.ic_launcher;
        PendingIntent resultPendingIntent = PendingIntent.getService((Context)this.mContext, (int)channedId, (Intent)intent, (int)0);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.mContext, NOTIFICATION_CHANNEL_ID);
        Uri alarmSound = Uri.parse((String)("android.resource://" + this.mContext.getPackageName() + "/raw/notification"));
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            if (imageUrl != null && imageUrl.length() > 4 && Patterns.WEB_URL.matcher(imageUrl).matches()) {
                Bitmap bitmap = this.getBitmapFromURL(imageUrl);
                if (bitmap != null) {
                    this.showBigNotification(bitmap, mBuilder, icon, title, message, timeStamp, resultPendingIntent, alarmSound);
                } else {
                    this.showSmallNotification(mBuilder, icon, title, message, timeStamp, resultPendingIntent, alarmSound, channedId);
                }
            }
        } else {
            this.showSmallNotification(mBuilder, icon, title, message, timeStamp, resultPendingIntent, alarmSound, channedId);
        }
    }

    private void showSmallNotification(NotificationCompat.Builder mBuilder, int icon, String title, String message, String timeStamp, PendingIntent resultPendingIntent, Uri alarmSound, int channelId) {
        try {
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            inboxStyle.addLine((CharSequence)message);
            NotificationCompat.Builder builder2 = new NotificationCompat.Builder(this.mContext, NOTIFICATION_CHANNEL_ID);
            builder2.setAutoCancel(true);
            builder2.setContentTitle((CharSequence)title);
            builder2.setContentIntent(resultPendingIntent);
            builder2.setDefaults(1);
            builder2.setStyle((NotificationCompat.Style)inboxStyle);
            builder2.setWhen(NotificationUtils.getTimeMilliSec(DateUtils.getInstance().convertToLocal(timeStamp)));
            builder2.setSmallIcon(R.mipmap.hippo_notif);
            builder2.setLargeIcon(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)icon));
            builder2.setContentText((CharSequence)message);
            builder2.setPriority(1);
            builder2.setAutoCancel(true);
            NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int importance = 4;
                NotificationChannel notificationChannel = new NotificationChannel(NOTIFICATION_CHANNEL_ID, (CharSequence)CHANNEL_ONE_NAME, importance);
                notificationChannel.enableLights(true);
                notificationChannel.setLightColor(-65536);
                notificationChannel.enableVibration(true);
                notificationChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                assert (notificationManager != null);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            Notification notification = builder2.build();
            if (Build.VERSION.SDK_INT >= 21) {
                int smallIconViewId = this.mContext.getResources().getIdentifier("right_icon", "id", R.class.getPackage().getName());
                try {
                    if (smallIconViewId != 0) {
                        if (notification.contentIntent != null) {
                            notification.contentView.setViewVisibility(smallIconViewId, 4);
                        }
                        if (notification.headsUpContentView != null) {
                            notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                        }
                        if (notification.bigContentView != null) {
                            notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int id2 = (int)System.currentTimeMillis();
            notificationManager.notify(id2, notification);
            CommonData.saveNotificationId(channelId, id2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showBigNotification(Bitmap bitmap, NotificationCompat.Builder mBuilder, int icon, String title, String message, String timeStamp, PendingIntent resultPendingIntent, Uri alarmSound) {
        try {
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.setBigContentTitle((CharSequence)title);
            bigPictureStyle.setSummaryText((CharSequence)Html.fromHtml((String)message).toString());
            bigPictureStyle.bigPicture(bitmap);
            Notification notification = mBuilder.setSmallIcon(icon).setTicker((CharSequence)title).setWhen(0L).setAutoCancel(true).setContentTitle((CharSequence)title).setContentIntent(resultPendingIntent).setDefaults(!CommonData.isBkUser() ? 1 : 0).setStyle((NotificationCompat.Style)bigPictureStyle).setWhen(NotificationUtils.getTimeMilliSec(timeStamp)).setSmallIcon(R.mipmap.hippo_notif).setLargeIcon(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)icon)).setContentText((CharSequence)message).build();
            NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int importance = 3;
                NotificationChannel notificationChannel = new NotificationChannel(NOTIFICATION_CHANNEL_ID, (CharSequence)CHANNEL_ONE_NAME, importance);
                notificationChannel.enableLights(true);
                notificationChannel.setLightColor(-65536);
                notificationChannel.enableVibration(true);
                notificationChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                assert (notificationManager != null);
                mBuilder.setChannelId(NOTIFICATION_CHANNEL_ID);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            notificationManager.notify(101, notification);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Bitmap getBitmapFromURL(String strURL) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap myBitmap = BitmapFactory.decodeStream((InputStream)input);
            return myBitmap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void playNotificationSound() {
    }

    public static boolean isAppIsInBackground(Context context) {
        boolean isInBackground = true;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (Build.VERSION.SDK_INT > 20) {
            List runningProcesses = am.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                if (processInfo.importance != 100) continue;
                for (String activeProcess : processInfo.pkgList) {
                    if (!activeProcess.equals(context.getPackageName())) continue;
                    isInBackground = false;
                }
            }
        } else {
            List taskInfo = am.getRunningTasks(1);
            ComponentName componentInfo = ((ActivityManager.RunningTaskInfo)taskInfo.get((int)0)).topActivity;
            if (componentInfo.getPackageName().equals(context.getPackageName())) {
                isInBackground = false;
            }
        }
        return isInBackground;
    }

    public static void clearNotifications(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancelAll();
    }

    public static void clearNotifications(Context context, Integer integer) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(integer.intValue());
    }

    public static long getTimeMilliSec(String timeStamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            if (!TextUtils.isEmpty((CharSequence)timeStamp)) {
                Date date = format.parse(timeStamp);
                return date.getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 0L;
    }
}

