/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HippoPaymentActivity;
import com.hippoagent.adapters.SavedPlanAdapter;
import com.hippoagent.apis.PaymentPlan;
import com.hippoagent.callback.OnPaymentDialogListener;
import com.hippoagent.callback.OnPlanListener;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.PaymentData;
import com.hippoagent.model.payment.GetPaymentLinks;
import com.hippoagent.model.payment.PlanData;
import com.hippoagent.model.payment.Plans;
import com.hippoagent.model.payment.SavedPlanResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import retrofit2.Callback;

public class SavedPlanDialog
implements OnPaymentDialogListener {
    private Activity context;
    private Dialog dialog;
    private SavedPlanAdapter adapter;
    private ArrayList<PlanData> plansList = new ArrayList();
    private TextView noDataFound;
    private RecyclerView rvAgents;

    public SavedPlanDialog(Activity context) {
        this.context = context;
    }

    public Dialog show() {
        try {
            this.dialog = new Dialog((Context)this.context, R.style.HippoAppTheme);
            this.dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogFade;
            this.dialog.setContentView(R.layout.dialog_show_agents);
            WindowManager.LayoutParams layoutParams = this.dialog.getWindow().getAttributes();
            layoutParams.dimAmount = 0.6f;
            this.dialog.getWindow().addFlags(2);
            TextView tvTitle = (TextView)this.dialog.findViewById(R.id.tvTitle);
            TextView tvSavedData = (TextView)this.dialog.findViewById(R.id.tvSavedData);
            tvSavedData.setVisibility(8);
            tvTitle.setText((CharSequence)Restring.getString((Context)this.context, R.string.saved_plan));
            ProgressBar pbLoadReply = (ProgressBar)this.dialog.findViewById(R.id.pbLoadReply);
            pbLoadReply.setVisibility(8);
            ImageView ivClose = (ImageView)this.dialog.findViewById(R.id.ivClose);
            ImageButton ibSearch = (ImageButton)this.dialog.findViewById(R.id.ibSearch);
            LinearLayout llsearch = (LinearLayout)this.dialog.findViewById(R.id.llsearch);
            llsearch.setVisibility(8);
            ibSearch.setVisibility(8);
            ivClose.setVisibility(8);
            ImageView backBtn = (ImageView)this.dialog.findViewById(R.id.backBtn);
            ImageView ivAddNew = (ImageView)this.dialog.findViewById(R.id.ivAddNew);
            this.noDataFound = (TextView)this.dialog.findViewById(R.id.no_data_found);
            this.noDataFound.setVisibility(8);
            ivAddNew.setVisibility(0);
            backBtn.setVisibility(0);
            backBtn.setOnClickListener(v -> this.dialog.dismiss());
            ivAddNew.setOnClickListener(v -> {
                Intent paymentIntent = new Intent((Context)this.context, HippoPaymentActivity.class);
                paymentIntent.putExtra("from_saved_plan", true);
                this.context.startActivityForResult(paymentIntent, 1536);
                this.dialog.dismiss();
            });
            this.rvAgents = (RecyclerView)this.dialog.findViewById(R.id.rvAgents);
            this.rvAgents.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.context));
            this.rvAgents.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            this.rvAgents.setHasFixedSize(false);
            this.adapter = new SavedPlanAdapter(new OnPlanListener(){

                @Override
                public void onPlanViewOnly(int pos, @NotNull PlanData planData) {
                }

                @Override
                public void onPlanEditView(int pos, @NotNull PlanData planData) {
                }

                @Override
                public void onPlanClicked(int pos, @NotNull PlanData planData) {
                    SavedPlanDialog.this.sendPayment(pos, planData);
                }

                @Override
                public void onDeleteClicked(int pos, @NotNull PlanData planData) {
                    SavedPlanDialog.this.onPlanEdit(SavedPlanDialog.this.context, planData);
                }
            }, false);
            ivClose.setOnClickListener(v -> this.dialog.dismiss());
            this.rvAgents.setAdapter((RecyclerView.Adapter)this.adapter);
            this.getSavedCard();
            this.dialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.dialog;
    }

    private void getSavedCard() {
        if (((FuguChatActivity)this.context).isNetworkAvailable()) {
            ArrayList<Integer> array2 = new ArrayList<Integer>();
            array2.add(1);
            if (HippoConfig.getInstance().getAttributes() != null && HippoConfig.getInstance().getAttributes().getAdditionalInfo() != null && HippoConfig.getInstance().getAttributes().getAdditionalInfo().showBusinessPlan()) {
                array2.add(2);
            }
            GetPaymentLinks paymentLinks = new GetPaymentLinks(HippoApplication.getInstance().getUserData().getAccessToken(), 0, array2, HippoConfig.getInstance().getCurrentLanguage());
            RestClient.getApiInterface().getPaymentLinks(paymentLinks).enqueue((Callback)new ResponseResolver<SavedPlanResponse>(this.context, Boolean.valueOf(true), Boolean.valueOf(true)){

                @Override
                public void success(SavedPlanResponse savedPlanResponse) {
                    try {
                        SavedPlanDialog.this.plansList.addAll(savedPlanResponse.getData());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    SavedPlanDialog.this.adapter.setData(SavedPlanDialog.this.plansList);
                    if (SavedPlanDialog.this.plansList.size() == 0) {
                        Intent paymentIntent = new Intent((Context)SavedPlanDialog.this.context, HippoPaymentActivity.class);
                        paymentIntent.putExtra("from_saved_plan", true);
                        SavedPlanDialog.this.context.startActivityForResult(paymentIntent, 1536);
                        SavedPlanDialog.this.dialog.dismiss();
                    }
                }

                @Override
                public void failure(APIError error) {
                }
            });
        } else {
            Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    private void sendPayment(int position, PlanData planData) {
        String msg = Restring.getString((Context)this.context, R.string.hippo_send_this_plan);
        String yes = Restring.getString((Context)this.context, R.string.hippo_yes);
        String no = Restring.getString((Context)this.context, R.string.hippo_no);
        new AlertDialog.Builder((Context)this.context).setMessage((CharSequence)msg).setPositiveButton((CharSequence)yes, (dialog1, which) -> {
            try {
                ArrayList<PaymentData> paymentData = new ArrayList<PaymentData>();
                for (Plans data : planData.getPlans()) {
                    PaymentData data1 = new PaymentData();
                    data1.setTransactionId(UUID.randomUUID().toString() + "." + new Date().getTime());
                    data1.setTitle(data.getTitle());
                    data1.setId(data.getId());
                    data1.setDescription(data.getDescription());
                    data1.setAmount(data.getAmount());
                    data1.setCurrency(data.getCurrency());
                    data1.setCurrencySymbol(data.getCurrencySymbol());
                    paymentData.add(data1);
                }
                ((FuguChatActivity)this.context).sendPaymentRequest(paymentData);
                new Handler().post(new Runnable(){

                    @Override
                    public void run() {
                        dialog1.dismiss();
                        if (SavedPlanDialog.this.dialog != null) {
                            SavedPlanDialog.this.dialog.dismiss();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).setNegativeButton((CharSequence)no, (dialog1, which) -> {}).show();
    }

    private void deletePlan(int position, PlanData planData) {
        String msg = Restring.getString((Context)this.context, R.string.hippo_delete_this_plan);
        String yes = Restring.getString((Context)this.context, R.string.hippo_yes);
        String no = Restring.getString((Context)this.context, R.string.hippo_no);
        new AlertDialog.Builder((Context)this.context).setMessage((CharSequence)msg).setPositiveButton((CharSequence)yes, (dialog, which) -> PaymentPlan.INSTANCE.deletePlan(this.context, position, planData, this)).setNegativeButton((CharSequence)no, (dialog, which) -> {}).show();
    }

    @Override
    public void onPaymentSent() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        } else {
            Toast.makeText((Context)this.context, (int)R.string.hippo_plan_sent, (int)0).show();
        }
    }

    @Override
    public void onPlanDeleted(int position) {
        Toast.makeText((Context)this.context, (int)R.string.hippo_plan_deleted, (int)0).show();
        if (this.plansList != null && this.plansList.size() > 0) {
            this.plansList.remove(position);
            this.adapter.notifyItemRemoved(position);
        }
        if (this.plansList != null && this.plansList.size() == 0) {
            this.noDataFound.setVisibility(0);
            this.rvAgents.setVisibility(8);
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void onPlanDeleteError(String message) {
        Toast.makeText((Context)this.context, (CharSequence)message, (int)0).show();
    }

    private void onPlanEdit(Activity activity, PlanData planData) {
        Intent paymentIntent = new Intent((Context)activity, HippoPaymentActivity.class);
        paymentIntent.putExtra("edit_plan", true);
        try {
            paymentIntent.putExtra("is_editable", planData.getUserId() == HippoApplication.getInstance().getUserData().getUserId().intValue());
        }
        catch (Exception e) {
            paymentIntent.putExtra("is_editable", false);
        }
        paymentIntent.putExtra("data", new Gson().toJson((Object)planData));
        activity.startActivityForResult(paymentIntent, 1536);
    }

    @Override
    public void onPaymentUpdate() {
    }
}

