/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.dialogs;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import com.hippoagent.R;
import com.hippoagent.langs.Restring;
import com.hippoagent.utils.Utils;

public class DialogPop {
    private AlertDialog alertDialog;

    public void alertPopupWithTwoButton(Context context, String title, String description, String positiveClickName, String negativeClickName, final Callback callback) {
        AlertDialog.Builder builder2 = new AlertDialog.Builder(context, R.style.AppCompatAlertDialogStyle);
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case -1: {
                        callback.onPositiveClick();
                        break;
                    }
                    case -2: {
                        callback.onNegativeClick();
                        break;
                    }
                }
            }
        };
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder2.setTitle((CharSequence)title);
        }
        builder2.setMessage((CharSequence)description);
        builder2.setPositiveButton((CharSequence)positiveClickName, listener);
        builder2.setNegativeButton((CharSequence)negativeClickName, listener);
        if (this.alertDialog == null) {
            this.alertDialog = builder2.create();
        } else {
            this.alertDialog.setMessage((CharSequence)description);
        }
        if (this.alertDialog.isShowing()) {
            this.alertDialog.dismiss();
        }
        this.alertDialog.show();
        Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/ProximaNova-Reg.ttf");
        TextView textView = (TextView)this.alertDialog.getWindow().findViewById(16908299);
        Button button1 = (Button)this.alertDialog.getWindow().findViewById(16908313);
        Button button2 = (Button)this.alertDialog.getWindow().findViewById(16908314);
        textView.setTypeface(typeface);
        button1.setTypeface(typeface);
        button2.setTypeface(typeface);
    }

    public void alertPopupWithEditText(final Context context, String title, String description, String positiveClickName, String negativeClickName, final CallbackListener callback) {
        AlertDialog.Builder builder2 = new AlertDialog.Builder(context, R.style.AppCompatAlertDialogStyle);
        LinearLayout container = new LinearLayout(context);
        container.setOrientation(1);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
        lp.setMargins(Utils.dp2px(context, 25.0f), 0, Utils.dp2px(context, 25.0f), 0);
        final EditText input = new EditText(context);
        input.setLayoutParams((ViewGroup.LayoutParams)lp);
        input.setInputType(16384);
        input.setSingleLine(false);
        input.setHint((CharSequence)Restring.getString(context, R.string.close_reason));
        input.setMaxLines(4);
        container.addView((View)input);
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case -2: {
                        callback.onNegativeClick();
                        break;
                    }
                }
            }
        };
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder2.setTitle((CharSequence)title);
        }
        builder2.setMessage((CharSequence)description);
        builder2.setPositiveButton((CharSequence)positiveClickName, null);
        builder2.setNegativeButton((CharSequence)negativeClickName, listener);
        AlertDialog alertDialog = builder2.create();
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                Button button = ((AlertDialog)dialog).getButton(-1);
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (!TextUtils.isEmpty((CharSequence)input.getText().toString().trim())) {
                            callback.onPositiveClick(input.getText().toString().trim());
                        } else {
                            Toast.makeText((Context)context, (CharSequence)"Please enter note", (int)1).show();
                        }
                    }
                });
            }
        });
        alertDialog.setCanceledOnTouchOutside(false);
        alertDialog.setCancelable(false);
        alertDialog.setView((View)container);
        alertDialog.show();
        Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/ProximaNova-Reg.ttf");
        TextView textView = (TextView)alertDialog.getWindow().findViewById(16908299);
        Button button1 = (Button)alertDialog.getWindow().findViewById(16908313);
        Button button2 = (Button)alertDialog.getWindow().findViewById(16908314);
        textView.setTypeface(typeface);
        textView.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.disable_text_color));
        button1.setTypeface(typeface);
        button2.setTypeface(typeface);
    }

    public static interface CallbackListener {
        public void onPositiveClick(String var1);

        public void onNegativeClick();
    }

    public static interface Callback {
        public void onPositiveClick();

        public void onNegativeClick();
    }
}

