/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.model.LoginResponse.Tag;
import java.util.ArrayList;

public class ShowTagsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ShowTagsListener tagsListener;
    private ArrayList<Tag> tagListAdapter;

    public ShowTagsAdapter(ArrayList<Tag> tagListAdapter, ShowTagsListener tagsListener) {
        this.tagsListener = tagsListener;
        this.tagListAdapter = tagListAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_tags, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, final int position) {
        if (viewholder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder)viewholder;
            final Tag tags = this.tagListAdapter.get(position);
            holder.tvLabel.setTag((Object)position);
            holder.tvLabel.setText((CharSequence)tags.getTagName());
            GradientDrawable gd = new GradientDrawable();
            gd.setShape(0);
            gd.setColor(Color.parseColor((String)tags.getColorCode()));
            gd.setStroke(2, Color.parseColor((String)tags.getColorCode()));
            gd.setCornerRadius(15.0f);
            holder.tvLabel.setBackground((Drawable)gd);
            if (tags.getStatus() == 1) {
                holder.tvLabel.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ic_single_tick_white, 0);
            } else {
                holder.tvLabel.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            }
            holder.tvLabel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (tags.getStatus() == 1) {
                        ((Tag)ShowTagsAdapter.this.tagListAdapter.get(position)).setStatus(0);
                    } else {
                        ((Tag)ShowTagsAdapter.this.tagListAdapter.get(position)).setStatus(1);
                    }
                    ShowTagsAdapter.this.tagsListener.onAssignTags(tags, tags.getStatus() == 1 ? 1 : 0);
                    ShowTagsAdapter.this.notifyItemChanged(position);
                }
            });
        }
    }

    public int getItemCount() {
        if (this.tagListAdapter == null || this.tagListAdapter.size() == 0) {
            return 0;
        }
        return this.tagListAdapter.size();
    }

    public static interface ShowTagsListener {
        public void onAssignTags(Tag var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public TextView tvLabel;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvLabel = (TextView)itemView.findViewById(R.id.tvLabel);
        }
    }
}

