/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.databinding.LayoutLoadmoreBinding;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.conversation_search.User;
import java.util.ArrayList;
import java.util.List;

public class PeopleAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context context;
    private List<User> peopleData = new ArrayList<User>();
    private PeopleClickListener peopleClickListener;
    private Integer totalItemCount;
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        if (viewType == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_loadmore, parent, false));
        }
        return new FuguTagging(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_people, parent, false));
    }

    public PeopleAdapter(List<User> peopleData, PeopleClickListener peopleClickListener) {
        this.peopleData = peopleData;
        this.peopleClickListener = peopleClickListener;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof FuguTagging) {
            FuguTagging holder1 = (FuguTagging)holder;
            holder1.tvPersonName.setText((CharSequence)this.peopleData.get(position).getFullName());
            holder1.tvPersonPhone.setText((CharSequence)this.peopleData.get(position).getPhoneNumber());
            holder1.tvPersonEmail.setText((CharSequence)this.peopleData.get(position).getEmail());
            if (HippoApplication.getInstance().getUserData().getBusinessProperty().getEnableAgentCustomerChat().equalsIgnoreCase("1")) {
                holder1.tvNewChat.setVisibility(0);
            } else {
                holder1.tvNewChat.setVisibility(8);
            }
        } else if (holder instanceof LoadMoreHolder) {
            LoadMoreHolder holder2 = (LoadMoreHolder)holder;
            ((LoadMoreHolder)holder2).loadmoreBinding.progressWheel.setVisibility(8);
            ((LoadMoreHolder)holder2).loadmoreBinding.tvLoadmore.setVisibility(0);
        }
    }

    public int getItemCount() {
        if (this.peopleData == null || this.peopleData.size() == 0) {
            return 0;
        }
        if (this.totalItemCount > this.peopleData.size()) {
            return this.peopleData.size() + 1;
        }
        return this.peopleData.size();
    }

    public int getItemViewType(int position) {
        try {
            if (this.isPositionFooter(position)) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private boolean isPositionFooter(int position) {
        return position == this.peopleData.size();
    }

    public void setData(ArrayList<User> peopleData, int totalItemCount) {
        this.peopleData = peopleData;
        this.totalItemCount = totalItemCount;
        this.notifyDataSetChanged();
    }

    public static interface PeopleClickListener {
        public void onItemClick(User var1);

        public void onNewChatClick(Conversation var1);

        public void onLoadMoreClick();
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        private LayoutLoadmoreBinding loadmoreBinding;

        public LoadMoreHolder(View itemView) {
            super(itemView);
            this.loadmoreBinding = (LayoutLoadmoreBinding)DataBindingUtil.bind((View)itemView);
            this.loadmoreBinding.rlMainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PeopleAdapter.this.peopleClickListener.onLoadMoreClick();
                }
            });
        }
    }

    class FuguTagging
    extends RecyclerView.ViewHolder {
        private TextView tvNewChat;
        private TextView tvPersonEmail;
        private TextView tvPersonPhone;
        private TextView tvPersonName;
        private LinearLayout llMain;

        public FuguTagging(View itemView) {
            super(itemView);
            this.tvNewChat = (TextView)itemView.findViewById(R.id.tvNewChat);
            this.tvPersonEmail = (TextView)itemView.findViewById(R.id.tvPersonEmail);
            this.tvPersonPhone = (TextView)itemView.findViewById(R.id.tvPersonPhone);
            this.tvPersonName = (TextView)itemView.findViewById(R.id.tvPersonName);
            this.llMain = (LinearLayout)itemView.findViewById(R.id.llMain);
            this.tvNewChat.setText((CharSequence)Restring.getString(PeopleAdapter.this.context, R.string.hippo_new_chat));
            this.llMain.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PeopleAdapter.this.peopleClickListener.onItemClick((User)PeopleAdapter.this.peopleData.get(FuguTagging.this.getAdapterPosition()));
                }
            });
            this.tvNewChat.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-5);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setUserId(((User)PeopleAdapter.this.peopleData.get(FuguTagging.this.getAdapterPosition())).getUserId());
                    conversation.setLabel(((User)PeopleAdapter.this.peopleData.get(FuguTagging.this.getAdapterPosition())).getFullName());
                    conversation.setUnreadCount(0);
                    PeopleAdapter.this.peopleClickListener.onNewChatClick(conversation);
                }
            });
        }
    }
}

