/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textfield.TextInputEditText;
import com.hippoagent.R;
import com.hippoagent.callback.OnItemOpertionListener;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.PaymentModelData;
import com.hippoagent.utils.DecimalDigitsInputFilter;
import com.hippoagent.utils.Log;
import java.util.ArrayList;

public class HippoPaymentAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = HippoPaymentAdapter.class.getSimpleName();
    private ArrayList<PaymentModelData> arrayList = new ArrayList();
    private Context context;
    private OnItemOpertionListener onItemOpertionListener;
    private int planType;
    String[] country;

    public HippoPaymentAdapter(ArrayList<PaymentModelData> arrayList, OnItemOpertionListener onItemOpertionListener, int planType, String[] country) {
        this.arrayList = arrayList;
        this.onItemOpertionListener = onItemOpertionListener;
        this.planType = planType;
        this.country = country;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_payment, parent, false), new MyFormEditTextListener(), new PriceEditTextListener(), new TitleEditTextListener());
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int position) {
        PaymentModelData paymentModelData = this.arrayList.get(position);
        viewHolder.titleView.setText((CharSequence)paymentModelData.getTitle());
        viewHolder.itemDescription.setText((CharSequence)paymentModelData.getItemDescription());
        viewHolder.itemPrice.setText((CharSequence)paymentModelData.getPrice());
        viewHolder.titleView.setHint((CharSequence)Restring.getString(this.context, R.string.hippo_enter_title));
        viewHolder.itemDescription.setHint((CharSequence)Restring.getString(this.context, R.string.hippo_item_description));
        viewHolder.itemPrice.setHint((CharSequence)Restring.getString(this.context, R.string.hippo_item_price));
        if (this.planType == 1) {
            viewHolder.titleView.setEnabled(false);
            viewHolder.itemDescription.setEnabled(false);
            viewHolder.itemPrice.setEnabled(false);
            viewHolder.crossButton.setVisibility(8);
            viewHolder.spinner.setVisibility(8);
        } else {
            viewHolder.titleView.setEnabled(true);
            viewHolder.itemDescription.setEnabled(true);
            viewHolder.itemPrice.setEnabled(true);
            if (this.arrayList.size() == 1) {
                viewHolder.crossButton.setVisibility(8);
            } else {
                viewHolder.crossButton.setVisibility(0);
            }
        }
        ArrayAdapter aa = new ArrayAdapter(this.context, R.layout.spinner_row, (Object[])this.country);
        aa.setDropDownViewResource(0x1090009);
        viewHolder.spinner.setAdapter((SpinnerAdapter)aa);
        String symbol = this.country[paymentModelData.getPosition()];
        viewHolder.spinner.setSelection(paymentModelData.getPosition(), true);
        viewHolder.selectedCurrency.setText((CharSequence)symbol);
        if (!TextUtils.isEmpty((CharSequence)paymentModelData.getErrorTitle()) && TextUtils.isEmpty((CharSequence)paymentModelData.getTitle())) {
            viewHolder.titleView.requestFocus();
            viewHolder.titleView.setError((CharSequence)paymentModelData.getErrorTitle());
        } else {
            viewHolder.titleView.setError(null);
        }
        if (!TextUtils.isEmpty((CharSequence)paymentModelData.getErrorDesc()) && TextUtils.isEmpty((CharSequence)paymentModelData.getItemDescription())) {
            viewHolder.itemDescription.requestFocus();
            viewHolder.itemDescription.setError((CharSequence)paymentModelData.getErrorDesc());
        } else {
            viewHolder.itemDescription.setError(null);
        }
        if (!TextUtils.isEmpty((CharSequence)paymentModelData.getErrorPrice())) {
            viewHolder.itemPrice.requestFocus();
            viewHolder.itemPrice.setError((CharSequence)paymentModelData.getErrorPrice());
        } else {
            viewHolder.itemPrice.setError(null);
        }
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    public void updateEnabled(int planType) {
        this.planType = planType;
        this.notifyDataSetChanged();
    }

    public class TitleEditTextListener
    implements TextWatcher {
        private int position;
        private boolean isEdittable;

        public void updatePosition(int position) {
            this.position = position;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void afterTextChanged(Editable editable) {
            if (!TextUtils.isEmpty((CharSequence)editable.toString()) && this.isEdittable) {
                ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(this.position)).setPrice(editable.toString());
            }
            this.isEdittable = true;
        }
    }

    public class PriceEditTextListener
    implements TextWatcher {
        private int position;
        private boolean isEdittable;

        public void updatePosition(int position) {
            this.position = position;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void afterTextChanged(Editable editable) {
            if (!TextUtils.isEmpty((CharSequence)editable.toString()) && this.isEdittable) {
                ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(this.position)).setPrice(editable.toString());
            }
            this.isEdittable = true;
        }
    }

    public class MyFormEditTextListener
    implements TextWatcher {
        private int position;
        private boolean isEdittable;

        public void updatePosition(int position) {
            this.position = position;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void afterTextChanged(Editable editable) {
            if (!TextUtils.isEmpty((CharSequence)editable.toString()) && this.isEdittable) {
                ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(this.position)).setItemDescription(editable.toString());
            }
            this.isEdittable = true;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private MyFormEditTextListener myCustomEditTextListener;
        private PriceEditTextListener priceEditTextListener;
        private TitleEditTextListener titleEditTextListener;
        private EditText itemPrice;
        private TextInputEditText titleView;
        private TextInputEditText itemDescription;
        private TextView priceTxt;
        private TextView descTxt;
        private TextView title_txt;
        private RelativeLayout crossButton;
        private ImageView crossView;
        private Spinner spinner;
        private TextView selectedCurrency;
        private boolean isSelected;

        public ViewHolder(View itemView, MyFormEditTextListener myCustomEditTextListener, PriceEditTextListener priceEditTextListener, TitleEditTextListener titleEditTextListener) {
            super(itemView);
            this.titleView = (TextInputEditText)itemView.findViewById(R.id.titie_view);
            this.itemDescription = (TextInputEditText)itemView.findViewById(R.id.item_description);
            this.itemPrice = (EditText)itemView.findViewById(R.id.item_price);
            this.spinner = (Spinner)itemView.findViewById(R.id.spinner);
            this.selectedCurrency = (TextView)itemView.findViewById(R.id.selectedCurrency);
            this.title_txt = (TextView)itemView.findViewById(R.id.title_txt);
            this.descTxt = (TextView)itemView.findViewById(R.id.descTxt);
            this.priceTxt = (TextView)itemView.findViewById(R.id.priceTxt);
            this.itemPrice.setFilters(new InputFilter[]{new DecimalDigitsInputFilter(6, 2)});
            this.title_txt.setText((CharSequence)Restring.getString(HippoPaymentAdapter.this.context, R.string.title));
            this.descTxt.setText((CharSequence)Restring.getString(HippoPaymentAdapter.this.context, R.string.hippo_title_item_description));
            this.priceTxt.setText((CharSequence)Restring.getString(HippoPaymentAdapter.this.context, R.string.hippo_title_item_price));
            this.titleEditTextListener = titleEditTextListener;
            this.myCustomEditTextListener = myCustomEditTextListener;
            this.priceEditTextListener = priceEditTextListener;
            this.crossButton = (RelativeLayout)itemView.findViewById(R.id.cross_button);
            this.crossButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (HippoPaymentAdapter.this.onItemOpertionListener != null) {
                        HippoPaymentAdapter.this.onItemOpertionListener.onItemRemoved(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.selectedCurrency.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (HippoPaymentAdapter.this.planType != 1) {
                        ViewHolder.this.isSelected = true;
                        ViewHolder.this.spinner.performClick();
                    }
                }
            });
            this.spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    if (ViewHolder.this.isSelected) {
                        ViewHolder.this.selectedCurrency.setText((CharSequence)HippoPaymentAdapter.this.country[position]);
                        ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setPosition(position);
                    }
                }

                public void onNothingSelected(AdapterView<?> parent) {
                    Log.e("onNothingSelected", "onNothingSelected");
                }
            });
            this.titleView.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setTitle(ViewHolder.this.titleView.getText().toString().trim());
                    if (!TextUtils.isEmpty((CharSequence)ViewHolder.this.titleView.getText().toString())) {
                        ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setErrorTitle(null);
                    }
                }

                public void afterTextChanged(Editable editable) {
                }
            });
            this.itemDescription.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setItemDescription(ViewHolder.this.itemDescription.getText().toString().trim());
                    if (!TextUtils.isEmpty((CharSequence)ViewHolder.this.itemDescription.getText().toString())) {
                        ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setErrorDesc(null);
                    }
                }

                public void afterTextChanged(Editable editable) {
                }
            });
            this.itemPrice.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setPrice(ViewHolder.this.itemPrice.getText().toString().trim());
                    if (!TextUtils.isEmpty((CharSequence)ViewHolder.this.itemPrice.getText().toString().trim())) {
                        Double aDouble1 = null;
                        try {
                            aDouble1 = Double.parseDouble(ViewHolder.this.itemPrice.getText().toString().trim());
                            ((PaymentModelData)HippoPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setErrorPrice(null);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }

                public void afterTextChanged(Editable editable) {
                    if (HippoPaymentAdapter.this.onItemOpertionListener != null) {
                        HippoPaymentAdapter.this.onItemOpertionListener.onItemAdded();
                    }
                }
            });
            this.itemDescription.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (ViewHolder.this.itemDescription.hasFocus()) {
                        v.getParent().requestDisallowInterceptTouchEvent(true);
                        switch (event.getAction() & 0xFF) {
                            case 8: {
                                v.getParent().requestDisallowInterceptTouchEvent(false);
                                return true;
                            }
                        }
                    }
                    return false;
                }
            });
        }
    }
}

