/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.callback.OnItemOpertionListener;
import com.hippoagent.model.PaymentModelData;
import java.util.ArrayList;

public class HippoOldPaymentAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = HippoOldPaymentAdapter.class.getSimpleName();
    private ArrayList<PaymentModelData> arrayList = new ArrayList();
    private Context context;
    private OnItemOpertionListener onItemOpertionListener;

    public HippoOldPaymentAdapter(ArrayList<PaymentModelData> arrayList, OnItemOpertionListener onItemOpertionListener) {
        this.arrayList = arrayList;
        this.onItemOpertionListener = onItemOpertionListener;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_old_payment, parent, false), new MyFormEditTextListener(), new PriceEditTextListener());
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int position) {
        PaymentModelData paymentModelData = this.arrayList.get(position);
        viewHolder.itemDescription.setText((CharSequence)paymentModelData.getItemDescription());
        viewHolder.itemPrice.setText((CharSequence)paymentModelData.getPrice());
        if (!TextUtils.isEmpty((CharSequence)paymentModelData.getErrorDesc()) && TextUtils.isEmpty((CharSequence)paymentModelData.getItemDescription())) {
            viewHolder.itemDescription.setError((CharSequence)paymentModelData.getErrorDesc());
        } else {
            viewHolder.itemDescription.setError(null);
        }
        if (TextUtils.isEmpty((CharSequence)paymentModelData.getPrice())) {
            viewHolder.itemPrice.setError((CharSequence)paymentModelData.getErrorPrice());
        } else {
            viewHolder.itemPrice.setError(null);
        }
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    public class PriceEditTextListener
    implements TextWatcher {
        private int position;
        private boolean isEdittable;

        public void updatePosition(int position) {
            this.position = position;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void afterTextChanged(Editable editable) {
            if (!TextUtils.isEmpty((CharSequence)editable.toString()) && this.isEdittable) {
                ((PaymentModelData)HippoOldPaymentAdapter.this.arrayList.get(this.position)).setPrice(editable.toString());
            }
            this.isEdittable = true;
        }
    }

    public class MyFormEditTextListener
    implements TextWatcher {
        private int position;
        private boolean isEdittable;

        public void updatePosition(int position) {
            this.position = position;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void afterTextChanged(Editable editable) {
            if (!TextUtils.isEmpty((CharSequence)editable.toString()) && this.isEdittable) {
                ((PaymentModelData)HippoOldPaymentAdapter.this.arrayList.get(this.position)).setItemDescription(editable.toString());
            }
            this.isEdittable = true;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private MyFormEditTextListener myCustomEditTextListener;
        private PriceEditTextListener priceEditTextListener;
        private EditText itemDescription;
        private EditText itemPrice;
        private RelativeLayout crossButton;
        private ImageView crossView;

        public ViewHolder(View itemView, MyFormEditTextListener myCustomEditTextListener, PriceEditTextListener priceEditTextListener) {
            super(itemView);
            this.itemDescription = (EditText)itemView.findViewById(R.id.item_description);
            this.itemPrice = (EditText)itemView.findViewById(R.id.item_price);
            this.myCustomEditTextListener = myCustomEditTextListener;
            this.priceEditTextListener = priceEditTextListener;
            this.crossButton = (RelativeLayout)itemView.findViewById(R.id.cross_button);
            this.crossButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    HippoOldPaymentAdapter.this.onItemOpertionListener.onItemRemoved(ViewHolder.this.getAdapterPosition());
                }
            });
            this.crossView = (ImageView)itemView.findViewById(R.id.image_cross);
            this.itemDescription.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    ((PaymentModelData)HippoOldPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setItemDescription(ViewHolder.this.itemDescription.getText().toString().trim());
                }

                public void afterTextChanged(Editable editable) {
                }
            });
            this.itemPrice.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    ((PaymentModelData)HippoOldPaymentAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setPrice(ViewHolder.this.itemPrice.getText().toString().trim());
                }

                public void afterTextChanged(Editable editable) {
                    if (HippoOldPaymentAdapter.this.onItemOpertionListener != null) {
                        HippoOldPaymentAdapter.this.onItemOpertionListener.onItemAdded();
                    }
                }
            });
            this.itemDescription.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (ViewHolder.this.itemDescription.hasFocus()) {
                        v.getParent().requestDisallowInterceptTouchEvent(true);
                        switch (event.getAction() & 0xFF) {
                            case 8: {
                                v.getParent().requestDisallowInterceptTouchEvent(false);
                                return true;
                            }
                        }
                    }
                    return false;
                }
            });
        }
    }
}

